/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.crypto.test.dsig;

import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import javax.xml.crypto.dsig.DigestMethod;
import javax.xml.crypto.dsig.XMLSignatureFactory;
import javax.xml.crypto.test.dsig.TestUtils;
import org.apache.jcp.xml.dsig.internal.dom.XMLDSigRI;
import org.junit.Assert;
import org.junit.Test;

public class DigestMethodTest
extends Assert {
    private XMLSignatureFactory factory = XMLSignatureFactory.getInstance("DOM", (Provider)new XMLDSigRI());
    private static final String[] MD_ALGOS = new String[]{"http://www.w3.org/2000/09/xmldsig#sha1"};

    @Test
    public void testisFeatureSupported() throws Exception {
        for (int i = 0; i < MD_ALGOS.length; ++i) {
            String string = MD_ALGOS[i];
            DigestMethod digestMethod = this.factory.newDigestMethod(string, null);
            try {
                digestMethod.isFeatureSupported(null);
                DigestMethodTest.fail((String)"Should raise a NPE for null feature");
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            DigestMethodTest.assertTrue((!digestMethod.isFeatureSupported("not supported") ? 1 : 0) != 0);
        }
    }

    @Test
    public void testConstructor() throws Exception {
        DigestMethod digestMethod;
        for (int i = 0; i < MD_ALGOS.length; ++i) {
            String string = MD_ALGOS[i];
            digestMethod = this.factory.newDigestMethod(string, null);
            DigestMethodTest.assertEquals((Object)digestMethod.getAlgorithm(), (Object)string);
            DigestMethodTest.assertNull((Object)digestMethod.getParameterSpec());
            try {
                digestMethod = this.factory.newDigestMethod(string, new TestUtils.MyOwnDigestMethodParameterSpec());
                DigestMethodTest.fail((String)"Should raise an IAPE for invalid parameters");
                continue;
            }
            catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
                continue;
            }
            catch (Exception exception) {
                DigestMethodTest.fail((String)("Should raise an IAPE instead of " + exception));
            }
        }
        try {
            digestMethod = this.factory.newDigestMethod("non-existent", null);
            DigestMethodTest.fail((String)"Should raise an NSAE for non-existent algos");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            // empty catch block
        }
        try {
            digestMethod = this.factory.newDigestMethod(null, null);
            DigestMethodTest.fail((String)"Should raise a NPE for null algo");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }
}

