/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.crypto.test.dsig;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.security.Provider;
import java.security.Security;
import javax.xml.crypto.Data;
import javax.xml.crypto.OctetStreamData;
import javax.xml.crypto.URIDereferencer;
import javax.xml.crypto.URIReference;
import javax.xml.crypto.URIReferenceException;
import javax.xml.crypto.XMLCryptoContext;
import javax.xml.crypto.dsig.XMLSignatureFactory;
import javax.xml.crypto.test.KeySelectors;
import javax.xml.crypto.test.dsig.SignatureValidator;
import org.apache.jcp.xml.dsig.internal.dom.XMLDSigRI;
import org.junit.Assert;
import org.junit.Test;

public class IaikCoreFeaturesTest
extends Assert {
    private SignatureValidator validator;
    private String base;

    public IaikCoreFeaturesTest() {
        String string = System.getProperty("file.separator");
        this.base = System.getProperty("basedir") == null ? "./" : System.getProperty("basedir");
        this.base = this.base + string + "src/test/resources" + string + "at" + string + "iaik" + string + "ixsil";
        this.validator = new SignatureValidator(new File(this.base, "coreFeatures/signatures"));
    }

    @Test
    public void test_anonymousReferenceSignature() throws Exception {
        String string = "anonymousReferenceSignature.xml";
        boolean bl = this.validator.validate(string, new KeySelectors.KeyValueKeySelector(), new NullURIDereferencer(this.base));
        IaikCoreFeaturesTest.assertTrue((String)"Signature failed core validation", (boolean)bl);
    }

    @Test
    public void test_manifestSignature() throws Exception {
        String string = "manifestSignature.xml";
        boolean bl = this.validator.validate(string, new KeySelectors.KeyValueKeySelector());
        IaikCoreFeaturesTest.assertTrue((String)"Signature failed core validation", (boolean)bl);
    }

    @Test
    public void test_signatureTypesSignature() throws Exception {
        String string = "signatureTypesSignature.xml";
        boolean bl = this.validator.validate(string, new KeySelectors.KeyValueKeySelector(), new OfflineDereferencer());
        IaikCoreFeaturesTest.assertTrue((String)"Signature failed core validation", (boolean)bl);
    }

    static {
        Security.insertProviderAt((Provider)new XMLDSigRI(), 1);
    }

    private static class OfflineDereferencer
    implements URIDereferencer {
        private String w3cRec;
        private URIDereferencer defaultDereferencer;

        OfflineDereferencer() throws Exception {
            String string = System.getProperty("file.separator");
            String string2 = System.getProperty("basedir") == null ? "./" : System.getProperty("basedir");
            this.w3cRec = string2 + string + "src/test/resources" + string + "org" + string + "w3c" + string + "www" + string + "TR" + string + "2000";
            this.defaultDereferencer = XMLSignatureFactory.getInstance().getURIDereferencer();
        }

        public Data dereference(URIReference uRIReference, XMLCryptoContext xMLCryptoContext) throws URIReferenceException {
            try {
                if ("http://www.w3.org/TR/2000/REC-xml-20001006".equals(uRIReference.getURI())) {
                    File file = new File(this.w3cRec, "REC-xml-20001006");
                    return new OctetStreamData(new FileInputStream(file));
                }
                return this.defaultDereferencer.dereference(uRIReference, xMLCryptoContext);
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new URIReferenceException(fileNotFoundException.getMessage(), fileNotFoundException);
            }
        }
    }

    private static class NullURIDereferencer
    implements URIDereferencer {
        private OctetStreamData osd;

        NullURIDereferencer(String string) throws Exception {
            File file = new File(string, "coreFeatures/samples/anonymousReferenceContent.xml");
            this.osd = new OctetStreamData(new FileInputStream(file));
        }

        public Data dereference(URIReference uRIReference, XMLCryptoContext xMLCryptoContext) throws URIReferenceException {
            if (uRIReference.getURI() != null) {
                throw new URIReferenceException("must be a null URI");
            }
            return this.osd;
        }
    }
}

