/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.crypto.test.dsig;

import java.io.File;
import java.security.Provider;
import java.security.Security;
import javax.xml.crypto.dsig.XMLSignatureException;
import javax.xml.crypto.test.KeySelectors;
import javax.xml.crypto.test.dsig.SignatureValidator;
import org.apache.jcp.xml.dsig.internal.dom.XMLDSigRI;
import org.junit.Assert;
import org.junit.Test;

public class IaikSignatureAlgosTest
extends Assert {
    private SignatureValidator validator;

    public IaikSignatureAlgosTest() {
        String string = System.getProperty("file.separator");
        String string2 = System.getProperty("basedir") == null ? "./" : System.getProperty("basedir");
        string2 = string2 + string + "src/test/resources" + string + "at" + string + "iaik" + string + "ixsil";
        this.validator = new SignatureValidator(new File(string2, "signatureAlgorithms/signatures"));
    }

    @Test
    public void test_dsaSignature() throws Exception {
        String string = "dSASignature.xml";
        boolean bl = this.validator.validate(string, new KeySelectors.KeyValueKeySelector());
        IaikSignatureAlgosTest.assertTrue((String)"Signature failed core validation", (boolean)bl);
    }

    @Test
    public void test_rsaSignature() throws Exception {
        String string = "rSASignature.xml";
        boolean bl = this.validator.validate(string, new KeySelectors.KeyValueKeySelector());
        IaikSignatureAlgosTest.assertTrue((String)"Signature failed core validation", (boolean)bl);
    }

    @Test
    public void test_hmacShortSignature() throws Exception {
        String string = "hMACShortSignature.xml";
        try {
            this.validator.validate(string, new KeySelectors.SecretKeySelector("secret".getBytes("ASCII")));
            IaikSignatureAlgosTest.fail((String)"Expected HMACOutputLength Exception");
        }
        catch (XMLSignatureException xMLSignatureException) {
            // empty catch block
        }
    }

    @Test
    public void test_hmacSignature() throws Exception {
        String string = "hMACSignature.xml";
        boolean bl = this.validator.validate(string, new KeySelectors.SecretKeySelector("secret".getBytes("ASCII")));
        IaikSignatureAlgosTest.assertTrue((String)"Signature failed core validation", (boolean)bl);
    }

    static {
        Security.insertProviderAt((Provider)new XMLDSigRI(), 1);
    }
}

