/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.crypto.test.dsig;

import java.io.File;
import java.security.Provider;
import java.security.Security;
import javax.xml.crypto.test.KeySelectors;
import javax.xml.crypto.test.dsig.SignatureValidator;
import org.apache.jcp.xml.dsig.internal.dom.XMLDSigRI;
import org.junit.Assert;
import org.junit.Test;

public class IaikTransformsTest
extends Assert {
    private SignatureValidator validator;

    public IaikTransformsTest() {
        String string = System.getProperty("file.separator");
        String string2 = System.getProperty("basedir") == null ? "./" : System.getProperty("basedir");
        string2 = string2 + string + "src/test/resources" + string + "at" + string + "iaik" + string + "ixsil";
        this.validator = new SignatureValidator(new File(string2, "transforms/signatures"));
    }

    @Test
    public void test_base64DecodeSignature() throws Exception {
        String string = "base64DecodeSignature.xml";
        boolean bl = this.validator.validate(string, new KeySelectors.KeyValueKeySelector());
        IaikTransformsTest.assertTrue((String)"Signature failed core validation", (boolean)bl);
    }

    @Test
    public void test_envelopedSignatureSignature() throws Exception {
        String string = "envelopedSignatureSignature.xml";
        boolean bl = this.validator.validate(string, new KeySelectors.KeyValueKeySelector());
        IaikTransformsTest.assertTrue((String)"Signature failed core validation", (boolean)bl);
    }

    @Test
    public void test_c14nSignature() throws Exception {
        String string = "c14nSignature.xml";
        boolean bl = this.validator.validate(string, new KeySelectors.KeyValueKeySelector());
        IaikTransformsTest.assertTrue((String)"Signature failed core validation", (boolean)bl);
    }

    @Test
    public void test_xPathSignature() throws Exception {
        String string = "xPathSignature.xml";
        boolean bl = this.validator.validate(string, new KeySelectors.KeyValueKeySelector());
        IaikTransformsTest.assertTrue((String)"Signature failed core validation", (boolean)bl);
    }

    static {
        Security.insertProviderAt((Provider)new XMLDSigRI(), 1);
    }
}

