/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.crypto.test.dsig;

import java.io.File;
import java.security.Provider;
import java.security.Security;
import javax.xml.crypto.test.KeySelectors;
import javax.xml.crypto.test.dsig.SignatureValidator;
import org.apache.jcp.xml.dsig.internal.dom.XMLDSigRI;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

public class InteropC14nTest
extends Assert {
    private SignatureValidator validator = null;
    private String base;

    public InteropC14nTest() {
        String string = System.getProperty("file.separator");
        this.base = System.getProperty("basedir") == null ? "./" : System.getProperty("basedir");
        this.base = this.base + string + "src/test/resources" + string + "interop";
    }

    @Test
    public void test_y1_exc_signature() throws Exception {
        this.validator = new SignatureValidator(new File(this.base, "c14n/Y1"));
        String string = "exc-signature.xml";
        boolean bl = this.validator.validate(string, new KeySelectors.KeyValueKeySelector());
        InteropC14nTest.assertTrue((String)"Signature failed core validation", (boolean)bl);
    }

    @Test
    public void test_y3_signature() throws Exception {
        this.validator = new SignatureValidator(new File(this.base, "c14n/Y3"));
        String string = "signature.xml";
        boolean bl = this.validator.validate(string, new KeySelectors.KeyValueKeySelector());
        InteropC14nTest.assertTrue((String)"Signature failed core validation#1", (boolean)bl);
        bl = this.validator.validate(string, new KeySelectors.RawX509KeySelector());
        InteropC14nTest.assertTrue((String)"Signature failed core validation#2", (boolean)bl);
    }

    @Test
    public void test_y4_signature() throws Exception {
        this.validator = new SignatureValidator(new File(this.base, "c14n/Y4"));
        String string = "signature.xml";
        boolean bl = this.validator.validate(string, new KeySelectors.KeyValueKeySelector());
        InteropC14nTest.assertTrue((String)"Signature failed core validation#1", (boolean)bl);
        bl = this.validator.validate(string, new KeySelectors.RawX509KeySelector());
        InteropC14nTest.assertTrue((String)"Signature failed core validation#2", (boolean)bl);
    }

    @Test
    @Ignore
    public void test_y5_signature() throws Exception {
        this.validator = new SignatureValidator(new File(this.base, "c14n/Y5"));
        String string = "signature.xml";
        boolean bl = this.validator.validate(string, new KeySelectors.KeyValueKeySelector());
        InteropC14nTest.assertTrue((String)"Signature failed core validation#1", (boolean)bl);
        bl = this.validator.validate(string, new KeySelectors.RawX509KeySelector());
        InteropC14nTest.assertTrue((String)"Signature failed core validation#2", (boolean)bl);
    }

    @Test
    @Ignore
    public void test_y5_signatureCommented() throws Exception {
        this.validator = new SignatureValidator(new File(this.base, "c14n/Y5"));
        String string = "signatureCommented.xml";
        boolean bl = this.validator.validate(string, new KeySelectors.KeyValueKeySelector());
        InteropC14nTest.assertTrue((String)"Signature failed core validation#1", (boolean)bl);
        bl = this.validator.validate(string, new KeySelectors.RawX509KeySelector());
        InteropC14nTest.assertTrue((String)"Signature failed core validation#2", (boolean)bl);
    }

    static {
        Security.insertProviderAt((Provider)new XMLDSigRI(), 1);
    }
}

