/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.crypto.test.dsig;

import java.io.File;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.Security;
import javax.xml.crypto.KeySelector;
import javax.xml.crypto.test.KeySelectors;
import javax.xml.crypto.test.dsig.SignatureValidator;
import org.apache.jcp.xml.dsig.internal.dom.XMLDSigRI;
import org.junit.Assert;
import org.junit.Test;

public class InteropXMLDSig11Test
extends Assert {
    private SignatureValidator validator;
    private File dir;
    private KeySelector kvks;
    private KeySelector sks;
    private boolean ecSupport = true;

    public InteropXMLDSig11Test() throws Exception {
        try {
            KeyFactory.getInstance("EC");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            this.ecSupport = false;
        }
        String string = File.separator;
        String string2 = System.getProperty("basedir") == null ? "./" : System.getProperty("basedir");
        this.dir = new File(string2 + string + "src/test/resources" + string + "org" + string + "w3c" + string + "www" + string + "interop" + string + "xmldsig11");
        this.validator = new SignatureValidator(this.dir);
        this.kvks = new KeySelectors.KeyValueKeySelector();
        this.sks = new KeySelectors.SecretKeySelector("testkey".getBytes("ASCII"));
    }

    @Test
    public void test_enveloping_p256_sha1() throws Exception {
        if (this.ecSupport) {
            this.test_xmldsig11("signature-enveloping-p256_sha1", "oracle");
        }
    }

    @Test
    public void test_enveloping_p256_sha256() throws Exception {
        if (this.ecSupport) {
            this.test_xmldsig11("signature-enveloping-p256_sha256", "oracle");
        }
    }

    @Test
    public void test_enveloping_p256_sha384() throws Exception {
        if (this.ecSupport) {
            this.test_xmldsig11("signature-enveloping-p256_sha384", "oracle");
        }
    }

    @Test
    public void test_enveloping_p256_sha512() throws Exception {
        if (this.ecSupport) {
            this.test_xmldsig11("signature-enveloping-p256_sha512", "oracle");
        }
    }

    @Test
    public void test_enveloping_p384_sha1() throws Exception {
        if (this.ecSupport) {
            this.test_xmldsig11("signature-enveloping-p384_sha1", "oracle");
        }
    }

    @Test
    public void test_enveloping_p384_sha256() throws Exception {
        if (this.ecSupport) {
            this.test_xmldsig11("signature-enveloping-p384_sha256", "oracle");
        }
    }

    @Test
    public void test_enveloping_p384_sha384() throws Exception {
        if (this.ecSupport) {
            this.test_xmldsig11("signature-enveloping-p384_sha384", "oracle");
        }
    }

    @Test
    public void test_enveloping_p384_sha512() throws Exception {
        if (this.ecSupport) {
            this.test_xmldsig11("signature-enveloping-p384_sha512", "oracle");
        }
    }

    @Test
    public void test_enveloping_p521_sha1() throws Exception {
        if (this.ecSupport) {
            this.test_xmldsig11("signature-enveloping-p521_sha1", "oracle");
        }
    }

    @Test
    public void test_enveloping_p521_sha256() throws Exception {
        if (this.ecSupport) {
            this.test_xmldsig11("signature-enveloping-p521_sha256", "oracle");
        }
    }

    @Test
    public void test_enveloping_p521_sha384() throws Exception {
        if (this.ecSupport) {
            this.test_xmldsig11("signature-enveloping-p521_sha384", "oracle");
        }
    }

    @Test
    public void test_enveloping_p521_sha512() throws Exception {
        if (this.ecSupport) {
            this.test_xmldsig11("signature-enveloping-p521_sha512", "oracle");
        }
    }

    @Test
    public void test_enveloping_rsa_sha256() throws Exception {
        this.test_xmldsig11("signature-enveloping-rsa-sha256", "oracle");
    }

    @Test
    public void test_enveloping_rsa_sha384() throws Exception {
        this.test_xmldsig11("signature-enveloping-rsa_sha384", "oracle");
    }

    @Test
    public void test_enveloping_rsa_sha512() throws Exception {
        this.test_xmldsig11("signature-enveloping-rsa_sha512", "oracle");
    }

    @Test
    public void test_enveloping_sha256_rsa_sha256() throws Exception {
        this.test_xmldsig11("signature-enveloping-sha256-rsa-sha256", "oracle");
    }

    @Test
    public void test_enveloping_sha384_rsa_sha256() throws Exception {
        this.test_xmldsig11("signature-enveloping-sha384-rsa_sha256", "oracle");
    }

    @Test
    public void test_enveloping_sha512_rsa_sha256() throws Exception {
        this.test_xmldsig11("signature-enveloping-sha512-rsa_sha256", "oracle");
    }

    @Test
    public void test_enveloping_hmac_sha256() throws Exception {
        this.test_xmldsig11("signature-enveloping-hmac-sha256", this.sks, "oracle");
    }

    @Test
    public void test_enveloping_hmac_sha384() throws Exception {
        this.test_xmldsig11("signature-enveloping-hmac-sha384", this.sks, "oracle");
    }

    @Test
    public void test_enveloping_hmac_sha512() throws Exception {
        this.test_xmldsig11("signature-enveloping-hmac-sha512", this.sks, "oracle");
    }

    private void test_xmldsig11(String string, String string2) throws Exception {
        String string3 = string2 + File.separator + string + ".xml";
        boolean bl = this.validator.validate(string3, this.kvks);
        InteropXMLDSig11Test.assertTrue((String)(string3 + " failed core validation"), (boolean)bl);
    }

    private void test_xmldsig11(String string, KeySelector keySelector, String string2) throws Exception {
        String string3 = string2 + File.separator + string + ".xml";
        boolean bl = this.validator.validate(string3, keySelector);
        InteropXMLDSig11Test.assertTrue((String)(string3 + " failed core validation"), (boolean)bl);
    }

    static {
        Security.insertProviderAt((Provider)new XMLDSigRI(), 1);
    }
}

