/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.crypto.test.dsig;

import java.io.File;
import java.security.Provider;
import java.security.Security;
import javax.xml.crypto.dsig.XMLSignatureException;
import javax.xml.crypto.dsig.dom.DOMValidateContext;
import javax.xml.crypto.test.KeySelectors;
import javax.xml.crypto.test.dsig.SignatureValidator;
import org.apache.jcp.xml.dsig.internal.dom.XMLDSigRI;
import org.junit.Assert;
import org.junit.Test;

public class JSRForbiddenReferenceTest
extends Assert {
    private SignatureValidator validator;
    private File dir;

    public JSRForbiddenReferenceTest() {
        String string = System.getProperty("file.separator");
        String string2 = System.getProperty("basedir") == null ? "./" : System.getProperty("basedir");
        this.dir = new File(string2 + string + "src/test/resources" + string + "javax" + string + "xml" + string + "crypto", "dsig");
        this.validator = new SignatureValidator(this.dir);
    }

    @Test
    public void testLocalFilesystem() throws Exception {
        String string = "signature-external-c14n-xmlatrs.xml";
        DOMValidateContext dOMValidateContext = this.validator.getValidateContext(string, new KeySelectors.SecretKeySelector("secret".getBytes("ASCII")));
        dOMValidateContext.setProperty("org.apache.jcp.xml.dsig.secureValidation", Boolean.FALSE);
        boolean bl = this.validator.validate(dOMValidateContext);
        JSRForbiddenReferenceTest.assertTrue((String)"Signature failed core validation", (boolean)bl);
        dOMValidateContext.setProperty("org.apache.jcp.xml.dsig.secureValidation", Boolean.TRUE);
        try {
            this.validator.validate(dOMValidateContext);
            JSRForbiddenReferenceTest.fail((String)"Failure expected when secure validation is enabled");
        }
        catch (XMLSignatureException xMLSignatureException) {
            JSRForbiddenReferenceTest.assertTrue((boolean)xMLSignatureException.getMessage().contains("URIReferenceException"));
        }
    }

    static {
        Security.insertProviderAt((Provider)new XMLDSigRI(), 1);
    }
}

