/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.crypto.test.dsig;

import java.io.File;
import java.security.Provider;
import java.security.Security;
import javax.xml.crypto.dsig.XMLSignatureException;
import javax.xml.crypto.dsig.dom.DOMValidateContext;
import javax.xml.crypto.test.KeySelectors;
import javax.xml.crypto.test.dsig.SignatureValidator;
import org.apache.jcp.xml.dsig.internal.dom.XMLDSigRI;
import org.apache.xml.security.utils.XMLUtils;
import org.junit.Assert;
import org.junit.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class JSRWrappingAttackTest
extends Assert {
    private SignatureValidator validator;
    private File dir;

    public JSRWrappingAttackTest() {
        String string = System.getProperty("file.separator");
        String string2 = System.getProperty("basedir") == null ? "./" : System.getProperty("basedir");
        this.dir = new File(string2 + string + "src/test/resources" + string + "at" + string + "iaik" + string + "ixsil" + string + "coreFeatures", "signatures");
        this.validator = new SignatureValidator(this.dir);
    }

    @Test
    public void testWrappingAttack() throws Exception {
        String string = "manifestSignatureWrapping.xml";
        Document document = XMLUtils.createDocumentBuilder((boolean)false, (boolean)false).parse(new File(this.dir, string));
        Element element = SignatureValidator.getSignatureElement(document);
        if (element == null) {
            throw new Exception("Couldn't find signature Element");
        }
        DOMValidateContext dOMValidateContext = new DOMValidateContext(new KeySelectors.KeyValueKeySelector(), (Node)element);
        dOMValidateContext.setBaseURI(this.dir.toURI().toString());
        dOMValidateContext.setProperty("org.apache.jcp.xml.dsig.secureValidation", Boolean.FALSE);
        boolean bl = this.validator.validate(dOMValidateContext);
        JSRWrappingAttackTest.assertTrue((String)"Signature failed core validation", (boolean)bl);
        dOMValidateContext.setProperty("org.apache.jcp.xml.dsig.secureValidation", Boolean.TRUE);
        Element element2 = (Element)document.getElementsByTagName("Manifest").item(0);
        dOMValidateContext.setIdAttributeNS(element2, null, "Id");
        try {
            boolean bl2 = this.validator.validate(dOMValidateContext);
            System.out.println("Valid: " + bl2);
            JSRWrappingAttackTest.fail((String)"Failure expected when secure validation is enabled");
        }
        catch (XMLSignatureException xMLSignatureException) {
            JSRWrappingAttackTest.assertTrue((boolean)xMLSignatureException.getMessage().contains("URIReferenceException"));
        }
    }

    static {
        Security.insertProviderAt((Provider)new XMLDSigRI(), 1);
    }
}

