/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.crypto.test.dsig;

import java.io.File;
import java.io.FileInputStream;
import java.util.HashMap;
import java.util.Map;
import javax.xml.crypto.Data;
import javax.xml.crypto.OctetStreamData;
import javax.xml.crypto.URIDereferencer;
import javax.xml.crypto.URIReference;
import javax.xml.crypto.URIReferenceException;
import javax.xml.crypto.XMLCryptoContext;
import javax.xml.crypto.dsig.XMLSignatureFactory;

public class LocalHttpCacheURIDereferencer
implements URIDereferencer {
    private final URIDereferencer ud = XMLSignatureFactory.getInstance().getURIDereferencer();
    private static final String FS = System.getProperty("file.separator");
    private static final String BASEDIR = System.getProperty("basedir");
    private final Map<String, File> uriMap;

    public LocalHttpCacheURIDereferencer() {
        String string = BASEDIR == null ? "./" : BASEDIR;
        File file = new File(string + FS + "src/test/resources" + FS + "javax" + FS + "xml" + FS + "crypto" + FS + "dsig");
        this.uriMap = new HashMap<String, File>();
        this.uriMap.put("http://www.w3.org/TR/xml-stylesheet", new File(file, "xml-stylesheet"));
        this.uriMap.put("http://www.w3.org/Signature/2002/04/xml-stylesheet.b64", new File(file, "xml-stylesheet.b64"));
        this.uriMap.put("http://www.ietf.org/rfc/rfc3161.txt", new File(file, "rfc3161.txt"));
    }

    public Data dereference(URIReference uRIReference, XMLCryptoContext xMLCryptoContext) throws URIReferenceException {
        String string = uRIReference.getURI();
        if (this.uriMap.containsKey(string)) {
            try {
                FileInputStream fileInputStream = new FileInputStream(this.uriMap.get(string));
                return new OctetStreamData(fileInputStream, uRIReference.getURI(), uRIReference.getType());
            }
            catch (Exception exception) {
                throw new URIReferenceException(exception);
            }
        }
        return this.ud.dereference(uRIReference, xMLCryptoContext);
    }
}

