/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.crypto.test.dsig;

import java.io.File;
import java.security.Provider;
import java.security.Security;
import javax.xml.crypto.URIDereferencer;
import javax.xml.crypto.dsig.XMLSignatureException;
import javax.xml.crypto.dsig.dom.DOMValidateContext;
import javax.xml.crypto.test.KeySelectors;
import javax.xml.crypto.test.dsig.LocalHttpCacheURIDereferencer;
import javax.xml.crypto.test.dsig.SignatureValidator;
import org.apache.jcp.xml.dsig.internal.dom.XMLDSigRI;
import org.junit.Assert;
import org.junit.Test;

public class PhaosXMLDSig3Test
extends Assert {
    private SignatureValidator validator;
    private File base;
    private final URIDereferencer ud;

    public PhaosXMLDSig3Test() {
        String string = System.getProperty("file.separator");
        String string2 = System.getProperty("basedir") == null ? "./" : System.getProperty("basedir");
        this.base = new File(string2 + string + "src/test/resources" + string + "com" + string + "phaos", "phaos-xmldsig-three");
        this.validator = new SignatureValidator(this.base);
        this.ud = new LocalHttpCacheURIDereferencer();
    }

    @Test
    public void test_signature_dsa_detached() throws Exception {
        String string = "signature-dsa-detached.xml";
        DOMValidateContext dOMValidateContext = this.validator.getValidateContext(string, new KeySelectors.RawX509KeySelector());
        dOMValidateContext.setProperty("javax.xml.crypto.dsig.cacheReference", Boolean.TRUE);
        dOMValidateContext.setURIDereferencer(this.ud);
        boolean bl = this.validator.validate(dOMValidateContext);
        PhaosXMLDSig3Test.assertTrue((String)"Signature failed core validation", (boolean)bl);
    }

    @Test
    public void test_signature_dsa_enveloped() throws Exception {
        String string = "signature-dsa-enveloped.xml";
        boolean bl = this.validator.validate(string, new KeySelectors.RawX509KeySelector());
        PhaosXMLDSig3Test.assertTrue((String)"Signature failed core validation", (boolean)bl);
    }

    @Test
    public void test_signature_dsa_enveloping() throws Exception {
        String string = "signature-dsa-enveloping.xml";
        boolean bl = this.validator.validate(string, new KeySelectors.RawX509KeySelector());
        PhaosXMLDSig3Test.assertTrue((String)"Signature failed core validation", (boolean)bl);
    }

    @Test
    public void test_signature_dsa_manifest() throws Exception {
        String string = "signature-dsa-manifest.xml";
        boolean bl = this.validator.validate(string, new KeySelectors.KeyValueKeySelector());
        PhaosXMLDSig3Test.assertTrue((String)"Signature failed core validation", (boolean)bl);
    }

    @Test
    public void test_signature_hmac_sha1_40_c14n_comments_detached() throws Exception {
        String string = "signature-hmac-sha1-40-c14n-comments-detached.xml";
        KeySelectors.SecretKeySelector secretKeySelector = new KeySelectors.SecretKeySelector("test".getBytes("ASCII"));
        try {
            this.validator.validate(string, secretKeySelector);
            PhaosXMLDSig3Test.fail((String)"Expected HMACOutputLength Exception");
        }
        catch (XMLSignatureException xMLSignatureException) {
            // empty catch block
        }
    }

    @Test
    public void test_signature_hmac_sha1_40_exclusive_c14n_comments_detached() throws Exception {
        String string = "signature-hmac-sha1-40-exclusive-c14n-comments-detached.xml";
        KeySelectors.SecretKeySelector secretKeySelector = new KeySelectors.SecretKeySelector("test".getBytes("ASCII"));
        try {
            this.validator.validate(string, secretKeySelector);
            PhaosXMLDSig3Test.fail((String)"Expected HMACOutputLength Exception");
        }
        catch (XMLSignatureException xMLSignatureException) {
            // empty catch block
        }
    }

    @Test
    public void test_signature_hmac_sha1_exclusive_c14n_comments_detached() throws Exception {
        String string = "signature-hmac-sha1-exclusive-c14n-comments-detached.xml";
        KeySelectors.SecretKeySelector secretKeySelector = new KeySelectors.SecretKeySelector("test".getBytes("ASCII"));
        boolean bl = this.validator.validate(string, secretKeySelector, this.ud);
        PhaosXMLDSig3Test.assertTrue((String)"Signature failed core validation", (boolean)bl);
    }

    @Test
    public void test_signature_hmac_sha1_exclusive_c14n_enveloped() throws Exception {
        String string = "signature-hmac-sha1-exclusive-c14n-enveloped.xml";
        KeySelectors.SecretKeySelector secretKeySelector = new KeySelectors.SecretKeySelector("test".getBytes("ASCII"));
        boolean bl = this.validator.validate(string, secretKeySelector);
        PhaosXMLDSig3Test.assertTrue((String)"Signature failed core validation", (boolean)bl);
    }

    @Test
    public void test_signature_rsa_detached_b64_transform() throws Exception {
        String string = "signature-rsa-detached-b64-transform.xml";
        boolean bl = this.validator.validate(string, new KeySelectors.KeyValueKeySelector());
        PhaosXMLDSig3Test.assertTrue((String)"Signature failed core validation", (boolean)bl);
    }

    @Test
    public void test_signature_rsa_detached_xpath_transform() throws Exception {
        String string = "signature-rsa-detached-xpath-transform.xml";
        boolean bl = this.validator.validate(string, new KeySelectors.KeyValueKeySelector());
        PhaosXMLDSig3Test.assertTrue((String)"Signature failed core validation", (boolean)bl);
    }

    @Test
    public void test_signature_rsa_detached_xslt_transform_bad_rm() throws Exception {
        String string = "signature-rsa-detached-xslt-transform-bad-retrieval-method.xml";
        try {
            this.validator.validate(string, new KeySelectors.CollectionKeySelector(this.base));
            PhaosXMLDSig3Test.fail((String)"Should throw XMLSignatureException for using DSA key with RSA algorithm");
        }
        catch (XMLSignatureException xMLSignatureException) {
            // empty catch block
        }
    }

    @Test
    public void test_signature_rsa_detached_xslt_transform_rm() throws Exception {
        String string = "signature-rsa-detached-xslt-transform-retrieval-method.xml";
        boolean bl = this.validator.validate(string, new KeySelectors.CollectionKeySelector(this.base));
        PhaosXMLDSig3Test.assertTrue((String)"Signature failed core validation", (boolean)bl);
    }

    @Test
    public void test_signature_rsa_detached_xslt_transform() throws Exception {
        String string = "signature-rsa-detached-xslt-transform.xml";
        boolean bl = this.validator.validate(string, new KeySelectors.KeyValueKeySelector());
        PhaosXMLDSig3Test.assertTrue((String)"Signature failed core validation", (boolean)bl);
    }

    @Test
    public void test_signature_rsa_detached() throws Exception {
        String string = "signature-rsa-detached.xml";
        DOMValidateContext dOMValidateContext = this.validator.getValidateContext(string, new KeySelectors.RawX509KeySelector());
        dOMValidateContext.setProperty("javax.xml.crypto.dsig.cacheReference", Boolean.TRUE);
        dOMValidateContext.setURIDereferencer(this.ud);
        boolean bl = this.validator.validate(dOMValidateContext);
        PhaosXMLDSig3Test.assertTrue((String)"Signature failed core validation", (boolean)bl);
    }

    @Test
    public void test_signature_rsa_enveloped_bad_digest_val() throws Exception {
        String string = "signature-rsa-enveloped-bad-digest-val.xml";
        boolean bl = this.validator.validate(string, new KeySelectors.RawX509KeySelector());
        PhaosXMLDSig3Test.assertFalse((String)"Signature should fail core validation", (boolean)bl);
    }

    @Test
    public void test_signature_rsa_enveloped() throws Exception {
        String string = "signature-rsa-enveloped.xml";
        boolean bl = this.validator.validate(string, new KeySelectors.RawX509KeySelector());
        PhaosXMLDSig3Test.assertTrue((String)"Signature failed core validation", (boolean)bl);
    }

    @Test
    public void test_signature_rsa_enveloping() throws Exception {
        String string = "signature-rsa-enveloping.xml";
        boolean bl = this.validator.validate(string, new KeySelectors.RawX509KeySelector());
        PhaosXMLDSig3Test.assertTrue((String)"Signature failed core validation", (boolean)bl);
    }

    @Test
    public void test_signature_rsa_manifest_x509_data_cert_chain() throws Exception {
        String string = "signature-rsa-manifest-x509-data-cert-chain.xml";
        boolean bl = this.validator.validate(string, new KeySelectors.RawX509KeySelector());
        PhaosXMLDSig3Test.assertTrue((String)"Signature failed core validation", (boolean)bl);
    }

    @Test
    public void test_signature_rsa_manifest_x509_data_cert() throws Exception {
        String string = "signature-rsa-manifest-x509-data-cert.xml";
        boolean bl = this.validator.validate(string, new KeySelectors.RawX509KeySelector());
        PhaosXMLDSig3Test.assertTrue((String)"Signature failed core validation", (boolean)bl);
    }

    @Test
    public void test_signature_rsa_manifest_x509_data_issuer_serial() throws Exception {
        String string = "signature-rsa-manifest-x509-data-issuer-serial.xml";
        boolean bl = this.validator.validate(string, new KeySelectors.CollectionKeySelector(this.base));
        PhaosXMLDSig3Test.assertTrue((String)"Signature failed core validation", (boolean)bl);
    }

    @Test
    public void test_signature_rsa_manifest_x509_data_ski() throws Exception {
        String string = "signature-rsa-manifest-x509-data-ski.xml";
        boolean bl = this.validator.validate(string, new KeySelectors.CollectionKeySelector(this.base));
        PhaosXMLDSig3Test.assertTrue((String)"Signature failed core validation", (boolean)bl);
    }

    @Test
    public void test_signature_rsa_manifest_x509_data_subject_name() throws Exception {
        String string = "signature-rsa-manifest-x509-data-subject-name.xml";
        boolean bl = this.validator.validate(string, new KeySelectors.CollectionKeySelector(this.base));
        PhaosXMLDSig3Test.assertTrue((String)"Signature failed core validation", (boolean)bl);
    }

    @Test
    public void test_signature_rsa_manifest_x509_data() throws Exception {
        String string = "signature-rsa-manifest-x509-data.xml";
        boolean bl = this.validator.validate(string, new KeySelectors.RawX509KeySelector());
        PhaosXMLDSig3Test.assertTrue((String)"Signature failed core validation", (boolean)bl);
    }

    @Test
    public void test_signature_rsa_manifest() throws Exception {
        String string = "signature-rsa-manifest.xml";
        boolean bl = this.validator.validate(string, new KeySelectors.KeyValueKeySelector());
        PhaosXMLDSig3Test.assertTrue((String)"Signature failed core validation", (boolean)bl);
    }

    @Test
    public void test_signature_rsa_xpath_transform_enveloped() throws Exception {
        String string = "signature-rsa-xpath-transform-enveloped.xml";
        boolean bl = this.validator.validate(string, new KeySelectors.RawX509KeySelector());
        PhaosXMLDSig3Test.assertTrue((String)"Signature failed core validation", (boolean)bl);
    }

    static {
        Security.insertProviderAt((Provider)new XMLDSigRI(), 1);
    }
}

