/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.crypto.test.dsig;

import java.io.InputStream;
import java.security.MessageDigest;
import java.security.Provider;
import java.security.Security;
import java.util.Arrays;
import java.util.Collections;
import java.util.Random;
import java.util.Vector;
import javax.xml.crypto.dsig.DigestMethod;
import javax.xml.crypto.dsig.Reference;
import javax.xml.crypto.dsig.Transform;
import javax.xml.crypto.dsig.XMLSignature;
import javax.xml.crypto.dsig.XMLSignatureException;
import javax.xml.crypto.dsig.XMLSignatureFactory;
import javax.xml.crypto.dsig.dom.DOMSignContext;
import javax.xml.crypto.dsig.dom.DOMValidateContext;
import javax.xml.crypto.dsig.keyinfo.KeyInfoFactory;
import javax.xml.crypto.dsig.spec.C14NMethodParameterSpec;
import javax.xml.crypto.dsig.spec.TransformParameterSpec;
import javax.xml.crypto.test.dsig.TestUtils;
import org.apache.jcp.xml.dsig.internal.dom.XMLDSigRI;
import org.junit.Assert;
import org.junit.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class ReferenceTest
extends Assert {
    private XMLSignatureFactory fac = XMLSignatureFactory.getInstance("DOM", (Provider)new XMLDSigRI());
    private KeyInfoFactory kifac = KeyInfoFactory.getInstance("DOM", (Provider)new XMLDSigRI());
    private DigestMethod dmSHA1 = this.fac.newDigestMethod("http://www.w3.org/2000/09/xmldsig#sha1", null);
    private String uri = "http://www.ietf.org/rfc/rfc3275.txt";
    private static final String[] CRYPTO_ALGS = new String[]{"RSA", "DSA"};
    private static final String[] SIG_ALGS = new String[]{"http://www.w3.org/2000/09/xmldsig#rsa-sha1", "http://www.w3.org/2000/09/xmldsig#dsa-sha1"};

    @Test
    public void testConstructor() throws Exception {
        Reference reference = this.fac.newReference(null, this.dmSHA1);
        ReferenceTest.assertNotNull((Object)reference);
        reference = this.fac.newReference(this.uri, this.dmSHA1);
        ReferenceTest.assertNotNull((Object)reference);
        try {
            reference = this.fac.newReference("illegal!@#$%" + this.uri, this.dmSHA1);
            ReferenceTest.fail((String)"Should throw a IAE for non-RFC2396-compliant uri");
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (Exception exception) {
            ReferenceTest.fail((String)("Should throw a IAE instead of " + exception + " for non-RFC2396-compliant uri"));
        }
        try {
            reference = this.fac.newReference(this.uri, null);
            ReferenceTest.fail((String)"Should throw a NPE for null dm");
        }
        catch (NullPointerException nullPointerException) {
        }
        catch (Exception exception) {
            ReferenceTest.fail((String)("Should throw a NPE instead of " + exception + " for null dm"));
        }
        try {
            reference = this.fac.newReference(null, this.dmSHA1, null, null, null);
            ReferenceTest.assertEquals((Object)reference.getDigestMethod(), (Object)this.dmSHA1);
        }
        catch (Exception exception) {
            ReferenceTest.fail((String)("Unexpected Exception: " + exception));
        }
        try {
            reference = this.fac.newReference(null, null, null, null, null);
            ReferenceTest.fail((String)"Should throw a NPE for null dm");
        }
        catch (NullPointerException nullPointerException) {
        }
        catch (Exception exception) {
            ReferenceTest.fail((String)("Should throw a NPE instead of " + exception + " for null dm"));
        }
        String string = "id";
        String string2 = "type";
        try {
            reference = this.fac.newReference(this.uri, this.dmSHA1, null, string2, string);
            ReferenceTest.assertNotNull((Object)reference.getDigestMethod());
            ReferenceTest.assertEquals((Object)this.uri, (Object)reference.getURI());
            ReferenceTest.assertEquals((Object)string, (Object)reference.getId());
            ReferenceTest.assertEquals((Object)string2, (Object)reference.getType());
            ReferenceTest.assertEquals(reference.getTransforms(), (Object)Collections.EMPTY_LIST);
        }
        catch (Exception exception) {
            ReferenceTest.fail((String)("Unexpected Exception: " + exception));
        }
        Vector<Object> vector = new Vector<Object>();
        try {
            reference = this.fac.newReference(this.uri, this.dmSHA1, vector, string2, string);
            ReferenceTest.assertTrue((boolean)Arrays.equals(vector.toArray(), reference.getTransforms().toArray()));
        }
        catch (Exception exception) {
            ReferenceTest.fail((String)("Unexpected Exception: " + exception));
        }
        vector.add(new Object());
        try {
            reference = this.fac.newReference(this.uri, this.dmSHA1, vector, string2, string);
        }
        catch (ClassCastException classCastException) {
        }
        catch (Exception exception) {
            ReferenceTest.fail((String)("Should throw a ClassCastException instead of " + exception));
        }
        vector.clear();
        vector.add("http://www.w3.org/2000/09/xmldsig#base64");
        try {
            reference = this.fac.newReference(this.uri, this.dmSHA1, vector, string2, string);
            ReferenceTest.fail((String)"Should throw a CCE for illegal transforms");
        }
        catch (ClassCastException classCastException) {
        }
        catch (Exception exception) {
            ReferenceTest.fail((String)("Should throw a CCE instead of " + exception + " for illegal transforms"));
        }
        vector.clear();
        Transform transform = this.fac.newTransform("http://www.w3.org/TR/2001/REC-xml-c14n-20010315#WithComments", (TransformParameterSpec)null);
        vector.add(transform);
        try {
            reference = this.fac.newReference(this.uri, this.dmSHA1, vector, string2, string);
            ReferenceTest.assertTrue((boolean)Arrays.equals(vector.toArray(), reference.getTransforms().toArray()));
        }
        catch (Exception exception) {
            ReferenceTest.fail((String)("Unexpected Exception: " + exception));
        }
    }

    @Test
    public void testisFeatureSupported() throws Exception {
        Reference reference = this.fac.newReference(null, this.dmSHA1, null, null, null);
        try {
            reference.isFeatureSupported(null);
            ReferenceTest.fail((String)"Should raise a NPE for null feature");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        ReferenceTest.assertTrue((!reference.isFeatureSupported("not supported") ? 1 : 0) != 0);
    }

    @Test
    public void testvalidate() throws Exception {
        this.testvalidate(false);
    }

    @Test
    public void testvalidateWithCaching() throws Exception {
        this.testvalidate(true);
    }

    private void testvalidate(boolean bl) throws Exception {
        Reference reference = null;
        String string = "http://www.w3.org/2000/09/xmldsig#Object";
        byte[] byArray = new byte[200];
        Random random = new Random();
        for (int i = 0; i < CRYPTO_ALGS.length; ++i) {
            random.nextBytes(byArray);
            TestUtils.OctetStreamURIDereferencer octetStreamURIDereferencer = new TestUtils.OctetStreamURIDereferencer(byArray);
            Document document = TestUtils.newDocument();
            DOMSignContext dOMSignContext = new DOMSignContext(TestUtils.getPrivateKey(CRYPTO_ALGS[i]), (Node)document);
            dOMSignContext.setURIDereferencer(octetStreamURIDereferencer);
            if (bl) {
                dOMSignContext.setProperty("javax.xml.crypto.dsig.cacheReference", Boolean.TRUE);
            }
            reference = this.fac.newReference(null, this.dmSHA1, null, string, null);
            XMLSignature xMLSignature = this.fac.newXMLSignature(this.fac.newSignedInfo(this.fac.newCanonicalizationMethod("http://www.w3.org/TR/2001/REC-xml-c14n-20010315#WithComments", (C14NMethodParameterSpec)null), this.fac.newSignatureMethod(SIG_ALGS[i], null), Collections.singletonList(reference)), this.kifac.newKeyInfo(Collections.singletonList(this.kifac.newKeyValue(TestUtils.getPublicKey(CRYPTO_ALGS[i])))));
            try {
                xMLSignature.sign(dOMSignContext);
                if (!bl) {
                    ReferenceTest.assertNull((Object)reference.getDereferencedData());
                    ReferenceTest.assertNull((Object)reference.getDigestInputStream());
                } else {
                    ReferenceTest.assertNotNull((Object)reference.getDereferencedData());
                    ReferenceTest.assertNotNull((Object)reference.getDigestInputStream());
                    ReferenceTest.assertTrue((boolean)this.digestInputEqual(reference));
                }
                DOMValidateContext dOMValidateContext = new DOMValidateContext(TestUtils.getPublicKey(CRYPTO_ALGS[i]), (Node)document.getDocumentElement());
                dOMValidateContext.setURIDereferencer(octetStreamURIDereferencer);
                if (bl) {
                    dOMValidateContext.setProperty("javax.xml.crypto.dsig.cacheReference", Boolean.TRUE);
                }
                boolean bl2 = xMLSignature.validate(dOMValidateContext);
                ReferenceTest.assertTrue((boolean)bl2);
                for (Reference reference2 : xMLSignature.getSignedInfo().getReferences()) {
                    if (!bl) {
                        ReferenceTest.assertNull((Object)reference2.getDereferencedData());
                        ReferenceTest.assertNull((Object)reference2.getDigestInputStream());
                    } else {
                        ReferenceTest.assertNotNull((Object)reference2.getDereferencedData());
                        ReferenceTest.assertNotNull((Object)reference2.getDigestInputStream());
                        ReferenceTest.assertTrue((boolean)this.digestInputEqual(reference2));
                    }
                    byte[] byArray2 = reference2.getDigestValue();
                    byte[] byArray3 = reference2.getCalculatedDigestValue();
                    ReferenceTest.assertTrue((boolean)Arrays.equals(byArray2, byArray3));
                    boolean bl3 = reference2.validate(dOMValidateContext);
                    ReferenceTest.assertTrue((boolean)bl3);
                }
                continue;
            }
            catch (XMLSignatureException xMLSignatureException) {
                ReferenceTest.fail((String)("Unexpected Exception: " + xMLSignatureException));
            }
        }
    }

    private boolean digestInputEqual(Reference reference) throws Exception {
        int n;
        MessageDigest messageDigest = MessageDigest.getInstance("SHA1");
        InputStream inputStream = reference.getDigestInputStream();
        byte[] byArray = new byte[256];
        while ((n = inputStream.read(byArray, 0, byArray.length)) != -1) {
            messageDigest.update(byArray, 0, n);
        }
        return Arrays.equals(messageDigest.digest(), reference.getDigestValue());
    }

    static {
        Security.insertProviderAt((Provider)new XMLDSigRI(), 1);
    }
}

