/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.crypto.test.dsig;

import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import javax.xml.crypto.dsig.SignatureMethod;
import javax.xml.crypto.dsig.XMLSignatureFactory;
import javax.xml.crypto.test.dsig.TestUtils;
import org.apache.jcp.xml.dsig.internal.dom.XMLDSigRI;
import org.junit.Assert;
import org.junit.Test;

public class SignatureMethodTest
extends Assert {
    XMLSignatureFactory factory = XMLSignatureFactory.getInstance("DOM", (Provider)new XMLDSigRI());
    private static final String[] SIG_ALGOS = new String[]{"http://www.w3.org/2000/09/xmldsig#dsa-sha1", "http://www.w3.org/2000/09/xmldsig#rsa-sha1", "http://www.w3.org/2000/09/xmldsig#hmac-sha1"};

    @Test
    public void testisFeatureSupported() throws Exception {
        for (int i = 0; i < SIG_ALGOS.length; ++i) {
            String string = SIG_ALGOS[i];
            SignatureMethod signatureMethod = this.factory.newSignatureMethod(string, null);
            try {
                signatureMethod.isFeatureSupported(null);
                SignatureMethodTest.fail((String)"Should raise a NPE for null feature");
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            SignatureMethodTest.assertTrue((!signatureMethod.isFeatureSupported("not supported") ? 1 : 0) != 0);
        }
    }

    @Test
    public void testConstructor() throws Exception {
        SignatureMethod signatureMethod;
        for (int i = 0; i < SIG_ALGOS.length; ++i) {
            String string = SIG_ALGOS[i];
            signatureMethod = this.factory.newSignatureMethod(string, null);
            SignatureMethodTest.assertEquals((Object)signatureMethod.getAlgorithm(), (Object)string);
            SignatureMethodTest.assertNull((Object)signatureMethod.getParameterSpec());
            try {
                signatureMethod = this.factory.newSignatureMethod(string, new TestUtils.MyOwnSignatureMethodParameterSpec());
                SignatureMethodTest.fail((String)"Should raise an IAPE for invalid parameters");
                continue;
            }
            catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
                continue;
            }
            catch (Exception exception) {
                SignatureMethodTest.fail((String)("Should raise an IAPE instead of " + exception));
            }
        }
        try {
            signatureMethod = this.factory.newSignatureMethod("non-existent", null);
            SignatureMethodTest.fail((String)"Should raise an NSAE for non-existent algos");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            // empty catch block
        }
        try {
            signatureMethod = this.factory.newSignatureMethod(null, null);
            SignatureMethodTest.fail((String)"Should raise a NPE for null algo");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }
}

