/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.crypto.test.dsig;

import java.security.Provider;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Vector;
import javax.xml.crypto.dsig.SignatureProperties;
import javax.xml.crypto.dsig.SignatureProperty;
import javax.xml.crypto.dsig.XMLSignatureFactory;
import javax.xml.crypto.test.dsig.TestUtils;
import org.apache.jcp.xml.dsig.internal.dom.XMLDSigRI;
import org.junit.Assert;
import org.junit.Test;

public class SignaturePropertiesTest
extends Assert {
    private XMLSignatureFactory factory = XMLSignatureFactory.getInstance("DOM", (Provider)new XMLDSigRI());
    private String id = "id";
    private SignatureProperty prop = this.factory.newSignatureProperty(Collections.singletonList(new TestUtils.MyOwnXMLStructure()), "propTarget", "propId");

    @Test
    public void testConstructor() {
        SignatureProperties signatureProperties;
        try {
            signatureProperties = this.factory.newSignatureProperties(null, this.id);
            SignaturePropertiesTest.fail((String)"Should raise a NPE for null content");
        }
        catch (NullPointerException nullPointerException) {
        }
        catch (Exception exception) {
            SignaturePropertiesTest.fail((String)("Should raise a NPE for null content instead of " + exception));
        }
        Vector<Object> vector = new Vector<Object>();
        try {
            signatureProperties = this.factory.newSignatureProperties(vector, this.id);
            SignaturePropertiesTest.fail((String)"Should raise an IAE for empty content");
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (Exception exception) {
            SignaturePropertiesTest.fail((String)("Should raise an IAE for empty content instead of " + exception));
        }
        String string = "wrong type";
        vector.add(string);
        try {
            signatureProperties = this.factory.newSignatureProperties(vector, this.id);
            SignaturePropertiesTest.fail((String)"Should raise a CCE for content containing invalid, i.e. non-SignatureProperty, entries");
        }
        catch (ClassCastException classCastException) {
            classCastException.printStackTrace();
        }
        catch (Exception exception) {
            SignaturePropertiesTest.fail((String)("Should raise a CCE for content with invalid entries instead of " + exception));
        }
        vector.remove(string);
        vector.add(this.prop);
        signatureProperties = this.factory.newSignatureProperties(vector, this.id);
        SignaturePropertiesTest.assertNotNull((Object)signatureProperties);
        List<SignatureProperty> list = signatureProperties.getProperties();
        SignaturePropertiesTest.assertNotNull(list);
        try {
            list.add(this.prop);
            SignaturePropertiesTest.fail((String)"Should return an unmodifiable List object");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        SignaturePropertiesTest.assertTrue((boolean)Arrays.equals(list.toArray(), vector.toArray()));
        SignaturePropertiesTest.assertNotNull((Object)signatureProperties);
        SignaturePropertiesTest.assertEquals((Object)signatureProperties.getId(), (Object)this.id);
    }

    @Test
    public void testisFeatureSupported() {
        Vector<SignatureProperty> vector = new Vector<SignatureProperty>();
        vector.add(this.prop);
        SignatureProperties signatureProperties = this.factory.newSignatureProperties(vector, this.id);
        try {
            signatureProperties.isFeatureSupported(null);
            SignaturePropertiesTest.fail((String)"Should raise a NPE for null feature");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        SignaturePropertiesTest.assertTrue((!signatureProperties.isFeatureSupported("not supported") ? 1 : 0) != 0);
    }
}

