/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.crypto.test.dsig;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.spec.DSAPrivateKeySpec;
import java.security.spec.DSAPublicKeySpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.security.spec.RSAPrivateKeySpec;
import java.security.spec.RSAPublicKeySpec;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.crypto.SecretKey;
import javax.xml.crypto.Data;
import javax.xml.crypto.NodeSetData;
import javax.xml.crypto.OctetStreamData;
import javax.xml.crypto.URIDereferencer;
import javax.xml.crypto.URIReference;
import javax.xml.crypto.XMLCryptoContext;
import javax.xml.crypto.XMLStructure;
import javax.xml.crypto.dom.DOMStructure;
import javax.xml.crypto.dsig.DigestMethod;
import javax.xml.crypto.dsig.Reference;
import javax.xml.crypto.dsig.XMLSignatureException;
import javax.xml.crypto.dsig.XMLSignatureFactory;
import javax.xml.crypto.dsig.XMLValidateContext;
import javax.xml.crypto.dsig.dom.DOMValidateContext;
import javax.xml.crypto.dsig.spec.C14NMethodParameterSpec;
import javax.xml.crypto.dsig.spec.DigestMethodParameterSpec;
import javax.xml.crypto.dsig.spec.SignatureMethodParameterSpec;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.jcp.xml.dsig.internal.dom.XMLDSigRI;
import org.apache.xml.security.utils.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TestUtils {
    private static final String DSA_Y = "07066284216756577193658833512863439617178933165631848358445549382240081120085333137303066923542492834619027404463194956043802393462371310375123430985057160";
    private static final String DSA_P = "013232376895198612407547930718267435757728527029623408872245156039757713029036368719146452186041204237350521785240337048752071462798273003935646236777459223";
    private static final String DSA_Q = "0857393771208094202104259627990318636601332086981";
    private static final String DSA_G = "05421644057436475141609648488325705128047428394380474376834667300766108262613900542681289080713724597310673074119355136085795982097390670890367185141189796";
    private static final String DSA_X = "0527140396812450214498055937934275626078768840117";
    private static final String RSA_MOD = "010800185049102889923150759252557522305032794699952150943573164381936603255999071981574575044810461362008102247767482738822150129277490998033971789476107463";
    private static final String RSA_PUB = "065537";
    private static final String RSA_PRIV = "0161169735844219697954459962296126719476357984292128166117072108359155865913405986839960884870654387514883422519600695753920562880636800379454345804879553";

    private TestUtils() {
    }

    public static PublicKey getPublicKey(String string) throws InvalidKeySpecException, NoSuchAlgorithmException {
        KeySpec keySpec;
        KeyFactory keyFactory = KeyFactory.getInstance(string);
        if (string.equalsIgnoreCase("DSA")) {
            keySpec = new DSAPublicKeySpec(new BigInteger(DSA_Y), new BigInteger(DSA_P), new BigInteger(DSA_Q), new BigInteger(DSA_G));
        } else if (string.equalsIgnoreCase("RSA")) {
            keySpec = new RSAPublicKeySpec(new BigInteger(RSA_MOD), new BigInteger(RSA_PUB));
        } else {
            throw new RuntimeException("Unsupported key algorithm " + string);
        }
        return keyFactory.generatePublic(keySpec);
    }

    public static PrivateKey getPrivateKey(String string) throws InvalidKeySpecException, NoSuchAlgorithmException {
        KeySpec keySpec;
        KeyFactory keyFactory = KeyFactory.getInstance(string);
        if (string.equalsIgnoreCase("DSA")) {
            keySpec = new DSAPrivateKeySpec(new BigInteger(DSA_X), new BigInteger(DSA_P), new BigInteger(DSA_Q), new BigInteger(DSA_G));
        } else if (string.equalsIgnoreCase("RSA")) {
            keySpec = new RSAPrivateKeySpec(new BigInteger(RSA_MOD), new BigInteger(RSA_PRIV));
        } else {
            throw new RuntimeException("Unsupported key algorithm " + string);
        }
        return keyFactory.generatePrivate(keySpec);
    }

    public static SecretKey getSecretKey(final byte[] byArray) {
        return new SecretKey(){
            private static final long serialVersionUID = 5629454124145851381L;

            public String getFormat() {
                return "RAW";
            }

            public byte[] getEncoded() {
                return byArray;
            }

            public String getAlgorithm() {
                return "SECRET";
            }
        };
    }

    public static Document newDocument() {
        try {
            DocumentBuilder documentBuilder = XMLUtils.createDocumentBuilder((boolean)false);
            return documentBuilder.newDocument();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static XMLValidateContext getXMLValidateContext(String string, File file, String string2) throws Exception {
        if (string.equalsIgnoreCase("dom")) {
            DocumentBuilder documentBuilder = XMLUtils.createDocumentBuilder((boolean)false, (boolean)false);
            Document document = documentBuilder.parse(file);
            if (string2 == null) {
                return new DOMValidateContext(TestUtils.getPublicKey("RSA"), (Node)document.getDocumentElement());
            }
            NodeList nodeList = document.getElementsByTagName(string2);
            return new DOMValidateContext(TestUtils.getPublicKey("RSA"), nodeList.item(0));
        }
        throw new Exception("Unsupported XMLValidateContext type: " + string);
    }

    public static void dumpDocument(Document document, String string) throws Exception {
        DOMSource dOMSource = new DOMSource(document);
        File file = new File(System.getProperty("test.dir"), string);
        StreamResult streamResult = new StreamResult(new FileOutputStream(file));
        Transformer transformer = TransformerFactory.newInstance().newTransformer();
        transformer.setOutputProperty("indent", "yes");
        transformer.transform(dOMSource, streamResult);
    }

    public static class NodeSetURIDereferencer
    implements URIDereferencer {
        private Node data = null;

        public NodeSetURIDereferencer(Node node) {
            this.data = node;
        }

        public Data dereference(URIReference uRIReference, XMLCryptoContext xMLCryptoContext) {
            return new NodeSetData(){

                @Override
                public Iterator<?> iterator() {
                    return Collections.singletonList(NodeSetURIDereferencer.this.data).iterator();
                }
            };
        }
    }

    public static class OctetStreamURIDereferencer
    implements URIDereferencer {
        private byte[] data = null;

        public OctetStreamURIDereferencer(byte[] byArray) {
            this.data = (byte[])byArray.clone();
        }

        public Data dereference(URIReference uRIReference, XMLCryptoContext xMLCryptoContext) {
            return new OctetStreamData(new ByteArrayInputStream(this.data));
        }

        public byte[] getData() {
            return this.data;
        }

        public boolean equals(Object object) {
            if (object instanceof OctetStreamURIDereferencer) {
                return Arrays.equals(((OctetStreamURIDereferencer)object).getData(), this.data);
            }
            return false;
        }

        public int hashCode() {
            return 5678;
        }
    }

    public static class MyOwnXMLStructure
    implements XMLStructure {
        public boolean isFeatureSupported(String string) throws NullPointerException {
            if (string == null) {
                throw new NullPointerException();
            }
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MyOwnDOMReference
    extends DOMStructure
    implements Reference {
        private String id;
        private boolean status;
        private byte[] digest;
        private static MessageDigest MD;
        private static DigestMethod DIG_METHOD;
        private Data derefData;
        private InputStream dis;

        public MyOwnDOMReference(String string, boolean bl) {
            super(TestUtils.newDocument());
            this.id = string;
            this.status = bl;
            this.digest = null;
        }

        @Override
        public byte[] getDigestValue() {
            if (this.digest == null) {
                byte[] byArray = this.id.getBytes();
                this.digest = new byte[20];
                if (this.status) {
                    this.digest = MD.digest(byArray);
                }
            }
            return this.digest;
        }

        @Override
        public byte[] getCalculatedDigestValue() {
            return null;
        }

        @Override
        public DigestMethod getDigestMethod() {
            return DIG_METHOD;
        }

        @Override
        public String getId() {
            return this.id;
        }

        @Override
        public String getType() {
            return null;
        }

        @Override
        public String getURI() {
            return null;
        }

        public List<?> getTransforms() {
            return Collections.EMPTY_LIST;
        }

        @Override
        public boolean validate(XMLValidateContext xMLValidateContext) throws XMLSignatureException {
            this.dis = new ByteArrayInputStream(this.id.getBytes());
            this.derefData = new OctetStreamData(this.dis);
            return this.status;
        }

        @Override
        public Data getDereferencedData() {
            return this.derefData;
        }

        @Override
        public InputStream getDigestInputStream() {
            return this.dis;
        }

        static {
            try {
                MD = MessageDigest.getInstance("SHA");
                XMLSignatureFactory xMLSignatureFactory = XMLSignatureFactory.getInstance("DOM", (Provider)new XMLDSigRI());
                DIG_METHOD = xMLSignatureFactory.newDigestMethod("http://www.w3.org/2000/09/xmldsig#sha1", null);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static class MyOwnSignatureMethodParameterSpec
    implements SignatureMethodParameterSpec {
    }

    public static class MyOwnDigestMethodParameterSpec
    implements DigestMethodParameterSpec {
    }

    public static class MyOwnC14nParameterSpec
    implements C14NMethodParameterSpec {
    }
}

