/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.crypto.test.dsig;

import java.io.File;
import java.security.Provider;
import java.security.Security;
import javax.xml.crypto.Data;
import javax.xml.crypto.URIDereferencer;
import javax.xml.crypto.URIReference;
import javax.xml.crypto.URIReferenceException;
import javax.xml.crypto.XMLCryptoContext;
import javax.xml.crypto.dsig.XMLSignatureException;
import javax.xml.crypto.dsig.XMLSignatureFactory;
import javax.xml.crypto.dsig.dom.DOMValidateContext;
import javax.xml.crypto.test.KeySelectors;
import javax.xml.crypto.test.dsig.SignatureValidator;
import org.apache.jcp.xml.dsig.internal.dom.XMLDSigRI;
import org.junit.Assert;
import org.junit.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class ValidateSignatureTest
extends Assert {
    private SignatureValidator validator;
    private File dir;

    public ValidateSignatureTest() {
        String string = System.getProperty("file.separator");
        String string2 = System.getProperty("basedir") == null ? "./" : System.getProperty("basedir");
        this.dir = new File(string2 + string + "src/test/resources" + string + "javax" + string + "xml" + string + "crypto", "dsig");
        this.validator = new SignatureValidator(this.dir);
    }

    @Test
    public void test_signature_with_ID() throws Exception {
        String string = "envelopingSignature.xml";
        DOMValidateContext dOMValidateContext = this.validator.getValidateContext(string, new KeySelectors.KeyValueKeySelector());
        Document document = dOMValidateContext.getNode().getOwnerDocument();
        NodeList nodeList = document.getElementsByTagName("Assertion");
        dOMValidateContext.setIdAttributeNS((Element)nodeList.item(0), null, "AssertionID");
        boolean bl = this.validator.validate(dOMValidateContext);
        ValidateSignatureTest.assertTrue((String)"Signature failed core validation", (boolean)bl);
    }

    @Test
    public void test_signature_external_c14n_xmlattrs() throws Exception {
        String string = "signature-external-c14n-xmlatrs.xml";
        boolean bl = this.validator.validate(string, new KeySelectors.SecretKeySelector("secret".getBytes("ASCII")));
        ValidateSignatureTest.assertTrue((String)"Signature failed core validation", (boolean)bl);
    }

    @Test
    public void test_invalid_signature() throws Exception {
        InvalidURIDereferencer invalidURIDereferencer = new InvalidURIDereferencer();
        boolean bl = this.validator.validate("invalid-signature.xml", new KeySelectors.KeyValueKeySelector(), invalidURIDereferencer);
        ValidateSignatureTest.assertFalse((String)"Invalid signature should fail!", (boolean)bl);
        ValidateSignatureTest.assertTrue((String)"References validated before signature", (boolean)invalidURIDereferencer.dereferenced);
    }

    @Test
    public void test_signature_enveloping_hmac_sha1_trunclen_0() throws Exception {
        try {
            this.validator.validate("signature-enveloping-hmac-sha1-trunclen-0-attack.xml", new KeySelectors.SecretKeySelector("secret".getBytes("ASCII")));
            ValidateSignatureTest.fail((String)"Expected HMACOutputLength exception");
        }
        catch (XMLSignatureException xMLSignatureException) {
            // empty catch block
        }
    }

    @Test
    public void test_signature_enveloping_hmac_sha1_trunclen_8() throws Exception {
        try {
            this.validator.validate("signature-enveloping-hmac-sha1-trunclen-8-attack.xml", new KeySelectors.SecretKeySelector("secret".getBytes("ASCII")));
            ValidateSignatureTest.fail((String)"Expected HMACOutputLength exception");
        }
        catch (XMLSignatureException xMLSignatureException) {
            // empty catch block
        }
    }

    @Test
    public void test_signature_exclc14n_xmlnamespace() throws Exception {
        String string = "demo.signed.xml";
        boolean bl = this.validator.validate(string, new KeySelectors.RawX509KeySelector());
        ValidateSignatureTest.assertTrue((String)"Signature failed core validation", (boolean)bl);
    }

    @Test
    public void test_signature_xpathfilter2() throws Exception {
        String string = "xmldsig-xfilter2.xml";
        boolean bl = this.validator.validate(string, new KeySelectors.KeyValueKeySelector());
        ValidateSignatureTest.assertTrue((String)"Signature failed core validation", (boolean)bl);
    }

    static {
        Security.insertProviderAt((Provider)new XMLDSigRI(), 1);
    }

    static class InvalidURIDereferencer
    implements URIDereferencer {
        boolean dereferenced = false;
        private URIDereferencer ud = XMLSignatureFactory.getInstance().getURIDereferencer();

        InvalidURIDereferencer() {
        }

        public Data dereference(URIReference uRIReference, XMLCryptoContext xMLCryptoContext) throws URIReferenceException {
            this.dereferenced = true;
            return this.ud.dereference(uRIReference, xMLCryptoContext);
        }
    }
}

