/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.crypto.test.dsig;

import java.io.IOException;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.PublicKey;
import java.security.cert.CertSelector;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Enumeration;
import javax.security.auth.x500.X500Principal;
import javax.xml.crypto.AlgorithmMethod;
import javax.xml.crypto.KeySelector;
import javax.xml.crypto.KeySelectorException;
import javax.xml.crypto.KeySelectorResult;
import javax.xml.crypto.OctetStreamData;
import javax.xml.crypto.XMLCryptoContext;
import javax.xml.crypto.XMLStructure;
import javax.xml.crypto.dsig.SignatureMethod;
import javax.xml.crypto.dsig.keyinfo.KeyInfo;
import javax.xml.crypto.dsig.keyinfo.KeyName;
import javax.xml.crypto.dsig.keyinfo.RetrievalMethod;
import javax.xml.crypto.dsig.keyinfo.X509Data;
import javax.xml.crypto.dsig.keyinfo.X509IssuerSerial;
import org.apache.jcp.xml.dsig.internal.dom.DOMRetrievalMethod;

public class X509KeySelector
extends KeySelector {
    private KeyStore ks;
    private boolean trusted = true;

    public X509KeySelector(KeyStore keyStore) throws KeyStoreException {
        this(keyStore, true);
    }

    public X509KeySelector(KeyStore keyStore, boolean bl) throws KeyStoreException {
        if (keyStore == null) {
            throw new NullPointerException("keyStore is null");
        }
        this.trusted = bl;
        this.ks = keyStore;
        this.ks.size();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public KeySelectorResult select(KeyInfo keyInfo, KeySelector.Purpose purpose, AlgorithmMethod algorithmMethod, XMLCryptoContext xMLCryptoContext) throws KeySelectorException {
        SignatureMethod signatureMethod = (SignatureMethod)algorithmMethod;
        try {
            if (keyInfo == null || this.ks.size() == 0) {
                return new SimpleKeySelectorResult(null);
            }
            for (XMLStructure xMLStructure : keyInfo.getContent()) {
                Object object;
                XMLStructure xMLStructure2;
                if (xMLStructure instanceof X509Data) {
                    xMLStructure2 = (X509Data)xMLStructure;
                    object = this.x509DataSelect((X509Data)xMLStructure2, signatureMethod);
                    if (object == null) continue;
                    return object;
                }
                if (xMLStructure instanceof KeyName) {
                    xMLStructure2 = (KeyName)xMLStructure;
                    object = this.ks.getCertificate(xMLStructure2.getName());
                    if (object == null || !this.algEquals(signatureMethod.getAlgorithm(), ((Certificate)object).getPublicKey().getAlgorithm())) continue;
                    return new SimpleKeySelectorResult(((Certificate)object).getPublicKey());
                }
                if (!(xMLStructure instanceof RetrievalMethod)) continue;
                xMLStructure2 = (RetrievalMethod)xMLStructure;
                try {
                    Object object2;
                    object = null;
                    if (xMLStructure2.getType().equals("http://www.w3.org/2000/09/xmldsig#rawX509Certificate")) {
                        object2 = (OctetStreamData)xMLStructure2.dereference(xMLCryptoContext);
                        CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
                        X509Certificate x509Certificate = (X509Certificate)certificateFactory.generateCertificate(((OctetStreamData)object2).getOctetStream());
                        object = this.certSelect(x509Certificate, signatureMethod);
                    } else {
                        if (!xMLStructure2.getType().equals("http://www.w3.org/2000/09/xmldsig#X509Data")) continue;
                        object2 = (X509Data)((DOMRetrievalMethod)xMLStructure2).dereferenceAsXMLStructure(xMLCryptoContext);
                        object = this.x509DataSelect((X509Data)object2, signatureMethod);
                    }
                    if (object == null) continue;
                    return object;
                }
                catch (Exception exception) {
                    throw new KeySelectorException(exception);
                    return new SimpleKeySelectorResult(null);
                }
            }
        }
        catch (KeyStoreException keyStoreException) {
            throw new KeySelectorException(keyStoreException);
        }
    }

    private KeySelectorResult keyStoreSelect(CertSelector certSelector) throws KeyStoreException {
        Enumeration<String> enumeration = this.ks.aliases();
        while (enumeration.hasMoreElements()) {
            String string = enumeration.nextElement();
            Certificate certificate = this.ks.getCertificate(string);
            if (certificate == null || !certSelector.match(certificate)) continue;
            return new SimpleKeySelectorResult(certificate.getPublicKey());
        }
        return null;
    }

    private KeySelectorResult certSelect(X509Certificate x509Certificate, SignatureMethod signatureMethod) throws KeyStoreException {
        boolean[] blArray = x509Certificate.getKeyUsage();
        if (blArray != null && !blArray[0]) {
            return null;
        }
        String string = this.ks.getCertificateAlias(x509Certificate);
        if (string != null) {
            PublicKey publicKey = this.ks.getCertificate(string).getPublicKey();
            if (this.algEquals(signatureMethod.getAlgorithm(), publicKey.getAlgorithm())) {
                return new SimpleKeySelectorResult(publicKey);
            }
        }
        return null;
    }

    private String getPKAlgorithmOID(String string) {
        if (string.equalsIgnoreCase("http://www.w3.org/2000/09/xmldsig#dsa-sha1")) {
            return "1.2.840.10040.4.1";
        }
        if (string.equalsIgnoreCase("http://www.w3.org/2000/09/xmldsig#rsa-sha1")) {
            return "1.2.840.113549.1.1";
        }
        return null;
    }

    private boolean algEquals(String string, String string2) {
        if (string2.equalsIgnoreCase("DSA") && string.equalsIgnoreCase("http://www.w3.org/2000/09/xmldsig#dsa-sha1")) {
            return true;
        }
        return string2.equalsIgnoreCase("RSA") && string.equalsIgnoreCase("http://www.w3.org/2000/09/xmldsig#rsa-sha1");
    }

    /*
     * WARNING - void declaration
     */
    private KeySelectorResult x509DataSelect(X509Data x509Data, SignatureMethod signatureMethod) throws KeyStoreException, KeySelectorException {
        Object object22;
        String string = this.getPKAlgorithmOID(signatureMethod.getAlgorithm());
        X509CertSelector x509CertSelector = new X509CertSelector();
        try {
            x509CertSelector.setSubjectPublicKeyAlgID(string);
        }
        catch (IOException iOException) {
            throw new KeySelectorException(iOException);
        }
        ArrayList<X509Certificate> arrayList = new ArrayList<X509Certificate>();
        for (Object object22 : x509Data.getContent()) {
            Object object4;
            if (object22 instanceof X509IssuerSerial) {
                object4 = (X509IssuerSerial)object22;
                try {
                    void var9_13;
                    x509CertSelector.setSerialNumber(object4.getSerialNumber());
                    String iOException = new X500Principal(object4.getIssuerName()).getName();
                    if (iOException.endsWith("\n")) {
                        iOException = new String(iOException.toCharArray(), 0, iOException.length() - 1);
                    }
                    x509CertSelector.setIssuer((String)var9_13);
                    continue;
                }
                catch (IOException iOException) {
                    throw new KeySelectorException(iOException);
                }
            }
            if (object22 instanceof String) {
                object4 = (String)object22;
                try {
                    void var9_17;
                    String string2 = new X500Principal((String)object4).getName();
                    if (string2.endsWith("\n")) {
                        String string3 = new String(string2.toCharArray(), 0, string2.length() - 1);
                    }
                    x509CertSelector.setSubject((String)var9_17);
                    continue;
                }
                catch (IOException iOException) {
                    throw new KeySelectorException(iOException);
                }
            }
            if (object22 instanceof byte[]) {
                object4 = (byte[])object22;
                byte[] byArray = new byte[((Object)object4).length + 2];
                byArray[0] = 4;
                byArray[1] = (byte)((Object)object4).length;
                System.arraycopy(object4, 0, byArray, 2, ((Object)object4).length);
                x509CertSelector.setSubjectKeyIdentifier(byArray);
                continue;
            }
            if (!(object22 instanceof X509Certificate)) continue;
            arrayList.add((X509Certificate)object22);
        }
        object22 = this.keyStoreSelect(x509CertSelector);
        if (object22 != null) {
            return object22;
        }
        if (!arrayList.isEmpty() && !this.trusted) {
            for (X509Certificate x509Certificate : arrayList) {
                if (!x509CertSelector.match(x509Certificate)) continue;
                return new SimpleKeySelectorResult(x509Certificate.getPublicKey());
            }
        }
        return null;
    }

    private static class SimpleKeySelectorResult
    implements KeySelectorResult {
        private final Key key;

        SimpleKeySelectorResult(Key key) {
            this.key = key;
        }

        public Key getKey() {
            return this.key;
        }
    }
}

