/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.crypto.test.dsig;

import java.security.Provider;
import java.util.Arrays;
import java.util.List;
import java.util.Vector;
import javax.xml.crypto.XMLStructure;
import javax.xml.crypto.dsig.XMLObject;
import javax.xml.crypto.dsig.XMLSignatureFactory;
import javax.xml.crypto.test.dsig.TestUtils;
import org.apache.jcp.xml.dsig.internal.dom.XMLDSigRI;
import org.junit.Assert;
import org.junit.Test;

public class XMLObjectTest
extends Assert {
    private XMLSignatureFactory factory = XMLSignatureFactory.getInstance("DOM", (Provider)new XMLDSigRI());
    private String id = "id";
    private String mimeType = "mime";
    private String encoding = "encoding";

    @Test
    public void testConstructor() {
        XMLObject xMLObject = this.factory.newXMLObject(null, null, null, null);
        XMLObjectTest.assertNotNull((Object)xMLObject);
        Vector<Object> vector = new Vector<Object>();
        xMLObject = this.factory.newXMLObject(vector, null, null, null);
        XMLObjectTest.assertNotNull((Object)xMLObject);
        String string = "wrong type";
        vector.add(string);
        try {
            xMLObject = this.factory.newXMLObject(vector, null, null, null);
            XMLObjectTest.fail((String)"Should raise a CCE for content containing invalid, i.e. non-XMLStructure, entries");
        }
        catch (ClassCastException classCastException) {
        }
        catch (Exception exception) {
            XMLObjectTest.fail((String)("Should raise a CCE for content with invalid entries instead of " + exception));
        }
        vector.remove(string);
        vector.add(new TestUtils.MyOwnXMLStructure());
        xMLObject = this.factory.newXMLObject(vector, this.id, this.mimeType, this.encoding);
        XMLObjectTest.assertNotNull((Object)xMLObject);
        XMLObjectTest.assertNotNull(xMLObject.getContent());
        XMLObjectTest.assertTrue((boolean)Arrays.equals(xMLObject.getContent().toArray(), vector.toArray()));
        XMLObjectTest.assertEquals((Object)xMLObject.getId(), (Object)this.id);
        XMLObjectTest.assertEquals((Object)xMLObject.getMimeType(), (Object)this.mimeType);
        XMLObjectTest.assertEquals((Object)xMLObject.getEncoding(), (Object)this.encoding);
        List<XMLStructure> list = xMLObject.getContent();
        try {
            list.add(new TestUtils.MyOwnXMLStructure());
            XMLObjectTest.fail((String)"Should return an unmodifiable List object");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        XMLObjectTest.assertTrue((boolean)Arrays.equals(list.toArray(), vector.toArray()));
    }

    @Test
    public void testisFeatureSupported() {
        Vector<TestUtils.MyOwnXMLStructure> vector = new Vector<TestUtils.MyOwnXMLStructure>();
        vector.add(new TestUtils.MyOwnXMLStructure());
        XMLObject xMLObject = this.factory.newXMLObject(vector, this.id, this.mimeType, this.encoding);
        try {
            xMLObject.isFeatureSupported(null);
            XMLObjectTest.fail((String)"Should raise a NPE for null feature");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        XMLObjectTest.assertTrue((!xMLObject.isFeatureSupported("not supported") ? 1 : 0) != 0);
    }
}

