/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.crypto.test.dsig;

import java.security.Key;
import javax.crypto.spec.SecretKeySpec;
import javax.xml.crypto.KeySelector;
import javax.xml.crypto.dsig.XMLSignContext;
import javax.xml.crypto.dsig.dom.DOMSignContext;
import javax.xml.crypto.test.dsig.TestUtils;
import org.junit.Assert;
import org.junit.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class XMLSignContextTest
extends Assert {
    private XMLSignContext defContext;
    private Key[] KEYS = new Key[3];
    private Document doc;

    public XMLSignContextTest() throws Exception {
        this.KEYS[0] = TestUtils.getPrivateKey("DSA");
        this.KEYS[1] = TestUtils.getPrivateKey("RSA");
        this.KEYS[2] = new SecretKeySpec(new byte[16], "HmacSHA1");
        SecretKeySpec secretKeySpec = new SecretKeySpec(new byte[8], "DES");
        this.doc = TestUtils.newDocument();
        this.defContext = new DOMSignContext(secretKeySpec, (Node)this.doc);
    }

    @Test
    public void testsetngetBaseURI() throws Exception {
        XMLSignContextTest.assertNull((Object)this.defContext.getBaseURI());
        String string = "http://www.w3.org/2000/09/xmldsig#";
        this.defContext.setBaseURI(string);
        XMLSignContextTest.assertEquals((Object)this.defContext.getBaseURI(), (Object)string);
        this.defContext.setBaseURI(null);
        XMLSignContextTest.assertNull((Object)this.defContext.getBaseURI());
    }

    @Test
    public void testsetngetProperty() throws Exception {
        String string = "key";
        XMLSignContextTest.assertNull((Object)this.defContext.getProperty(string));
        try {
            this.defContext.setProperty(null, null);
            XMLSignContextTest.fail((String)"Should raise a NPE with a null name");
        }
        catch (NullPointerException nullPointerException) {
        }
        catch (Exception exception) {
            XMLSignContextTest.fail((String)("Should raise a NPE instead of " + exception));
        }
        String string2 = "value#1";
        String string3 = "value#2";
        XMLSignContextTest.assertNull((Object)this.defContext.setProperty(string, string2));
        XMLSignContextTest.assertEquals((Object)this.defContext.getProperty(string), (Object)string2);
        XMLSignContextTest.assertEquals((Object)this.defContext.setProperty(string, string3), (Object)string2);
        XMLSignContextTest.assertEquals((Object)this.defContext.getProperty(string), (Object)string3);
        XMLSignContextTest.assertEquals((Object)this.defContext.setProperty(string, null), (Object)string3);
        XMLSignContextTest.assertNull((Object)this.defContext.getProperty(string));
    }

    @Test
    public void testsetngetURIDereferencer() throws Exception {
        XMLSignContextTest.assertNull((Object)this.defContext.getURIDereferencer());
        byte[] byArray = "simpleDereferencer".getBytes();
        TestUtils.OctetStreamURIDereferencer octetStreamURIDereferencer = new TestUtils.OctetStreamURIDereferencer(byArray);
        this.defContext.setURIDereferencer(octetStreamURIDereferencer);
        XMLSignContextTest.assertEquals((Object)this.defContext.getURIDereferencer(), (Object)octetStreamURIDereferencer);
        this.defContext.setURIDereferencer(null);
        XMLSignContextTest.assertNull((Object)this.defContext.getURIDereferencer());
    }

    @Test
    public void testsetngetKeySelector() throws Exception {
        this.defContext.setKeySelector(null);
        XMLSignContextTest.assertNull((Object)this.defContext.getKeySelector());
        KeySelector keySelector = KeySelector.singletonKeySelector(this.KEYS[0]);
        this.defContext.setKeySelector(keySelector);
        XMLSignContextTest.assertEquals((Object)this.defContext.getKeySelector(), (Object)keySelector);
    }
}

