/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.crypto.test.dsig;

import java.io.File;
import java.io.FileInputStream;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.crypto.spec.SecretKeySpec;
import javax.xml.crypto.URIDereferencer;
import javax.xml.crypto.dom.DOMStructure;
import javax.xml.crypto.dsig.CanonicalizationMethod;
import javax.xml.crypto.dsig.DigestMethod;
import javax.xml.crypto.dsig.Reference;
import javax.xml.crypto.dsig.SignatureMethod;
import javax.xml.crypto.dsig.SignedInfo;
import javax.xml.crypto.dsig.XMLObject;
import javax.xml.crypto.dsig.XMLSignature;
import javax.xml.crypto.dsig.XMLSignatureFactory;
import javax.xml.crypto.dsig.dom.DOMSignContext;
import javax.xml.crypto.dsig.dom.DOMValidateContext;
import javax.xml.crypto.dsig.keyinfo.KeyInfo;
import javax.xml.crypto.dsig.keyinfo.KeyInfoFactory;
import javax.xml.crypto.dsig.spec.C14NMethodParameterSpec;
import javax.xml.crypto.test.dsig.LocalHttpCacheURIDereferencer;
import javax.xml.crypto.test.dsig.TestUtils;
import org.apache.jcp.xml.dsig.internal.dom.XMLDSigRI;
import org.apache.xml.security.utils.XMLUtils;
import org.junit.Assert;
import org.junit.Test;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XMLSignatureTest
extends Assert {
    private XMLSignatureFactory fac = XMLSignatureFactory.getInstance("DOM", (Provider)new XMLDSigRI());
    private KeyInfoFactory kifac = KeyInfoFactory.getInstance("DOM", (Provider)new XMLDSigRI());
    private SignedInfo defSi;
    private KeyInfo defKi;
    private List<XMLObject> objs;
    private String id = "id";
    private String sigValueId = "signatureValueId";
    private Key[] SIGN_KEYS;
    private Key[] VALIDATE_KEYS;
    private SignatureMethod[] SIG_METHODS = new SignatureMethod[3];
    private URIDereferencer ud;

    public XMLSignatureTest() throws Exception {
        this.SIG_METHODS[0] = this.fac.newSignatureMethod("http://www.w3.org/2000/09/xmldsig#dsa-sha1", null);
        this.SIG_METHODS[1] = this.fac.newSignatureMethod("http://www.w3.org/2000/09/xmldsig#rsa-sha1", null);
        this.SIG_METHODS[2] = this.fac.newSignatureMethod("http://www.w3.org/2000/09/xmldsig#hmac-sha1", null);
        this.SIGN_KEYS = new Key[3];
        this.SIGN_KEYS[0] = TestUtils.getPrivateKey("DSA");
        this.SIGN_KEYS[1] = TestUtils.getPrivateKey("RSA");
        this.SIGN_KEYS[2] = new SecretKeySpec(new byte[16], "HmacSHA1");
        this.VALIDATE_KEYS = new Key[3];
        this.VALIDATE_KEYS[0] = TestUtils.getPublicKey("DSA");
        this.VALIDATE_KEYS[1] = TestUtils.getPublicKey("RSA");
        this.VALIDATE_KEYS[2] = new SecretKeySpec(new byte[16], "HmacSHA1");
        this.defSi = this.createSignedInfo(this.SIG_METHODS[0]);
        this.defKi = this.kifac.newKeyInfo(Collections.singletonList(this.kifac.newKeyName("Alice")));
        this.objs = Collections.singletonList(this.fac.newXMLObject(null, null, null, null));
        this.ud = new LocalHttpCacheURIDereferencer();
    }

    @Test
    public void testConstructor() throws Exception {
        XMLSignature xMLSignature = null;
        for (int i = 0; i < 2; ++i) {
            try {
                switch (i) {
                    case 0: {
                        xMLSignature = this.fac.newXMLSignature(null, this.defKi);
                        break;
                    }
                    case 1: {
                        xMLSignature = this.fac.newXMLSignature(null, this.defKi, this.objs, this.id, this.sigValueId);
                    }
                }
                XMLSignatureTest.fail((String)"Should throw a NPE for null references");
                continue;
            }
            catch (NullPointerException nullPointerException) {
                continue;
            }
            catch (Exception exception) {
                XMLSignatureTest.fail((String)("Should throw a NPE instead of " + exception + " for null references"));
            }
        }
        try {
            xMLSignature = this.fac.newXMLSignature(this.defSi, this.defKi, Collections.singletonList("wrongType"), this.id, this.sigValueId);
            XMLSignatureTest.fail((String)"Should throw a CCE for invalid objects");
        }
        catch (ClassCastException classCastException) {
        }
        catch (Exception exception) {
            XMLSignatureTest.fail((String)("Should throw a CCE instead of " + exception + " for invalid objects"));
        }
        xMLSignature = this.fac.newXMLSignature(this.defSi, this.defKi, this.objs, this.id, this.sigValueId);
        XMLSignatureTest.assertEquals((Object)xMLSignature.getId(), (Object)this.id);
        XMLSignatureTest.assertEquals((Object)xMLSignature.getKeyInfo(), (Object)this.defKi);
        XMLSignatureTest.assertTrue((boolean)Arrays.equals(xMLSignature.getObjects().toArray(), this.objs.toArray()));
        XMLSignatureTest.assertNull((Object)xMLSignature.getSignatureValue().getValue());
        XMLSignatureTest.assertEquals((Object)xMLSignature.getSignatureValue().getId(), (Object)this.sigValueId);
        XMLSignatureTest.assertEquals((Object)xMLSignature.getSignedInfo(), (Object)this.defSi);
        xMLSignature = this.fac.newXMLSignature(this.defSi, this.defKi);
        XMLSignatureTest.assertNull((Object)xMLSignature.getId());
        XMLSignatureTest.assertEquals((Object)xMLSignature.getKeyInfo(), (Object)this.defKi);
        XMLSignatureTest.assertTrue((xMLSignature.getObjects().size() == 0 ? 1 : 0) != 0);
        XMLSignatureTest.assertNull((Object)xMLSignature.getSignatureValue().getValue());
        XMLSignatureTest.assertNull((Object)xMLSignature.getSignatureValue().getId());
        XMLSignatureTest.assertEquals((Object)xMLSignature.getSignedInfo(), (Object)this.defSi);
    }

    @Test
    public void testisFeatureSupported() throws Exception {
        XMLSignature xMLSignature = this.fac.newXMLSignature(this.defSi, null);
        try {
            xMLSignature.isFeatureSupported(null);
            XMLSignatureTest.fail((String)"Should raise a NPE for null feature");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        XMLSignatureTest.assertTrue((!xMLSignature.isFeatureSupported("not supported") ? 1 : 0) != 0);
    }

    @Test
    public void testsignANDvalidate() throws Exception {
        KeyInfo keyInfo = null;
        boolean bl = true;
        for (int i = this.SIGN_KEYS.length - 1; i >= 0; --i) {
            SignedInfo signedInfo = this.createSignedInfo(this.SIG_METHODS[i]);
            keyInfo = this.VALIDATE_KEYS[i] instanceof PublicKey ? this.kifac.newKeyInfo(Collections.singletonList(this.kifac.newKeyValue((PublicKey)this.VALIDATE_KEYS[i]))) : this.kifac.newKeyInfo(Collections.singletonList(this.kifac.newKeyName("testuser")));
            XMLSignature xMLSignature = this.fac.newXMLSignature(signedInfo, keyInfo, this.objs, this.id, this.sigValueId);
            Document document = TestUtils.newDocument();
            DOMSignContext dOMSignContext = new DOMSignContext(this.SIGN_KEYS[i], (Node)document);
            dOMSignContext.setURIDereferencer(this.ud);
            xMLSignature.sign(dOMSignContext);
            DOMValidateContext dOMValidateContext = new DOMValidateContext(this.VALIDATE_KEYS[i], (Node)document.getDocumentElement());
            dOMValidateContext.setURIDereferencer(this.ud);
            if (xMLSignature.validate(dOMValidateContext)) continue;
            bl = false;
            TestUtils.dumpDocument(document, "signatureTest_out" + i + ".xml");
        }
        XMLSignatureTest.assertTrue((boolean)bl);
    }

    @Test
    public void testsignWithProvider() throws Exception {
        KeyInfo keyInfo = null;
        TestProvider testProvider = new TestProvider();
        for (int i = this.SIGN_KEYS.length - 2; i >= 0; --i) {
            SignedInfo signedInfo = this.createSignedInfo(this.SIG_METHODS[i]);
            keyInfo = this.VALIDATE_KEYS[i] instanceof PublicKey ? this.kifac.newKeyInfo(Collections.singletonList(this.kifac.newKeyValue((PublicKey)this.VALIDATE_KEYS[i]))) : this.kifac.newKeyInfo(Collections.singletonList(this.kifac.newKeyName("testuser")));
            XMLSignature xMLSignature = this.fac.newXMLSignature(signedInfo, keyInfo, this.objs, this.id, this.sigValueId);
            Document document = TestUtils.newDocument();
            DOMSignContext dOMSignContext = new DOMSignContext(this.SIGN_KEYS[i], (Node)document);
            dOMSignContext.setProperty("org.jcp.xml.dsig.internal.dom.SignatureProvider", testProvider);
            dOMSignContext.setURIDereferencer(this.ud);
            try {
                xMLSignature.sign(dOMSignContext);
                XMLSignatureTest.fail((String)("Should have failed because TestProvider does not support " + this.SIGN_KEYS[i].getAlgorithm()));
                continue;
            }
            catch (Exception exception) {
                XMLSignatureTest.assertTrue((String)exception.getMessage(), (boolean)(exception.getCause() instanceof NoSuchAlgorithmException));
            }
        }
    }

    @Test
    public void testSignWithEmptyNSPrefix() throws Exception {
        SignedInfo signedInfo = this.createSignedInfo(this.SIG_METHODS[1]);
        KeyInfo keyInfo = this.kifac.newKeyInfo(Collections.singletonList(this.kifac.newKeyValue((PublicKey)this.VALIDATE_KEYS[1])));
        XMLSignature xMLSignature = this.fac.newXMLSignature(signedInfo, keyInfo, this.objs, this.id, this.sigValueId);
        Document document = TestUtils.newDocument();
        DOMSignContext dOMSignContext = new DOMSignContext(this.SIGN_KEYS[1], (Node)document);
        dOMSignContext.putNamespacePrefix("http://www.w3.org/2000/09/xmldsig#", "");
        dOMSignContext.setURIDereferencer(this.ud);
        xMLSignature.sign(dOMSignContext);
    }

    @Test
    public void testSignWithReferenceManifestDependencies() throws Exception {
        DigestMethod digestMethod = this.fac.newDigestMethod("http://www.w3.org/2000/09/xmldsig#sha1", null);
        List<Reference> list = Collections.singletonList(this.fac.newReference("#object-1", digestMethod));
        CanonicalizationMethod canonicalizationMethod = this.fac.newCanonicalizationMethod("http://www.w3.org/TR/2001/REC-xml-c14n-20010315", (C14NMethodParameterSpec)null);
        SignedInfo signedInfo = this.fac.newSignedInfo(canonicalizationMethod, this.SIG_METHODS[1], list);
        ArrayList<XMLObject> arrayList = new ArrayList<XMLObject>();
        List<Reference> list2 = Collections.singletonList(this.fac.newReference("#object-2", digestMethod));
        arrayList.add(this.fac.newXMLObject(Collections.singletonList(this.fac.newManifest(list2, "manifest-1")), "object-1", null, null));
        Document document = TestUtils.newDocument();
        Element element = document.createElementNS(null, "NonCommentandus");
        element.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", "");
        element.appendChild(document.createComment(" Commentandum "));
        arrayList.add(this.fac.newXMLObject(Collections.singletonList(new DOMStructure(element)), "object-2", null, null));
        KeyInfo keyInfo = this.kifac.newKeyInfo(Collections.singletonList(this.kifac.newKeyValue((PublicKey)this.VALIDATE_KEYS[1])));
        XMLSignature xMLSignature = this.fac.newXMLSignature(signedInfo, keyInfo, arrayList, "signature", null);
        DOMSignContext dOMSignContext = new DOMSignContext(this.SIGN_KEYS[1], (Node)document);
        xMLSignature.sign(dOMSignContext);
        DOMValidateContext dOMValidateContext = new DOMValidateContext(this.VALIDATE_KEYS[1], (Node)document.getDocumentElement());
        XMLSignature xMLSignature2 = this.fac.unmarshalXMLSignature(dOMValidateContext);
        if (!xMLSignature.equals(xMLSignature2)) {
            throw new Exception("Unmarshalled signature is not equal to generated signature");
        }
        if (!xMLSignature2.validate(dOMValidateContext)) {
            throw new Exception("Validation of generated signature failed");
        }
    }

    @Test
    public void testSignTemplateWithObjectNSDefs() throws Exception {
        String string = System.getProperty("basedir") == null ? "./" : System.getProperty("basedir");
        File file = new File(string + "/src/test/resources/javax/xml/crypto/dsig/" + "signature-enveloping-rsa-template.xml");
        Document document = XMLUtils.createDocumentBuilder((boolean)false).parse(new FileInputStream(file));
        NodeList nodeList = document.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "Signature");
        if (nodeList.getLength() == 0) {
            throw new Exception("Cannot find Signature element");
        }
        DOMStructure dOMStructure = new DOMStructure(nodeList.item(0));
        XMLSignature xMLSignature = this.fac.unmarshalXMLSignature(dOMStructure);
        XMLSignature xMLSignature2 = this.fac.newXMLSignature(xMLSignature.getSignedInfo(), null, xMLSignature.getObjects(), xMLSignature.getId(), xMLSignature.getSignatureValue().getId());
        Node node = dOMStructure.getNode().getParentNode();
        DOMSignContext dOMSignContext = new DOMSignContext(this.SIGN_KEYS[0], node);
        node.removeChild(dOMStructure.getNode());
        xMLSignature2.sign(dOMSignContext);
        Element element = (Element)node.getFirstChild().getLastChild();
        Attr attr = element.getAttributeNode("xmlns:test");
        if (!attr.getValue().equals("http://www.example.org/ns")) {
            throw new Exception("Object namespace definition not retained");
        }
    }

    private SignedInfo createSignedInfo(SignatureMethod signatureMethod) throws Exception {
        CanonicalizationMethod canonicalizationMethod = this.fac.newCanonicalizationMethod("http://www.w3.org/TR/2001/REC-xml-c14n-20010315#WithComments", (C14NMethodParameterSpec)null);
        DigestMethod digestMethod = this.fac.newDigestMethod("http://www.w3.org/2000/09/xmldsig#sha1", null);
        List<Reference> list = Collections.singletonList(this.fac.newReference("http://www.w3.org/Signature/2002/04/xml-stylesheet.b64", digestMethod));
        return this.fac.newSignedInfo(canonicalizationMethod, signatureMethod, list);
    }

    static {
        Security.insertProviderAt((Provider)new XMLDSigRI(), 1);
    }

    static class TestProvider
    extends Provider {
        private static final long serialVersionUID = 1L;

        TestProvider() {
            super("TestProvider", 0.0, "TestProvider");
        }
    }
}

