/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.crypto.test.dsig;

import java.security.Key;
import javax.crypto.spec.SecretKeySpec;
import javax.xml.crypto.KeySelector;
import javax.xml.crypto.dsig.XMLValidateContext;
import javax.xml.crypto.dsig.dom.DOMValidateContext;
import javax.xml.crypto.test.dsig.TestUtils;
import org.junit.Assert;
import org.junit.Test;
import org.w3c.dom.Node;

public class XMLValidateContextTest
extends Assert {
    private XMLValidateContext defContext;
    private Key[] KEYS = new Key[3];
    private KeySelector[] KEY_SELECTORS;

    public XMLValidateContextTest() throws Exception {
        this.KEYS[0] = TestUtils.getPublicKey("DSA");
        this.KEYS[1] = TestUtils.getPublicKey("RSA");
        this.KEYS[2] = new SecretKeySpec(new byte[16], "HmacSHA1");
        SecretKeySpec secretKeySpec = new SecretKeySpec(new byte[8], "DES");
        this.defContext = new DOMValidateContext(secretKeySpec, (Node)TestUtils.newDocument());
        this.KEY_SELECTORS = new KeySelector[1];
        this.KEY_SELECTORS[0] = KeySelector.singletonKeySelector(secretKeySpec);
    }

    @Test
    public void testsetngetKeySelector() throws Exception {
        this.defContext.setKeySelector(null);
        XMLValidateContextTest.assertNull((Object)this.defContext.getKeySelector());
        for (int i = 0; i < this.KEY_SELECTORS.length; ++i) {
            this.defContext.setKeySelector(this.KEY_SELECTORS[i]);
            XMLValidateContextTest.assertEquals((Object)this.defContext.getKeySelector(), (Object)this.KEY_SELECTORS[i]);
        }
    }

    @Test
    public void testsetngetBaseURI() throws Exception {
        XMLValidateContextTest.assertNull((Object)this.defContext.getBaseURI());
        String string = "http://www.w3.org/2000/09/xmldsig#";
        this.defContext.setBaseURI(string);
        XMLValidateContextTest.assertEquals((Object)this.defContext.getBaseURI(), (Object)string);
        this.defContext.setBaseURI(null);
        XMLValidateContextTest.assertNull((Object)this.defContext.getBaseURI());
    }

    @Test
    public void testsetngetProperty() throws Exception {
        String string = "key";
        XMLValidateContextTest.assertNull((Object)this.defContext.getProperty(string));
        try {
            this.defContext.setProperty(null, null);
            XMLValidateContextTest.fail((String)"Should raise a NPE with a null name");
        }
        catch (NullPointerException nullPointerException) {
        }
        catch (Exception exception) {
            XMLValidateContextTest.fail((String)("Should raise a NPE instead of " + exception));
        }
        String string2 = "value#1";
        String string3 = "value#2";
        XMLValidateContextTest.assertNull((Object)this.defContext.setProperty(string, string2));
        XMLValidateContextTest.assertEquals((Object)this.defContext.getProperty(string), (Object)string2);
        XMLValidateContextTest.assertEquals((Object)this.defContext.setProperty(string, string3), (Object)string2);
        XMLValidateContextTest.assertEquals((Object)this.defContext.getProperty(string), (Object)string3);
        XMLValidateContextTest.assertEquals((Object)this.defContext.setProperty(string, null), (Object)string3);
        XMLValidateContextTest.assertNull((Object)this.defContext.getProperty(string));
    }

    @Test
    public void testsetngetURIDereferencer() throws Exception {
        XMLValidateContextTest.assertNull((Object)this.defContext.getURIDereferencer());
        byte[] byArray = "simpleDereferencer".getBytes();
        TestUtils.OctetStreamURIDereferencer octetStreamURIDereferencer = new TestUtils.OctetStreamURIDereferencer(byArray);
        this.defContext.setURIDereferencer(octetStreamURIDereferencer);
        XMLValidateContextTest.assertEquals((Object)this.defContext.getURIDereferencer(), (Object)octetStreamURIDereferencer);
        this.defContext.setURIDereferencer(null);
        XMLValidateContextTest.assertNull((Object)this.defContext.getURIDereferencer());
    }
}

