/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.crypto.test.dsig.keyinfo;

import java.security.Provider;
import java.util.Collections;
import java.util.List;
import javax.xml.crypto.XMLStructure;
import javax.xml.crypto.dom.DOMStructure;
import javax.xml.crypto.dsig.keyinfo.KeyInfo;
import javax.xml.crypto.dsig.keyinfo.KeyInfoFactory;
import org.apache.jcp.xml.dsig.internal.dom.DOMUtils;
import org.apache.jcp.xml.dsig.internal.dom.XMLDSigRI;
import org.apache.xml.security.utils.XMLUtils;
import org.junit.Assert;
import org.junit.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class KeyInfoTest
extends Assert {
    private KeyInfoFactory fac = KeyInfoFactory.getInstance("DOM", (Provider)new XMLDSigRI());

    @Test
    public void testgetId() {
        KeyInfo keyInfo = this.fac.newKeyInfo(Collections.singletonList(this.fac.newKeyName("foo")), "skeleton");
        KeyInfoTest.assertNotNull((Object)keyInfo.getId());
    }

    @Test
    public void testgetContent() {
        KeyInfo[] keyInfoArray = new KeyInfo[]{this.fac.newKeyInfo(Collections.singletonList(this.fac.newKeyName("foo")), "skeleton"), this.fac.newKeyInfo(Collections.singletonList(this.fac.newKeyName("foo")))};
        for (int i = 0; i < keyInfoArray.length; ++i) {
            KeyInfo keyInfo = keyInfoArray[i];
            List<XMLStructure> list = keyInfo.getContent();
            KeyInfoTest.assertNotNull(keyInfo.getContent());
            if (!list.isEmpty()) {
                Object[] objectArray = list.toArray();
                for (int j = 0; j < objectArray.length; ++j) {
                    if (objectArray[j] instanceof XMLStructure) continue;
                    KeyInfoTest.fail((String)"KeyInfo element has the wrong type");
                }
                continue;
            }
            try {
                list.add((XMLStructure)new Object());
                KeyInfoTest.fail((String)"Added KeyInfo element of wrong type");
                continue;
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
    }

    @Test
    public void testConstructor() {
        KeyInfo keyInfo = this.fac.newKeyInfo(Collections.singletonList(this.fac.newKeyName("foo")), "keyId");
        KeyInfoTest.assertEquals((Object)"keyId", (Object)keyInfo.getId());
        try {
            keyInfo = this.fac.newKeyInfo(null, "keyId");
            KeyInfoTest.fail((String)"Should raise a NullPointerException");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        keyInfo = this.fac.newKeyInfo(Collections.singletonList(this.fac.newKeyName("foo")));
    }

    @Test
    public void testisFeatureSupported() {
        KeyInfo keyInfo = this.fac.newKeyInfo(Collections.singletonList(this.fac.newKeyName("foo")), "keyid");
        try {
            keyInfo.isFeatureSupported(null);
            KeyInfoTest.fail((String)"Should raise a NPE for null feature");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        KeyInfoTest.assertTrue((!keyInfo.isFeatureSupported("not supported") ? 1 : 0) != 0);
    }

    @Test
    public void testMarshal() throws Exception {
        Element element;
        KeyInfo keyInfo = this.fac.newKeyInfo(Collections.singletonList(this.fac.newKeyName("foo")), "keyid");
        try {
            keyInfo.marshal(null, null);
            KeyInfoTest.fail((String)"Should raise a NullPointerException");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        Document document = XMLUtils.createDocumentBuilder((boolean)false).newDocument();
        Element element2 = document.createElementNS("http://acme.org", "parent");
        document.appendChild(element2);
        DOMStructure dOMStructure = new DOMStructure(element2);
        try {
            keyInfo.marshal(dOMStructure, null);
        }
        catch (Exception exception) {
            KeyInfoTest.fail((String)("Should not throw an exception: " + exception));
        }
        Element element3 = DOMUtils.getFirstChildElement((Node)element2);
        if (!element3.getLocalName().equals("KeyInfo")) {
            KeyInfoTest.fail((String)("Should be KeyInfo element: " + element3.getLocalName()));
        }
        if (!(element = DOMUtils.getFirstChildElement((Node)element3)).getLocalName().equals("KeyName")) {
            KeyInfoTest.fail((String)("Should be KeyName element: " + element.getLocalName()));
        }
    }
}

