/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.crypto.test.dsig.keyinfo;

import java.security.Provider;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.xml.crypto.XMLStructure;
import javax.xml.crypto.dsig.keyinfo.KeyInfoFactory;
import javax.xml.crypto.dsig.keyinfo.PGPData;
import org.apache.jcp.xml.dsig.internal.dom.XMLDSigRI;
import org.junit.Assert;
import org.junit.Test;

public class PGPDataTest
extends Assert {
    private KeyInfoFactory fac;
    private byte[][] values = new byte[][]{{1, 2, 3, 4, 5, 6, 7, 8}, {-58, 1, 0}};

    public PGPDataTest() throws Exception {
        this.fac = KeyInfoFactory.getInstance("DOM", (Provider)new XMLDSigRI());
    }

    @Test
    public void testgetExternalElements() {
        PGPData[] pGPDataArray = new PGPData[]{this.fac.newPGPData(this.values[0]), this.fac.newPGPData(this.values[0], this.values[1], null), this.fac.newPGPData(this.values[1], null)};
        for (int i = 0; i < pGPDataArray.length; ++i) {
            List<XMLStructure> list = pGPDataArray[i].getExternalElements();
            PGPDataTest.assertNotNull(list);
            if (list.isEmpty()) continue;
            Object[] objectArray = list.toArray();
            for (int j = 0; j < objectArray.length; ++j) {
                if (objectArray[j] instanceof XMLStructure) continue;
                PGPDataTest.fail((String)"PGP element has the wrong type");
            }
        }
        try {
            this.fac.newPGPData(this.values[0], Collections.singletonList(new Object()));
            PGPDataTest.fail((String)"Added PGP element of wrong type");
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
    }

    @Test
    public void testgetKeyId() {
        PGPData pGPData = this.fac.newPGPData(this.values[0]);
        PGPDataTest.assertNotNull((Object)pGPData.getKeyId());
        pGPData = this.fac.newPGPData(this.values[0], this.values[1], null);
        PGPDataTest.assertNotNull((Object)pGPData.getKeyId());
        pGPData = this.fac.newPGPData(this.values[1], null);
    }

    @Test
    public void testgetKeyPacket() {
        PGPData pGPData = this.fac.newPGPData(this.values[0]);
        pGPData = this.fac.newPGPData(this.values[0], this.values[1], null);
        PGPDataTest.assertNotNull((Object)pGPData.getKeyPacket());
        pGPData = this.fac.newPGPData(this.values[1], null);
        PGPDataTest.assertNotNull((Object)pGPData.getKeyPacket());
    }

    @Test
    public void testConstructor() {
        PGPData pGPData = this.fac.newPGPData(this.values[0]);
        PGPDataTest.assertTrue((boolean)Arrays.equals(this.values[0], pGPData.getKeyId()));
        pGPData = this.fac.newPGPData(this.values[0], this.values[1], null);
        PGPDataTest.assertTrue((boolean)Arrays.equals(this.values[0], pGPData.getKeyId()));
        PGPDataTest.assertTrue((boolean)Arrays.equals(this.values[1], pGPData.getKeyPacket()));
        pGPData = this.fac.newPGPData(this.values[1], null);
        PGPDataTest.assertTrue((boolean)Arrays.equals(this.values[1], pGPData.getKeyPacket()));
    }

    @Test
    public void testisFeatureSupported() {
        XMLStructure xMLStructure = null;
        for (int i = 0; i < 3; ++i) {
            switch (i) {
                case 0: {
                    xMLStructure = this.fac.newPGPData(this.values[0]);
                    break;
                }
                case 1: {
                    xMLStructure = this.fac.newPGPData(this.values[0], this.values[1], null);
                    break;
                }
                case 2: {
                    xMLStructure = this.fac.newPGPData(this.values[1], null);
                }
            }
            try {
                xMLStructure.isFeatureSupported(null);
                PGPDataTest.fail((String)"Should raise a NPE for null feature");
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            PGPDataTest.assertTrue((!xMLStructure.isFeatureSupported("not supported") ? 1 : 0) != 0);
        }
    }
}

