/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.crypto.test.dsig.keyinfo;

import java.security.Provider;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.List;
import javax.xml.crypto.XMLStructure;
import javax.xml.crypto.dsig.keyinfo.KeyInfoFactory;
import javax.xml.crypto.dsig.keyinfo.X509Data;
import org.apache.jcp.xml.dsig.internal.dom.XMLDSigRI;
import org.junit.Assert;
import org.junit.Test;

public class X509DataTest
extends Assert {
    private KeyInfoFactory fac = KeyInfoFactory.getInstance("DOM", (Provider)new XMLDSigRI());

    @Test
    public void testgetTypes() {
        X509Data x509Data = this.fac.newX509Data(Collections.singletonList("cn=foo"));
        List<?> list = x509Data.getContent();
        X509DataTest.assertNotNull(list);
        if (!list.isEmpty()) {
            Object[] objectArray = list.toArray();
            for (int i = 0; i < objectArray.length; ++i) {
                if (objectArray[i] instanceof String || objectArray[i] instanceof byte[] || objectArray[i] instanceof X509Certificate || objectArray[i] instanceof X509CRL || objectArray[i] instanceof XMLStructure) continue;
                X509DataTest.fail((String)"X509 element has the wrong type");
            }
        } else {
            list.add("any string");
            list.add(new byte[5]);
            try {
                list.add(new Object());
                X509DataTest.fail((String)"Added X509 element of wrong type");
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
    }

    @Test
    public void testConstructor() {
        X509Data x509Data = this.fac.newX509Data(Collections.singletonList("cn=foo"));
        X509DataTest.assertNotNull((Object)x509Data);
    }

    @Test
    public void testisFeatureSupported() {
        X509Data x509Data = this.fac.newX509Data(Collections.singletonList("cn=foo"));
        try {
            x509Data.isFeatureSupported(null);
            X509DataTest.fail((String)"Should raise a NPE for null feature");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        X509DataTest.assertTrue((!x509Data.isFeatureSupported("not supported") ? 1 : 0) != 0);
    }
}

