/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.crypto.test.dsig.keyinfo;

import java.math.BigInteger;
import java.security.Provider;
import javax.xml.crypto.dsig.keyinfo.KeyInfoFactory;
import javax.xml.crypto.dsig.keyinfo.X509IssuerSerial;
import org.apache.jcp.xml.dsig.internal.dom.XMLDSigRI;
import org.junit.Assert;
import org.junit.Test;

public class X509IssuerSerialTest
extends Assert {
    private KeyInfoFactory fac = KeyInfoFactory.getInstance("DOM", (Provider)new XMLDSigRI());
    private String name = "CN = Wolfgang";

    @Test
    public void testgetIssuerName() {
        X509IssuerSerial x509IssuerSerial = this.fac.newX509IssuerSerial(this.name, BigInteger.ZERO);
        X509IssuerSerialTest.assertNotNull((Object)x509IssuerSerial.getIssuerName());
    }

    @Test
    public void testgetSerialNumber() {
        X509IssuerSerial x509IssuerSerial = this.fac.newX509IssuerSerial(this.name, BigInteger.ZERO);
        X509IssuerSerialTest.assertNotNull((Object)x509IssuerSerial.getSerialNumber());
    }

    @Test
    public void testConstructor() {
        X509IssuerSerial x509IssuerSerial = this.fac.newX509IssuerSerial(this.name, BigInteger.ONE);
        X509IssuerSerialTest.assertEquals((Object)this.name, (Object)x509IssuerSerial.getIssuerName());
        X509IssuerSerialTest.assertEquals((Object)BigInteger.ONE, (Object)x509IssuerSerial.getSerialNumber());
    }

    @Test
    public void testConstructorBadIssuerName() {
        String string = "cn=bad,=+bad,";
        try {
            this.fac.newX509IssuerSerial(string, BigInteger.ONE);
            X509IssuerSerialTest.fail((String)"Should raise an IllegalArgumentException when issuer distinguished name does not conform to RFC 2253");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testisFeatureSupported() {
        X509IssuerSerial x509IssuerSerial = this.fac.newX509IssuerSerial(this.name, BigInteger.ONE);
        try {
            x509IssuerSerial.isFeatureSupported(null);
            X509IssuerSerialTest.fail((String)"Should raise a NPE for null feature");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        X509IssuerSerialTest.assertTrue((!x509IssuerSerial.isFeatureSupported("not supported") ? 1 : 0) != 0);
    }
}

