/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.test.algorithms;

import java.security.Key;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xml.security.Init;
import org.apache.xml.security.algorithms.SignatureAlgorithm;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.utils.XMLUtils;
import org.junit.Assert;
import org.junit.Test;
import org.w3c.dom.Document;

public class SignatureAlgorithmTest
extends Assert {
    static Log log = LogFactory.getLog((String)SignatureAlgorithmTest.class.getName());

    @Test
    public void testSameKeySeveralAlgorithmSigning() throws Exception {
        Document document = XMLUtils.createDocumentBuilder((boolean)false).newDocument();
        SignatureAlgorithm signatureAlgorithm = new SignatureAlgorithm(document, "http://www.w3.org/2000/09/xmldsig#rsa-sha1");
        PrivateKey privateKey = KeyPairGenerator.getInstance("RSA").genKeyPair().getPrivate();
        signatureAlgorithm.initSign((Key)privateKey);
        signatureAlgorithm.update((byte)2);
        signatureAlgorithm.sign();
        SignatureAlgorithm signatureAlgorithm2 = new SignatureAlgorithm(document, "http://www.w3.org/2001/04/xmldsig-more#rsa-sha256");
        try {
            signatureAlgorithm2.initSign((Key)privateKey);
        }
        catch (XMLSecurityException xMLSecurityException) {
            log.warn((Object)"Test testSameKeySeveralAlgorithmSigning skipped as necessary algorithms not available");
            return;
        }
        signatureAlgorithm2.update((byte)2);
        signatureAlgorithm2.sign();
    }

    static {
        Init.init();
    }
}

