/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.test.c14n.helper;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xml.security.Init;
import org.apache.xml.security.c14n.helper.C14nHelper;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

public class C14nHelperTest
extends Assert {
    static Log log = LogFactory.getLog((String)C14nHelperTest.class.getName());

    @Test
    public void testNamespaceIsAbsolute01() {
        String string = "http://www.w3.org/Signature/";
        C14nHelperTest.assertTrue((String)("URI fails: \"" + string + "\""), (boolean)C14nHelper.namespaceIsAbsolute((String)string));
    }

    @Test
    public void testNamespaceIsAbsolute02() {
        String string = "http://www.w3.org/../blah";
        C14nHelperTest.assertTrue((String)("URI fails: \"" + string + "\""), (boolean)C14nHelper.namespaceIsAbsolute((String)string));
    }

    @Test
    public void testNamespaceIsAbsolute03() {
        String string = "hxxp://www.w3.org/";
        C14nHelperTest.assertTrue((String)("URI fails: \"" + string + "\""), (boolean)C14nHelper.namespaceIsAbsolute((String)string));
    }

    @Test
    public void testNamespaceIsRelative01() {
        String string = "../blah";
        C14nHelperTest.assertTrue((String)("URI fails: \"" + string + "\""), (boolean)C14nHelper.namespaceIsRelative((String)string));
    }

    @Test
    public void testNamespaceIsRelative02() {
        String string = "blah";
        C14nHelperTest.assertTrue((String)("URI fails: \"" + string + "\""), (boolean)C14nHelper.namespaceIsRelative((String)string));
    }

    @Test
    @Ignore
    public void testNamespaceIsRelative03() {
        String string = "http://...";
        C14nHelperTest.assertTrue((String)("URI fails: \"" + string + "\""), (boolean)C14nHelper.namespaceIsRelative((String)string));
    }

    static {
        Init.init();
    }
}

