/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.test.c14n.implementations;

import java.io.FileInputStream;
import java.security.Key;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import javax.xml.parsers.DocumentBuilder;
import org.apache.xml.security.Init;
import org.apache.xml.security.c14n.Canonicalizer;
import org.apache.xml.security.keys.KeyInfo;
import org.apache.xml.security.signature.ObjectContainer;
import org.apache.xml.security.signature.XMLSignature;
import org.apache.xml.security.signature.XMLSignatureException;
import org.apache.xml.security.test.c14n.implementations.MockCanonicalizationMethod;
import org.apache.xml.security.transforms.Transforms;
import org.apache.xml.security.utils.XMLUtils;
import org.junit.Assert;
import org.junit.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Bug45961Test
extends Assert {
    private static final String OBJECT_ID = "Object";
    private static final String MOCK_CANONICALIZATION_METHOD = "mock.canonicalization.method";
    private static final char[] PASSWORD = "changeit".toCharArray();
    private static final String ALIAS = "mullan";
    private DocumentBuilder _builder;
    private ObjectContainer object;

    public Bug45961Test() throws Exception {
        Init.init();
        Canonicalizer.register((String)MOCK_CANONICALIZATION_METHOD, (String)MockCanonicalizationMethod.class.getName());
        this._builder = XMLUtils.createDocumentBuilder((boolean)false);
    }

    @Test
    public void testBug() throws Exception {
        Document document = this.getSignedDocument();
        NodeList nodeList = document.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "Signature");
        Element element = (Element)nodeList.item(0);
        XMLSignature xMLSignature = new XMLSignature(element, null);
        KeyInfo keyInfo = xMLSignature.getKeyInfo();
        X509Certificate x509Certificate = keyInfo.getX509Certificate();
        Bug45961Test.assertNotNull((Object)x509Certificate);
        try {
            xMLSignature.checkSignatureValue(x509Certificate);
        }
        catch (XMLSignatureException xMLSignatureException) {
            Bug45961Test.fail((String)xMLSignatureException.getMessage());
        }
    }

    private Document getSignedDocument() throws Exception {
        KeyStore keyStore = KeyStore.getInstance("JKS");
        FileInputStream fileInputStream = new FileInputStream(this.getAbsolutePath("src/test/resources/test.jks"));
        keyStore.load(fileInputStream, PASSWORD);
        fileInputStream.close();
        PrivateKey privateKey = (PrivateKey)keyStore.getKey(ALIAS, PASSWORD);
        X509Certificate x509Certificate = (X509Certificate)keyStore.getCertificate(ALIAS);
        Document document = this._builder.newDocument();
        XMLSignature xMLSignature = new XMLSignature(document, null, "http://www.w3.org/2000/09/xmldsig#dsa-sha1", MOCK_CANONICALIZATION_METHOD);
        Element element = document.createElementNS("", "RootElement");
        element.appendChild(document.createTextNode("Some simple test\n"));
        element.appendChild(xMLSignature.getElement());
        document.appendChild(element);
        Element element2 = document.createElementNS("", "RootElement");
        element2.appendChild(document.createTextNode("Some simple test\n"));
        this.object = new ObjectContainer(document);
        this.object.appendChild((Node)element2);
        this.object.setId(OBJECT_ID);
        element.appendChild(this.object.getElement());
        xMLSignature.addDocument("#Object");
        xMLSignature.addDocument("", this.getTransforms(document));
        xMLSignature.addKeyInfo(x509Certificate);
        xMLSignature.sign((Key)privateKey);
        return document;
    }

    private Transforms getTransforms(Document document) throws Exception {
        Transforms transforms = new Transforms(document);
        transforms.addTransform("http://www.w3.org/2000/09/xmldsig#enveloped-signature");
        return transforms;
    }

    private String getAbsolutePath(String string) {
        String string2 = System.getProperty("basedir");
        if (string2 != null && !"".equals(string2)) {
            string = string2 + "/" + string;
        }
        return string;
    }
}

