/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.test.c14n.implementations;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.MessageDigest;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.NamespaceContext;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xml.security.Init;
import org.apache.xml.security.c14n.CanonicalizationException;
import org.apache.xml.security.c14n.Canonicalizer;
import org.apache.xml.security.c14n.InvalidCanonicalizerException;
import org.apache.xml.security.test.DSNamespaceContext;
import org.apache.xml.security.utils.IgnoreAllErrorHandler;
import org.apache.xml.security.utils.JavaUtils;
import org.apache.xml.security.utils.XMLUtils;
import org.junit.Assert;
import org.junit.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Canonicalizer11Test
extends Assert {
    static Log log = LogFactory.getLog((String)Canonicalizer11Test.class.getName());
    private String prefix = "src/test/resources/org/apache/xml/security/c14n/";

    public Canonicalizer11Test() {
        String string = System.getProperty("basedir");
        if (string != null && !"".equals(string)) {
            this.prefix = string + "/" + this.prefix;
        }
    }

    @Test
    public void test31withCommentsSubtree() throws IOException, FileNotFoundException, SAXException, ParserConfigurationException, CanonicalizationException, InvalidCanonicalizerException, TransformerException, XPathExpressionException {
        String string = "3.1: PIs, Comments, and Outside of Document Element. (commented)";
        String string2 = this.prefix + "in/31_input.xml";
        String string3 = this.prefix + "in/31_c14n-comments.xml";
        String string4 = this.prefix + "out/xpath_31_output-comments.xml";
        String string5 = "http://www.w3.org/2006/12/xml-c14n11#WithComments";
        boolean bl = true;
        String string6 = null;
        Canonicalizer11Test.assertTrue((String)string, (boolean)this.c14nAndCompare(string2, string3, string4, string5, bl, string6));
    }

    @Test
    public void test32subtree() throws IOException, FileNotFoundException, SAXException, ParserConfigurationException, CanonicalizationException, InvalidCanonicalizerException, TransformerException, XPathExpressionException {
        String string = "3.2 Whitespace in Document Content. (uncommented)";
        String string2 = this.prefix + "in/32_input.xml";
        String string3 = this.prefix + "in/32_c14n.xml";
        String string4 = this.prefix + "out/xpath_32_output.xml";
        String string5 = "http://www.w3.org/2006/12/xml-c14n11";
        boolean bl = true;
        String string6 = null;
        Canonicalizer11Test.assertTrue((String)string, (boolean)this.c14nAndCompare(string2, string3, string4, string5, bl, string6));
    }

    @Test
    public void test33subtree() throws IOException, FileNotFoundException, SAXException, ParserConfigurationException, CanonicalizationException, InvalidCanonicalizerException, TransformerException, XPathExpressionException {
        String string = "3.3 Start and End Tags. (uncommented)";
        String string2 = this.prefix + "in/33_input.xml";
        String string3 = this.prefix + "in/33_c14n.xml";
        String string4 = this.prefix + "out/xpath_33_output.xml";
        String string5 = "http://www.w3.org/2006/12/xml-c14n11";
        boolean bl = true;
        String string6 = null;
        Canonicalizer11Test.assertTrue((String)string, (boolean)this.c14nAndCompare(string2, string3, string4, string5, bl, string6));
    }

    @Test
    public void test34() throws IOException, FileNotFoundException, SAXException, ParserConfigurationException, CanonicalizationException, InvalidCanonicalizerException, TransformerException, XPathExpressionException {
        String string = "3.4 Character Modifications and Character References. (uncommented)";
        String string2 = this.prefix + "in/34_input.xml";
        String string3 = this.prefix + "in/34_c14n.xml";
        String string4 = this.prefix + "out/xpath_34_output.xml";
        String string5 = "http://www.w3.org/2006/12/xml-c14n11";
        boolean bl = false;
        String string6 = null;
        Canonicalizer11Test.assertTrue((String)string, (boolean)this.c14nAndCompare(string2, string3, string4, string5, bl, string6));
    }

    @Test
    public void test35subtree() throws IOException, FileNotFoundException, SAXException, ParserConfigurationException, CanonicalizationException, InvalidCanonicalizerException, TransformerException, XPathExpressionException {
        String string = "3.5 Entity References. (uncommented)";
        String string2 = this.prefix + "in/35_input.xml";
        String string3 = this.prefix + "in/35_c14n.xml";
        String string4 = this.prefix + "out/xpath_35_output.xml";
        String string5 = "http://www.w3.org/2006/12/xml-c14n11";
        boolean bl = true;
        String string6 = null;
        Canonicalizer11Test.assertTrue((String)string, (boolean)this.c14nAndCompare(string2, string3, string4, string5, bl, string6));
    }

    @Test
    public void test36subtree() throws IOException, FileNotFoundException, SAXException, ParserConfigurationException, CanonicalizationException, InvalidCanonicalizerException, TransformerException, XPathExpressionException {
        String string = "3.6 UTF-8 Encoding. (uncommented)";
        String string2 = this.prefix + "in/36_input.xml";
        String string3 = this.prefix + "in/36_c14n.xml";
        String string4 = this.prefix + "out/xpath_36_output.xml";
        String string5 = "http://www.w3.org/2006/12/xml-c14n11";
        boolean bl = true;
        String string6 = null;
        Canonicalizer11Test.assertTrue((String)string, (boolean)this.c14nAndCompare(string2, string3, string4, string5, bl, string6));
    }

    @Test
    public void test37() throws IOException, FileNotFoundException, SAXException, ParserConfigurationException, CanonicalizationException, InvalidCanonicalizerException, TransformerException, XPathExpressionException {
        String string = "3.7 Document Subsets. (uncommented)";
        String string2 = this.prefix + "in/37_input.xml";
        String string3 = this.prefix + "in/37_c14n.xml";
        String string4 = this.prefix + "out/xpath_37_output.xml";
        String string5 = "http://www.w3.org/2006/12/xml-c14n11";
        boolean bl = true;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("ietf", "http://www.ietf.org");
        String string6 = "(//. | //@* | //namespace::*)[ self::ietf:e1 or (parent::ietf:e1 and not(self::text() or self::e2)) or count(id(\"E3\")|ancestor-or-self::node()) = count(ancestor-or-self::node()) ]";
        Canonicalizer11Test.assertTrue((String)string, (boolean)this.c14nAndCompare(string2, string3, string4, string5, bl, string6, hashMap));
    }

    @Test
    public void test38() throws IOException, FileNotFoundException, SAXException, ParserConfigurationException, CanonicalizationException, InvalidCanonicalizerException, TransformerException, XPathExpressionException {
        String string = "3.8 Document Subsets and XML Attributes (uncommented)";
        String string2 = this.prefix + "in/38_input.xml";
        String string3 = this.prefix + "in/38_c14n.xml";
        String string4 = this.prefix + "out/xpath_38_output.xml";
        String string5 = "http://www.w3.org/2006/12/xml-c14n11";
        boolean bl = true;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("ietf", "http://www.ietf.org");
        String string6 = "(//. | //@* | //namespace::*)[ self::ietf:e1 or (parent::ietf:e1 and not(self::text() or self::e2)) or count(id(\"E3\")|ancestor-or-self::node()) = count(ancestor-or-self::node()) ]";
        Canonicalizer11Test.assertTrue((String)string, (boolean)this.c14nAndCompare(string2, string3, string4, string5, bl, string6, hashMap));
    }

    private boolean c14nAndCompare(String string, String string2, String string3, String string4, boolean bl, String string5) throws IOException, FileNotFoundException, SAXException, ParserConfigurationException, CanonicalizationException, InvalidCanonicalizerException, TransformerException, XPathExpressionException {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        return this.c14nAndCompare(string, string2, string3, string4, bl, string5, hashMap);
    }

    private boolean c14nAndCompare(String string, String string2, String string3, String string4, boolean bl, String string5, Map<String, String> map) throws IOException, FileNotFoundException, SAXException, ParserConfigurationException, CanonicalizationException, InvalidCanonicalizerException, TransformerException, XPathExpressionException {
        Object object;
        Object object2;
        Object object3;
        DocumentBuilder documentBuilder = XMLUtils.createDocumentBuilder((boolean)bl, (boolean)false);
        documentBuilder.setErrorHandler((ErrorHandler)new IgnoreAllErrorHandler());
        Document document = documentBuilder.parse(string);
        Canonicalizer canonicalizer = Canonicalizer.getInstance((String)string4);
        byte[] byArray = null;
        if (string5 == null) {
            byArray = canonicalizer.canonicalizeSubtree((Node)document);
        } else {
            object3 = null;
            XPathFactory xPathFactory = XPathFactory.newInstance();
            object2 = xPathFactory.newXPath();
            object = new DSNamespaceContext(map);
            object2.setNamespaceContext((NamespaceContext)object);
            object3 = (NodeList)object2.evaluate(string5, document, XPathConstants.NODESET);
            byArray = canonicalizer.canonicalizeXPathNodeSet((NodeList)object3);
        }
        object3 = JavaUtils.getBytesFromFile((String)string2);
        boolean bl2 = MessageDigest.isEqual(object3, byArray);
        if (!bl2) {
            object2 = new File(string3);
            if (!((File)object2).exists()) {
                object = new File(((File)object2).getParent());
                ((File)object).mkdirs();
                ((File)object2).createNewFile();
            }
            object = new FileOutputStream((File)object2);
            ((FileOutputStream)object).write(byArray);
            log.debug((Object)("Wrote erroneous result to file " + ((File)object2).toURI().toURL().toString()));
            Canonicalizer11Test.assertEquals((Object)new String((byte[])object3), (Object)new String(byArray));
            ((FileOutputStream)object).close();
        }
        return bl2;
    }

    static {
        Init.init();
    }
}

