/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.test.c14n.implementations;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.NamespaceContext;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xml.security.Init;
import org.apache.xml.security.c14n.CanonicalizationException;
import org.apache.xml.security.c14n.Canonicalizer;
import org.apache.xml.security.c14n.InvalidCanonicalizerException;
import org.apache.xml.security.test.DSNamespaceContext;
import org.apache.xml.security.test.resource.TestVectorResolver;
import org.apache.xml.security.utils.IgnoreAllErrorHandler;
import org.apache.xml.security.utils.JavaUtils;
import org.apache.xml.security.utils.XMLUtils;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Canonicalizer20010315Test
extends Assert {
    static Log log = LogFactory.getLog((String)Canonicalizer20010315Test.class.getName());
    private String prefix = "src/test/resources/org/apache/xml/security/c14n/";

    public Canonicalizer20010315Test() {
        String string = System.getProperty("basedir");
        if (string != null && !"".equals(string)) {
            this.prefix = string + "/" + this.prefix;
        }
    }

    @Test
    public void test31withCommentsSubtree() throws IOException, FileNotFoundException, SAXException, ParserConfigurationException, CanonicalizationException, InvalidCanonicalizerException, TransformerException, XPathExpressionException {
        String string = "3.1: PIs, Comments, and Outside of Document Element. (commented)";
        String string2 = this.prefix + "in/31_input.xml";
        String string3 = this.prefix + "in/31_c14n-comments.xml";
        String string4 = this.prefix + "out/xpath_31_output-comments.xml";
        String string5 = "http://www.w3.org/TR/2001/REC-xml-c14n-20010315#WithComments";
        boolean bl = true;
        String string6 = null;
        Canonicalizer20010315Test.assertTrue((String)string, (boolean)this.c14nAndCompare(string2, string3, string4, string5, bl, string6));
    }

    @Test
    public void test31withCommentsSubset() throws IOException, FileNotFoundException, SAXException, ParserConfigurationException, CanonicalizationException, InvalidCanonicalizerException, TransformerException, XPathExpressionException {
        String string = "3.1: PIs, Comments, and Outside of Document Element. (commented)";
        String string2 = this.prefix + "in/31_input.xml";
        String string3 = this.prefix + "in/31_c14n-comments.xml";
        String string4 = this.prefix + "out/xpath_31_output-comments.xml";
        String string5 = "http://www.w3.org/TR/2001/REC-xml-c14n-20010315#WithComments";
        boolean bl = true;
        String string6 = "(.//. | .//@* | .//namespace::*)";
        Canonicalizer20010315Test.assertTrue((String)string, (boolean)this.c14nAndCompare(string2, string3, string4, string5, bl, string6));
    }

    @Test
    public void test31subtree() throws IOException, FileNotFoundException, SAXException, ParserConfigurationException, CanonicalizationException, InvalidCanonicalizerException, TransformerException, XPathExpressionException {
        String string = "3.1: PIs, Comments, and Outside of Document Element. (uncommented)";
        String string2 = this.prefix + "in/31_input.xml";
        String string3 = this.prefix + "in/31_c14n.xml";
        String string4 = this.prefix + "out/xpath_31_output.xml";
        String string5 = "http://www.w3.org/TR/2001/REC-xml-c14n-20010315";
        boolean bl = true;
        String string6 = null;
        Canonicalizer20010315Test.assertTrue((String)string, (boolean)this.c14nAndCompare(string2, string3, string4, string5, bl, string6));
    }

    @Test
    public void test31subset() throws IOException, FileNotFoundException, SAXException, ParserConfigurationException, CanonicalizationException, InvalidCanonicalizerException, TransformerException, XPathExpressionException {
        String string = "3.1: PIs, Comments, and Outside of Document Element. (uncommented)";
        String string2 = this.prefix + "in/31_input.xml";
        String string3 = this.prefix + "in/31_c14n.xml";
        String string4 = this.prefix + "out/xpath_31_output.xml";
        String string5 = "http://www.w3.org/TR/2001/REC-xml-c14n-20010315";
        boolean bl = true;
        String string6 = "(.//. | .//@* | .//namespace::*)";
        Canonicalizer20010315Test.assertTrue((String)string, (boolean)this.c14nAndCompare(string2, string3, string4, string5, bl, string6));
    }

    @Test
    public void test32subtree() throws IOException, FileNotFoundException, SAXException, ParserConfigurationException, CanonicalizationException, InvalidCanonicalizerException, TransformerException, XPathExpressionException {
        String string = "3.2 Whitespace in Document Content. (uncommented)";
        String string2 = this.prefix + "in/32_input.xml";
        String string3 = this.prefix + "in/32_c14n.xml";
        String string4 = this.prefix + "out/xpath_32_output.xml";
        String string5 = "http://www.w3.org/TR/2001/REC-xml-c14n-20010315";
        boolean bl = true;
        String string6 = null;
        Canonicalizer20010315Test.assertTrue((String)string, (boolean)this.c14nAndCompare(string2, string3, string4, string5, bl, string6));
    }

    @Test
    public void test32subset() throws IOException, FileNotFoundException, SAXException, ParserConfigurationException, CanonicalizationException, InvalidCanonicalizerException, TransformerException, XPathExpressionException {
        String string = "3.2 Whitespace in Document Content. (uncommented)";
        String string2 = this.prefix + "in/32_input.xml";
        String string3 = this.prefix + "in/32_c14n.xml";
        String string4 = this.prefix + "out/xpath_32_output.xml";
        String string5 = "http://www.w3.org/TR/2001/REC-xml-c14n-20010315";
        boolean bl = true;
        String string6 = "(.//. | .//@* | .//namespace::*)";
        Canonicalizer20010315Test.assertTrue((String)string, (boolean)this.c14nAndCompare(string2, string3, string4, string5, bl, string6));
    }

    @Test
    public void test33subtree() throws IOException, FileNotFoundException, SAXException, ParserConfigurationException, CanonicalizationException, InvalidCanonicalizerException, TransformerException, XPathExpressionException {
        String string = "3.3 Start and End Tags. (uncommented)";
        String string2 = this.prefix + "in/33_input.xml";
        String string3 = this.prefix + "in/33_c14n.xml";
        String string4 = this.prefix + "out/xpath_33_output.xml";
        String string5 = "http://www.w3.org/TR/2001/REC-xml-c14n-20010315";
        boolean bl = true;
        String string6 = null;
        Canonicalizer20010315Test.assertTrue((String)string, (boolean)this.c14nAndCompare(string2, string3, string4, string5, bl, string6));
    }

    @Test
    public void test33subset() throws IOException, FileNotFoundException, SAXException, ParserConfigurationException, CanonicalizationException, InvalidCanonicalizerException, TransformerException, XPathExpressionException {
        String string = "3.3 Start and End Tags. (uncommented)";
        String string2 = this.prefix + "in/33_input.xml";
        String string3 = this.prefix + "in/33_c14n.xml";
        String string4 = this.prefix + "out/xpath_33_output.xml";
        String string5 = "http://www.w3.org/TR/2001/REC-xml-c14n-20010315";
        boolean bl = true;
        String string6 = "(.//. | .//@* | .//namespace::*)";
        Canonicalizer20010315Test.assertTrue((String)string, (boolean)this.c14nAndCompare(string2, string3, string4, string5, bl, string6));
    }

    @Test
    public void test34() throws IOException, FileNotFoundException, SAXException, ParserConfigurationException, CanonicalizationException, InvalidCanonicalizerException, TransformerException, XPathExpressionException {
        String string = "3.4 Character Modifications and Character References. (uncommented)";
        String string2 = this.prefix + "in/34_input.xml";
        String string3 = this.prefix + "in/34_c14n.xml";
        String string4 = this.prefix + "out/xpath_34_output.xml";
        String string5 = "http://www.w3.org/TR/2001/REC-xml-c14n-20010315";
        boolean bl = false;
        String string6 = null;
        Canonicalizer20010315Test.assertTrue((String)string, (boolean)this.c14nAndCompare(string2, string3, string4, string5, bl, string6));
    }

    @Test
    public void test34subtree() throws IOException, FileNotFoundException, SAXException, ParserConfigurationException, CanonicalizationException, InvalidCanonicalizerException, TransformerException, XPathExpressionException {
        String string = "3.4 Character Modifications and Character References. (uncommented, patched to run on validating Parsers)";
        String string2 = this.prefix + "in/34_input_validatingParser.xml";
        String string3 = this.prefix + "in/34_c14n_validatingParser.xml";
        String string4 = this.prefix + "out/xpath_34_output_validatingParser.xml";
        String string5 = "http://www.w3.org/TR/2001/REC-xml-c14n-20010315";
        boolean bl = true;
        String string6 = null;
        Canonicalizer20010315Test.assertTrue((String)string, (boolean)this.c14nAndCompare(string2, string3, string4, string5, bl, string6));
    }

    @Test
    public void test34subset() throws IOException, FileNotFoundException, SAXException, ParserConfigurationException, CanonicalizationException, InvalidCanonicalizerException, TransformerException, XPathExpressionException {
        String string = "3.4 Character Modifications and Character References. (uncommented, patched to run on validating Parsers)";
        String string2 = this.prefix + "in/34_input_validatingParser.xml";
        String string3 = this.prefix + "in/34_c14n_validatingParser.xml";
        String string4 = this.prefix + "out/xpath_34_output_validatingParser.xml";
        String string5 = "http://www.w3.org/TR/2001/REC-xml-c14n-20010315";
        boolean bl = true;
        String string6 = "(.//. | .//@* | .//namespace::*)";
        Canonicalizer20010315Test.assertTrue((String)string, (boolean)this.c14nAndCompare(string2, string3, string4, string5, bl, string6));
    }

    @Test
    public void test35subtree() throws IOException, FileNotFoundException, SAXException, ParserConfigurationException, CanonicalizationException, InvalidCanonicalizerException, TransformerException, XPathExpressionException {
        String string = "3.5 Entity References. (uncommented)";
        String string2 = this.prefix + "in/35_input.xml";
        String string3 = this.prefix + "in/35_c14n.xml";
        String string4 = this.prefix + "out/xpath_35_output.xml";
        String string5 = "http://www.w3.org/TR/2001/REC-xml-c14n-20010315";
        boolean bl = true;
        String string6 = null;
        Canonicalizer20010315Test.assertTrue((String)string, (boolean)this.c14nAndCompare(string2, string3, string4, string5, bl, string6));
    }

    @Test
    public void test35subset() throws IOException, FileNotFoundException, SAXException, ParserConfigurationException, CanonicalizationException, InvalidCanonicalizerException, TransformerException, XPathExpressionException {
        String string = "3.5 Entity References. (uncommented)";
        String string2 = this.prefix + "in/35_input.xml";
        String string3 = this.prefix + "in/35_c14n.xml";
        String string4 = this.prefix + "out/xpath_35_output.xml";
        String string5 = "http://www.w3.org/TR/2001/REC-xml-c14n-20010315";
        boolean bl = true;
        String string6 = "(.//. | .//@* | .//namespace::*)";
        Canonicalizer20010315Test.assertTrue((String)string, (boolean)this.c14nAndCompare(string2, string3, string4, string5, bl, string6));
    }

    @Test
    public void test36subtree() throws IOException, FileNotFoundException, SAXException, ParserConfigurationException, CanonicalizationException, InvalidCanonicalizerException, TransformerException, XPathExpressionException {
        String string = "3.6 UTF-8 Encoding. (uncommented)";
        String string2 = this.prefix + "in/36_input.xml";
        String string3 = this.prefix + "in/36_c14n.xml";
        String string4 = this.prefix + "out/xpath_36_output.xml";
        String string5 = "http://www.w3.org/TR/2001/REC-xml-c14n-20010315";
        boolean bl = true;
        String string6 = null;
        Canonicalizer20010315Test.assertTrue((String)string, (boolean)this.c14nAndCompare(string2, string3, string4, string5, bl, string6));
    }

    @Test
    public void test36subset() throws IOException, FileNotFoundException, SAXException, ParserConfigurationException, CanonicalizationException, InvalidCanonicalizerException, TransformerException, XPathExpressionException {
        String string = "3.6 UTF-8 Encoding. (uncommented)";
        String string2 = this.prefix + "in/36_input.xml";
        String string3 = this.prefix + "in/36_c14n.xml";
        String string4 = this.prefix + "out/xpath_36_output.xml";
        String string5 = "http://www.w3.org/TR/2001/REC-xml-c14n-20010315";
        boolean bl = true;
        String string6 = "(.//. | .//@* | .//namespace::*)";
        Canonicalizer20010315Test.assertTrue((String)string, (boolean)this.c14nAndCompare(string2, string3, string4, string5, bl, string6));
    }

    @Test
    public void test37() throws IOException, FileNotFoundException, SAXException, ParserConfigurationException, CanonicalizationException, InvalidCanonicalizerException, TransformerException, XPathExpressionException {
        String string = "3.7 Document Subsets. (uncommented)";
        String string2 = this.prefix + "in/37_input.xml";
        String string3 = this.prefix + "in/37_c14n.xml";
        String string4 = this.prefix + "out/xpath_37_output.xml";
        String string5 = "http://www.w3.org/TR/2001/REC-xml-c14n-20010315";
        boolean bl = true;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("ietf", "http://www.ietf.org");
        String string6 = "(//. | //@* | //namespace::*)[ self::ietf:e1 or (parent::ietf:e1 and not(self::text() or self::e2)) or count(id(\"E3\")|ancestor-or-self::node()) = count(ancestor-or-self::node()) ]";
        Canonicalizer20010315Test.assertTrue((String)string, (boolean)this.c14nAndCompare(string2, string3, string4, string5, bl, string6, hashMap));
    }

    @Test
    public void test37byNodeList() throws IOException, FileNotFoundException, SAXException, ParserConfigurationException, CanonicalizationException, InvalidCanonicalizerException, TransformerException, XPathExpressionException {
        String string = this.prefix + "in/37_input.xml";
        String string2 = this.prefix + "in/37_c14n.xml";
        DocumentBuilder documentBuilder = XMLUtils.createDocumentBuilder((boolean)false, (boolean)false);
        TestVectorResolver testVectorResolver = new TestVectorResolver();
        documentBuilder.setEntityResolver(testVectorResolver);
        Document document = documentBuilder.parse(testVectorResolver.resolveEntity(null, string));
        String string3 = "(//. | //@* | //namespace::*)[ self::ietf:e1 or (parent::ietf:e1 and not(self::text() or self::e2)) or count(id(\"E3\")|ancestor-or-self::node()) = count(ancestor-or-self::node()) ]";
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("ietf", "http://www.ietf.org");
        XPathFactory xPathFactory = XPathFactory.newInstance();
        XPath xPath = xPathFactory.newXPath();
        DSNamespaceContext dSNamespaceContext = new DSNamespaceContext(hashMap);
        xPath.setNamespaceContext(dSNamespaceContext);
        NodeList nodeList = (NodeList)xPath.evaluate(string3, document, XPathConstants.NODESET);
        Canonicalizer canonicalizer = Canonicalizer.getInstance((String)"http://www.w3.org/TR/2001/REC-xml-c14n-20010315");
        byte[] byArray = canonicalizer.canonicalizeXPathNodeSet(nodeList);
        InputStream inputStream = testVectorResolver.resolveEntity(null, string2).getByteStream();
        byte[] byArray2 = JavaUtils.getBytesFromStream((InputStream)inputStream);
        Canonicalizer20010315Test.assertEquals((Object)new String(byArray2), (Object)new String(byArray));
    }

    @Test
    public void testRelativeNSbehaviour() throws IOException, FileNotFoundException, SAXException, ParserConfigurationException, CanonicalizationException, InvalidCanonicalizerException, TransformerException {
        String string = "<absolute:correct      xmlns:absolute='http://www.absolute.org/#likeVodka'><relative:incorrect    xmlns:relative='../cheating#away'></relative:incorrect></absolute:correct>\n";
        DocumentBuilder documentBuilder = XMLUtils.createDocumentBuilder((boolean)false);
        Document document = documentBuilder.parse(new ByteArrayInputStream(string.getBytes()));
        boolean bl = false;
        try {
            Canonicalizer canonicalizer = Canonicalizer.getInstance((String)"http://www.w3.org/TR/2001/REC-xml-c14n-20010315");
            canonicalizer.canonicalizeSubtree((Node)document);
        }
        catch (CanonicalizationException canonicalizationException) {
            log.debug((Object)("We catched the C14nEx, that's good: " + canonicalizationException.getMessage()));
            bl = true;
        }
        Canonicalizer20010315Test.assertTrue((String)"We did not catch the relative namespace", (boolean)bl);
    }

    @Test
    public void testTranslationFromUTF16toUTF8() throws IOException, FileNotFoundException, SAXException, ParserConfigurationException, CanonicalizationException, InvalidCanonicalizerException, TransformerException {
        String string = "<UTF16>The german &amp;auml (which is Unicode &amp;#xE4;):  &quot;&#xE4;&quot;</UTF16>";
        byte[] byArray = Canonicalizer20010315Test.convertToUTF16(string.getBytes());
        Canonicalizer canonicalizer = Canonicalizer.getInstance((String)"http://www.w3.org/TR/2001/REC-xml-c14n-20010315");
        byte[] byArray2 = canonicalizer.canonicalize(byArray);
        TestVectorResolver testVectorResolver = new TestVectorResolver();
        InputStream inputStream = testVectorResolver.resolveEntity(null, this.prefix + "/in/testTranslationFromUTF16toUTF8.xml").getByteStream();
        byte[] byArray3 = JavaUtils.getBytesFromStream((InputStream)inputStream);
        boolean bl = MessageDigest.isEqual(byArray3, byArray2);
        Canonicalizer20010315Test.assertTrue((String)"Parser does not translate to UCS character domain", (boolean)bl);
    }

    @Test
    public void testXMLAttributes1() throws IOException, FileNotFoundException, SAXException, ParserConfigurationException, CanonicalizationException, InvalidCanonicalizerException, TransformerException, XPathExpressionException {
        String string = "<included    xml:lang='de'><notIncluded xml:lang='de'><notIncluded xml:lang='uk'><included                 ></included></notIncluded></notIncluded></included>";
        String string2 = "<included xml:lang=\"de\"><included xml:lang=\"uk\"></included></included>";
        Canonicalizer20010315Test.assertTrue((boolean)this.doTestXMLAttributes(string, string2));
    }

    @Test
    public void testXMLAttributes2() throws IOException, FileNotFoundException, SAXException, ParserConfigurationException, CanonicalizationException, InvalidCanonicalizerException, TransformerException, XPathExpressionException {
        String string = "<included    xml:lang='uk'><notIncluded xml:lang='de'><notIncluded xml:lang='uk'><included                 ></included></notIncluded></notIncluded></included>";
        String string2 = "<included xml:lang=\"uk\"><included xml:lang=\"uk\"></included></included>";
        Canonicalizer20010315Test.assertTrue((boolean)this.doTestXMLAttributes(string, string2));
    }

    @Test
    public void testXMLAttributes3() throws IOException, FileNotFoundException, SAXException, ParserConfigurationException, CanonicalizationException, InvalidCanonicalizerException, TransformerException, XPathExpressionException {
        String string = "<included    xml:lang='de'><notIncluded xml:lang='de'><notIncluded xml:lang='uk'><included    xml:lang='de'></included></notIncluded></notIncluded></included>";
        String string2 = "<included xml:lang=\"de\"><included xml:lang=\"de\"></included></included>";
        Canonicalizer20010315Test.assertTrue((boolean)this.doTestXMLAttributes(string, string2));
    }

    @Test
    @Ignore
    public void _testXMLAttributes4() throws IOException, FileNotFoundException, SAXException, ParserConfigurationException, CanonicalizationException, InvalidCanonicalizerException, TransformerException, XPathExpressionException {
        String string = "<included    xml:lang='de'><included    xml:lang='de'><notIncluded xml:lang='uk'><included                 ></included></notIncluded></included></included>";
        String string2 = "<included xml:lang=\"de\"><included><included xml:lang=\"uk\"></included></included></included>";
        Canonicalizer20010315Test.assertTrue((boolean)this.doTestXMLAttributes(string, string2));
    }

    @Test
    @Ignore
    public void _testXMLAttributes5() throws IOException, FileNotFoundException, SAXException, ParserConfigurationException, CanonicalizationException, InvalidCanonicalizerException, TransformerException, XPathExpressionException {
        String string = "<included                         xml:lang='de'><included                         xml:lang='de'><notIncluded xml:space='preserve' xml:lang='uk'><included                 ></included></notIncluded></included></included>";
        String string2 = "<included xml:lang=\"de\"><included><included xml:lang=\"uk\" xml:space=\"preserve\"></included></included></included>";
        Canonicalizer20010315Test.assertTrue((boolean)this.doTestXMLAttributes(string, string2));
    }

    @Test
    @Ignore
    public void _testXMLAttributes6() throws IOException, FileNotFoundException, SAXException, ParserConfigurationException, CanonicalizationException, InvalidCanonicalizerException, TransformerException, XPathExpressionException {
        String string = "<included   xml:space='preserve'  xml:lang='de'><included                         xml:lang='de'><notIncluded                      xml:lang='uk'><included></included></notIncluded></included></included>";
        String string2 = "<included xml:lang=\"de\" xml:space=\"preserve\"><included><included xml:lang=\"uk\" xml:space=\"preserve\"></included></included></included>";
        Canonicalizer20010315Test.assertTrue((boolean)this.doTestXMLAttributes(string, string2));
    }

    private boolean doTestXMLAttributes(String string, String string2) throws IOException, FileNotFoundException, SAXException, ParserConfigurationException, CanonicalizationException, InvalidCanonicalizerException, TransformerException, XPathExpressionException {
        DocumentBuilder documentBuilder = XMLUtils.createDocumentBuilder((boolean)true);
        documentBuilder.setErrorHandler((ErrorHandler)new IgnoreAllErrorHandler());
        Document document = documentBuilder.parse(new ByteArrayInputStream(string.getBytes()));
        Canonicalizer canonicalizer = Canonicalizer.getInstance((String)"http://www.w3.org/TR/2001/REC-xml-c14n-20010315");
        XPathFactory xPathFactory = XPathFactory.newInstance();
        XPath xPath = xPathFactory.newXPath();
        xPath.setNamespaceContext(new DSNamespaceContext());
        String string3 = "(//*[local-name()='included'] | //@*[parent::node()[local-name()='included']])";
        NodeList nodeList = (NodeList)xPath.evaluate(string3, document, XPathConstants.NODESET);
        byte[] byArray = canonicalizer.canonicalizeXPathNodeSet(nodeList);
        byte[] byArray2 = string2.getBytes();
        Canonicalizer20010315Test.assertEquals((Object)string2, (Object)new String(byArray));
        return MessageDigest.isEqual(byArray2, byArray);
    }

    private boolean c14nAndCompare(String string, String string2, String string3, String string4, boolean bl, String string5) throws IOException, FileNotFoundException, SAXException, ParserConfigurationException, CanonicalizationException, InvalidCanonicalizerException, TransformerException, XPathExpressionException {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        return this.c14nAndCompare(string, string2, string3, string4, bl, string5, hashMap);
    }

    private boolean c14nAndCompare(String string, String string2, String string3, String string4, boolean bl, String string5, Map<String, String> map) throws IOException, FileNotFoundException, SAXException, ParserConfigurationException, CanonicalizationException, InvalidCanonicalizerException, TransformerException, XPathExpressionException {
        Object object;
        Object object2;
        Object object3;
        DocumentBuilder documentBuilder = XMLUtils.createDocumentBuilder((boolean)bl, (boolean)false);
        documentBuilder.setErrorHandler((ErrorHandler)new IgnoreAllErrorHandler());
        Document document = documentBuilder.parse(string);
        Canonicalizer canonicalizer = Canonicalizer.getInstance((String)string4);
        byte[] byArray = null;
        if (string5 == null) {
            byArray = canonicalizer.canonicalizeSubtree((Node)document);
        } else {
            object3 = null;
            XPathFactory xPathFactory = XPathFactory.newInstance();
            object2 = xPathFactory.newXPath();
            object = new DSNamespaceContext(map);
            object2.setNamespaceContext((NamespaceContext)object);
            object3 = (NodeList)object2.evaluate(string5, document, XPathConstants.NODESET);
            byArray = canonicalizer.canonicalizeXPathNodeSet((NodeList)object3);
        }
        object3 = JavaUtils.getBytesFromFile((String)string2);
        boolean bl2 = MessageDigest.isEqual(object3, byArray);
        if (!bl2) {
            object2 = new File(string3);
            if (!((File)object2).exists()) {
                object = new File(((File)object2).getParent());
                ((File)object).mkdirs();
                ((File)object2).createNewFile();
            }
            object = new FileOutputStream((File)object2);
            ((FileOutputStream)object).write(byArray);
            log.debug((Object)("Wrote erroneous result to file " + ((File)object2).toURI().toURL().toString()));
            Canonicalizer20010315Test.assertEquals((Object)new String((byte[])object3), (Object)new String(byArray));
            ((FileOutputStream)object).close();
        }
        return bl2;
    }

    public static byte[] convertToUTF16(byte[] byArray) throws ParserConfigurationException, IOException, SAXException, TransformerConfigurationException, TransformerException {
        String string = "UTF-16";
        DocumentBuilder documentBuilder = XMLUtils.createDocumentBuilder((boolean)false);
        Document document = documentBuilder.parse(new ByteArrayInputStream(byArray));
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        transformer.setOutputProperty("encoding", string);
        transformer.setOutputProperty("omit-xml-declaration", "no");
        DOMSource dOMSource = new DOMSource(document);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        StreamResult streamResult = new StreamResult(byteArrayOutputStream);
        transformer.transform(dOMSource, streamResult);
        return byteArrayOutputStream.toByteArray();
    }

    static {
        Init.init();
    }
}

