/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.test.c14n.implementations;

import java.io.ByteArrayInputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.apache.xml.security.Init;
import org.apache.xml.security.c14n.Canonicalizer;
import org.apache.xml.security.test.DSNamespaceContext;
import org.apache.xml.security.utils.IgnoreAllErrorHandler;
import org.apache.xml.security.utils.XMLUtils;
import org.junit.Assert;
import org.junit.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.ErrorHandler;

public class Santuario273Test
extends Assert {
    public static String input = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<Signature xmlns=\"http://www.w3.org/2000/09/xmldsig#\" xml:base=\"http://www.acme.com/resources/\">\n  <SignedInfo xml:base=\"subresources/\"><!-- comment inside -->\n    <CanonicalizationMethod Algorithm=\"http://www.w3.org/TR/2001/REC-xml-c14n-20010315\" />\n    <SignatureMethod Algorithm=\"http://www.w3.org/2000/09/xmldsig#rsa-sha1\" />\n    <Reference URI=\"http://www.w3.org/TR/xml-stylesheet\">\n      <DigestMethod Algorithm=\"http://www.w3.org/2000/09/xmldsig#sha1\" />\n      <DigestValue>60NvZvtdTB+7UnlLp/H24p7h4bs=</DigestValue>\n    </Reference>\n  </SignedInfo>\n  <SignatureValue>\n    fKMmy9GYF2s8rLFrZdVugTOFuWx19ccX7jh5HqFd4vMOY7LWAj52ykjSdvtW3fNY\n    PPYGC4MFL19oPSId5GEsMtFMpGXB3XaCtoKjMCHQsN3+kom8YnGf7Ge1JNRcGty5\n    0UsoP6Asj47+QR7QECT64uoziha4WRDVyXjDrg24W+U=\n  </SignatureValue>\n  <KeyInfo>\n    <KeyName>Lugh</KeyName>\n  </KeyInfo>\n</Signature>\n";
    public static final String expectedResult = "<SignedInfo xmlns=\"http://www.w3.org/2000/09/xmldsig#\" xml:base=\"http://www.acme.com/resources/subresources/\">\n    <CanonicalizationMethod Algorithm=\"http://www.w3.org/TR/2001/REC-xml-c14n-20010315\"></CanonicalizationMethod>\n    <SignatureMethod Algorithm=\"http://www.w3.org/2000/09/xmldsig#rsa-sha1\"></SignatureMethod>\n    <Reference URI=\"http://www.w3.org/TR/xml-stylesheet\">\n      <DigestMethod Algorithm=\"http://www.w3.org/2000/09/xmldsig#sha1\"></DigestMethod>\n      <DigestValue>60NvZvtdTB+7UnlLp/H24p7h4bs=</DigestValue>\n    </Reference>\n  </SignedInfo>";

    @Test
    public void testC14n11Base() throws Exception {
        DocumentBuilder documentBuilder = XMLUtils.createDocumentBuilder((boolean)true);
        documentBuilder.setErrorHandler((ErrorHandler)new IgnoreAllErrorHandler());
        byte[] byArray = input.getBytes();
        Document document = documentBuilder.parse(new ByteArrayInputStream(byArray));
        Canonicalizer canonicalizer = Canonicalizer.getInstance((String)"http://www.w3.org/2006/12/xml-c14n11");
        XPathFactory xPathFactory = XPathFactory.newInstance();
        XPath xPath = xPathFactory.newXPath();
        xPath.setNamespaceContext(new DSNamespaceContext());
        Node node = (Node)xPath.evaluate("//ds:SignedInfo[1]", document, XPathConstants.NODE);
        byte[] byArray2 = canonicalizer.canonicalizeSubtree(node);
        Santuario273Test.assertEquals((Object)new String(byArray2, "UTF-8"), (Object)expectedResult);
    }

    static {
        Init.init();
    }
}

