/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.test.dom.keys;

import java.io.FileInputStream;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.security.KeyFactory;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.spec.X509EncodedKeySpec;
import javax.xml.parsers.DocumentBuilder;
import org.apache.xml.security.keys.content.DEREncodedKeyValue;
import org.apache.xml.security.utils.Base64;
import org.apache.xml.security.utils.JavaUtils;
import org.apache.xml.security.utils.XMLUtils;
import org.junit.Assert;
import org.junit.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class DEREncodedKeyValueTest
extends Assert {
    private static final String BASEDIR = System.getProperty("basedir") == null ? "./" : System.getProperty("basedir");
    private static final String SEP = System.getProperty("file.separator");
    private DocumentBuilder documentBuilder = XMLUtils.createDocumentBuilder((boolean)false);
    private PublicKey rsaKeyControl;
    private PublicKey dsaKeyControl;
    private PublicKey ecKeyControl;
    private final String idControl = "abc123";

    public DEREncodedKeyValueTest() throws Exception {
        if (Security.getProvider("BC") == null) {
            Serializable serializable;
            Constructor<?> constructor = null;
            try {
                serializable = Class.forName("org.bouncycastle.jce.provider.BouncyCastleProvider");
                constructor = serializable.getConstructor(new Class[0]);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (constructor != null) {
                serializable = (Provider)constructor.newInstance(new Object[0]);
                Security.insertProviderAt(serializable, 1);
                this.ecKeyControl = this.loadPublicKey("ec.key", "EC");
            }
        }
        this.rsaKeyControl = this.loadPublicKey("rsa.key", "RSA");
        this.dsaKeyControl = this.loadPublicKey("dsa.key", "DSA");
    }

    @Test
    public void testSchema() throws Exception {
        DEREncodedKeyValue dEREncodedKeyValue = new DEREncodedKeyValue(this.documentBuilder.newDocument(), this.rsaKeyControl);
        Element element = dEREncodedKeyValue.getElement();
        DEREncodedKeyValueTest.assertEquals((Object)"http://www.w3.org/2009/xmldsig11#", (Object)element.getNamespaceURI());
        DEREncodedKeyValueTest.assertEquals((Object)"DEREncodedKeyValue", (Object)element.getLocalName());
    }

    @Test
    public void testRSAPublicKeyFromElement() throws Exception {
        Document document = this.loadXML("DEREncodedKeyValue-RSA.xml");
        NodeList nodeList = document.getElementsByTagNameNS("http://www.w3.org/2009/xmldsig11#", "DEREncodedKeyValue");
        Element element = (Element)nodeList.item(0);
        DEREncodedKeyValue dEREncodedKeyValue = new DEREncodedKeyValue(element, "");
        DEREncodedKeyValueTest.assertEquals((Object)this.rsaKeyControl, (Object)dEREncodedKeyValue.getPublicKey());
        DEREncodedKeyValueTest.assertArrayEquals((byte[])this.rsaKeyControl.getEncoded(), (byte[])dEREncodedKeyValue.getBytesFromTextChild());
        DEREncodedKeyValueTest.assertEquals((Object)"abc123", (Object)dEREncodedKeyValue.getId());
    }

    @Test
    public void testDSAPublicKeyFromElement() throws Exception {
        Document document = this.loadXML("DEREncodedKeyValue-DSA.xml");
        NodeList nodeList = document.getElementsByTagNameNS("http://www.w3.org/2009/xmldsig11#", "DEREncodedKeyValue");
        Element element = (Element)nodeList.item(0);
        DEREncodedKeyValue dEREncodedKeyValue = new DEREncodedKeyValue(element, "");
        DEREncodedKeyValueTest.assertEquals((Object)this.dsaKeyControl, (Object)dEREncodedKeyValue.getPublicKey());
        DEREncodedKeyValueTest.assertArrayEquals((byte[])this.dsaKeyControl.getEncoded(), (byte[])dEREncodedKeyValue.getBytesFromTextChild());
        DEREncodedKeyValueTest.assertEquals((Object)"abc123", (Object)dEREncodedKeyValue.getId());
    }

    @Test
    public void testECPublicKeyFromElement() throws Exception {
        if (this.ecKeyControl == null) {
            return;
        }
        Document document = this.loadXML("DEREncodedKeyValue-EC.xml");
        NodeList nodeList = document.getElementsByTagNameNS("http://www.w3.org/2009/xmldsig11#", "DEREncodedKeyValue");
        Element element = (Element)nodeList.item(0);
        DEREncodedKeyValue dEREncodedKeyValue = new DEREncodedKeyValue(element, "");
        DEREncodedKeyValueTest.assertEquals((Object)this.ecKeyControl, (Object)dEREncodedKeyValue.getPublicKey());
        DEREncodedKeyValueTest.assertArrayEquals((byte[])this.ecKeyControl.getEncoded(), (byte[])dEREncodedKeyValue.getBytesFromTextChild());
        DEREncodedKeyValueTest.assertEquals((Object)"abc123", (Object)dEREncodedKeyValue.getId());
    }

    @Test
    public void testRSAPublicKeyFromKey() throws Exception {
        DEREncodedKeyValue dEREncodedKeyValue = new DEREncodedKeyValue(this.documentBuilder.newDocument(), this.rsaKeyControl);
        DEREncodedKeyValueTest.assertEquals((Object)this.rsaKeyControl, (Object)dEREncodedKeyValue.getPublicKey());
        DEREncodedKeyValueTest.assertArrayEquals((byte[])this.rsaKeyControl.getEncoded(), (byte[])dEREncodedKeyValue.getBytesFromTextChild());
    }

    @Test
    public void testDSAPublicKeyFromKey() throws Exception {
        DEREncodedKeyValue dEREncodedKeyValue = new DEREncodedKeyValue(this.documentBuilder.newDocument(), this.dsaKeyControl);
        DEREncodedKeyValueTest.assertEquals((Object)this.dsaKeyControl, (Object)dEREncodedKeyValue.getPublicKey());
        DEREncodedKeyValueTest.assertArrayEquals((byte[])this.dsaKeyControl.getEncoded(), (byte[])dEREncodedKeyValue.getBytesFromTextChild());
    }

    @Test
    public void testECPublicKeyFromKey() throws Exception {
        if (this.ecKeyControl == null) {
            return;
        }
        DEREncodedKeyValue dEREncodedKeyValue = new DEREncodedKeyValue(this.documentBuilder.newDocument(), this.ecKeyControl);
        DEREncodedKeyValueTest.assertEquals((Object)this.ecKeyControl, (Object)dEREncodedKeyValue.getPublicKey());
        DEREncodedKeyValueTest.assertArrayEquals((byte[])this.ecKeyControl.getEncoded(), (byte[])dEREncodedKeyValue.getBytesFromTextChild());
    }

    @Test
    public void testId() throws Exception {
        DEREncodedKeyValue dEREncodedKeyValue = new DEREncodedKeyValue(this.documentBuilder.newDocument(), this.rsaKeyControl);
        DEREncodedKeyValueTest.assertEquals((Object)"", (Object)dEREncodedKeyValue.getId());
        DEREncodedKeyValueTest.assertNull((Object)dEREncodedKeyValue.getElement().getAttributeNodeNS(null, "Id"));
        dEREncodedKeyValue.setId("abc123");
        DEREncodedKeyValueTest.assertEquals((Object)"abc123", (Object)dEREncodedKeyValue.getId());
        DEREncodedKeyValueTest.assertTrue((boolean)dEREncodedKeyValue.getElement().getAttributeNodeNS(null, "Id").isId());
        dEREncodedKeyValue.setId(null);
        DEREncodedKeyValueTest.assertEquals((Object)"", (Object)dEREncodedKeyValue.getId());
        DEREncodedKeyValueTest.assertNull((Object)dEREncodedKeyValue.getElement().getAttributeNodeNS(null, "Id"));
    }

    private String getControlFilePath(String string) {
        return BASEDIR + SEP + "src" + SEP + "test" + SEP + "resources" + SEP + "org" + SEP + "apache" + SEP + "xml" + SEP + "security" + SEP + "keys" + SEP + "content" + SEP + string;
    }

    private Document loadXML(String string) throws Exception {
        return this.documentBuilder.parse(new FileInputStream(this.getControlFilePath(string)));
    }

    private PublicKey loadPublicKey(String string, String string2) throws Exception {
        String string3 = new String(JavaUtils.getBytesFromFile((String)this.getControlFilePath(string)));
        byte[] byArray = Base64.decode((String)string3);
        KeyFactory keyFactory = KeyFactory.getInstance(string2);
        X509EncodedKeySpec x509EncodedKeySpec = new X509EncodedKeySpec(byArray);
        return keyFactory.generatePublic(x509EncodedKeySpec);
    }
}

