/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.test.dom.keys;

import java.io.FileInputStream;
import javax.xml.parsers.DocumentBuilder;
import org.apache.xml.security.keys.content.KeyInfoReference;
import org.apache.xml.security.utils.XMLUtils;
import org.junit.Assert;
import org.junit.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class KeyInfoReferenceTest
extends Assert {
    private static final String BASEDIR = System.getProperty("basedir") == null ? "./" : System.getProperty("basedir");
    private static final String SEP = System.getProperty("file.separator");
    private DocumentBuilder documentBuilder = XMLUtils.createDocumentBuilder((boolean)false);
    private final String idControl = "abc123";
    private final String uriControl = "http://www.example.org/keyinfo.xml";

    @Test
    public void testSchema() throws Exception {
        KeyInfoReference keyInfoReference = new KeyInfoReference(this.documentBuilder.newDocument(), "http://www.example.org/keyinfo.xml");
        Element element = keyInfoReference.getElement();
        KeyInfoReferenceTest.assertEquals((Object)"http://www.w3.org/2009/xmldsig11#", (Object)element.getNamespaceURI());
        KeyInfoReferenceTest.assertEquals((Object)"KeyInfoReference", (Object)element.getLocalName());
    }

    @Test
    public void testURIFromElement() throws Exception {
        Document document = this.loadXML("KeyInfoReference.xml");
        NodeList nodeList = document.getElementsByTagNameNS("http://www.w3.org/2009/xmldsig11#", "KeyInfoReference");
        Element element = (Element)nodeList.item(0);
        KeyInfoReference keyInfoReference = new KeyInfoReference(element, "");
        KeyInfoReferenceTest.assertEquals((Object)"http://www.example.org/keyinfo.xml", (Object)keyInfoReference.getURI());
        KeyInfoReferenceTest.assertEquals((Object)"abc123", (Object)keyInfoReference.getId());
    }

    @Test
    public void testURIOnConstruction() throws Exception {
        KeyInfoReference keyInfoReference = new KeyInfoReference(this.documentBuilder.newDocument(), "http://www.example.org/keyinfo.xml");
        KeyInfoReferenceTest.assertEquals((Object)"http://www.example.org/keyinfo.xml", (Object)keyInfoReference.getURI());
    }

    @Test
    public void testId() throws Exception {
        KeyInfoReference keyInfoReference = new KeyInfoReference(this.documentBuilder.newDocument(), "http://www.example.org/keyinfo.xml");
        KeyInfoReferenceTest.assertEquals((Object)"", (Object)keyInfoReference.getId());
        KeyInfoReferenceTest.assertNull((Object)keyInfoReference.getElement().getAttributeNodeNS(null, "Id"));
        keyInfoReference.setId("abc123");
        KeyInfoReferenceTest.assertEquals((Object)"abc123", (Object)keyInfoReference.getId());
        KeyInfoReferenceTest.assertTrue((boolean)keyInfoReference.getElement().getAttributeNodeNS(null, "Id").isId());
        keyInfoReference.setId(null);
        KeyInfoReferenceTest.assertEquals((Object)"", (Object)keyInfoReference.getId());
        KeyInfoReferenceTest.assertNull((Object)keyInfoReference.getElement().getAttributeNodeNS(null, "Id"));
    }

    private String getControlFilePath(String string) {
        return BASEDIR + SEP + "src" + SEP + "test" + SEP + "resources" + SEP + "org" + SEP + "apache" + SEP + "xml" + SEP + "security" + SEP + "keys" + SEP + "content" + SEP + string;
    }

    private Document loadXML(String string) throws Exception {
        return this.documentBuilder.parse(new FileInputStream(this.getControlFilePath(string)));
    }
}

