/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.test.dom.keys.content.x509;

import java.io.FileInputStream;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import javax.xml.parsers.DocumentBuilder;
import org.apache.xml.security.Init;
import org.apache.xml.security.keys.content.x509.XMLX509Digest;
import org.apache.xml.security.utils.Base64;
import org.apache.xml.security.utils.XMLUtils;
import org.junit.Assert;
import org.junit.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class XMLX509DigestTest
extends Assert {
    private static final String BASEDIR = System.getProperty("basedir") == null ? "./" : System.getProperty("basedir");
    private static final String SEP = System.getProperty("file.separator");
    private DocumentBuilder documentBuilder = XMLUtils.createDocumentBuilder((boolean)false);
    private X509Certificate certControl = this.loadCertificate("cert-X509Digest.crt");
    private final String algorithmURIControl = "http://www.w3.org/2001/04/xmlenc#sha256";
    private final String digestBase64Control = "jToLQ/K7aaLHy/aXLFnjEfCwSQd9z0MrBOH6Ru/aJyY=";
    private final byte[] digestControl = Base64.decode((String)"jToLQ/K7aaLHy/aXLFnjEfCwSQd9z0MrBOH6Ru/aJyY=");

    public XMLX509DigestTest() throws Exception {
        if (!Init.isInitialized()) {
            Init.init();
        }
    }

    @Test
    public void testSchema() throws Exception {
        XMLX509Digest xMLX509Digest = new XMLX509Digest(this.documentBuilder.newDocument(), this.digestControl, "http://www.w3.org/2001/04/xmlenc#sha256");
        Element element = xMLX509Digest.getElement();
        XMLX509DigestTest.assertEquals((Object)"http://www.w3.org/2009/xmldsig11#", (Object)element.getNamespaceURI());
        XMLX509DigestTest.assertEquals((Object)"X509Digest", (Object)element.getLocalName());
    }

    @Test
    public void testDigestFromElement() throws Exception {
        Document document = this.loadXML("X509Digest.xml");
        NodeList nodeList = document.getElementsByTagNameNS("http://www.w3.org/2009/xmldsig11#", "X509Digest");
        Element element = (Element)nodeList.item(0);
        XMLX509Digest xMLX509Digest = new XMLX509Digest(element, "");
        XMLX509DigestTest.assertEquals((Object)"http://www.w3.org/2001/04/xmlenc#sha256", (Object)xMLX509Digest.getAlgorithm());
        XMLX509DigestTest.assertArrayEquals((byte[])this.digestControl, (byte[])xMLX509Digest.getDigestBytes());
    }

    @Test
    public void testDigestOnConstructionWithCert() throws Exception {
        XMLX509Digest xMLX509Digest = new XMLX509Digest(this.documentBuilder.newDocument(), this.certControl, "http://www.w3.org/2001/04/xmlenc#sha256");
        XMLX509DigestTest.assertEquals((Object)"http://www.w3.org/2001/04/xmlenc#sha256", (Object)xMLX509Digest.getAlgorithm());
        XMLX509DigestTest.assertArrayEquals((byte[])this.digestControl, (byte[])xMLX509Digest.getDigestBytes());
    }

    @Test
    public void testDigestOnConstructionWithBytes() throws Exception {
        XMLX509Digest xMLX509Digest = new XMLX509Digest(this.documentBuilder.newDocument(), this.digestControl, "http://www.w3.org/2001/04/xmlenc#sha256");
        XMLX509DigestTest.assertEquals((Object)"http://www.w3.org/2001/04/xmlenc#sha256", (Object)xMLX509Digest.getAlgorithm());
        XMLX509DigestTest.assertArrayEquals((byte[])this.digestControl, (byte[])xMLX509Digest.getDigestBytes());
    }

    @Test
    public void testGetDigestBytesFromCert() throws Exception {
        XMLX509DigestTest.assertArrayEquals((byte[])this.digestControl, (byte[])XMLX509Digest.getDigestBytesFromCert((X509Certificate)this.certControl, (String)"http://www.w3.org/2001/04/xmlenc#sha256"));
    }

    private String getControlFilePath(String string) {
        return BASEDIR + SEP + "src" + SEP + "test" + SEP + "resources" + SEP + "org" + SEP + "apache" + SEP + "xml" + SEP + "security" + SEP + "keys" + SEP + "content" + SEP + "x509" + SEP + string;
    }

    private Document loadXML(String string) throws Exception {
        return this.documentBuilder.parse(new FileInputStream(this.getControlFilePath(string)));
    }

    private X509Certificate loadCertificate(String string) throws Exception {
        FileInputStream fileInputStream = new FileInputStream(this.getControlFilePath(string));
        CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
        return (X509Certificate)certificateFactory.generateCertificate(fileInputStream);
    }
}

