/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.test.dom.keys.keyresolver;

import java.io.FileInputStream;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.security.KeyFactory;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.spec.X509EncodedKeySpec;
import javax.xml.parsers.DocumentBuilder;
import org.apache.xml.security.Init;
import org.apache.xml.security.keys.KeyInfo;
import org.apache.xml.security.utils.Base64;
import org.apache.xml.security.utils.JavaUtils;
import org.apache.xml.security.utils.XMLUtils;
import org.junit.Assert;
import org.junit.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class DEREncodedKeyValueResolverTest
extends Assert {
    private static final String BASEDIR = System.getProperty("basedir") == null ? "./" : System.getProperty("basedir");
    private static final String SEP = System.getProperty("file.separator");
    private DocumentBuilder documentBuilder = XMLUtils.createDocumentBuilder((boolean)false);
    private PublicKey rsaKeyControl;
    private PublicKey dsaKeyControl;
    private PublicKey ecKeyControl;

    public DEREncodedKeyValueResolverTest() throws Exception {
        if (Security.getProvider("BC") == null) {
            Serializable serializable;
            Constructor<?> constructor = null;
            try {
                serializable = Class.forName("org.bouncycastle.jce.provider.BouncyCastleProvider");
                constructor = serializable.getConstructor(new Class[0]);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (constructor != null) {
                serializable = (Provider)constructor.newInstance(new Object[0]);
                Security.insertProviderAt(serializable, 1);
                this.ecKeyControl = this.loadPublicKey("ec.key", "EC");
            }
        }
        this.rsaKeyControl = this.loadPublicKey("rsa.key", "RSA");
        this.dsaKeyControl = this.loadPublicKey("dsa.key", "DSA");
        if (!Init.isInitialized()) {
            Init.init();
        }
    }

    @Test
    public void testRSAPublicKey() throws Exception {
        Document document = this.loadXML("DEREncodedKeyValue-RSA.xml");
        Element element = document.getDocumentElement();
        KeyInfo keyInfo = new KeyInfo(element, "");
        DEREncodedKeyValueResolverTest.assertEquals((Object)this.rsaKeyControl, (Object)keyInfo.getPublicKey());
    }

    @Test
    public void testDSAPublicKey() throws Exception {
        Document document = this.loadXML("DEREncodedKeyValue-DSA.xml");
        Element element = document.getDocumentElement();
        KeyInfo keyInfo = new KeyInfo(element, "");
        DEREncodedKeyValueResolverTest.assertEquals((Object)this.dsaKeyControl, (Object)keyInfo.getPublicKey());
    }

    @Test
    public void testECPublicKey() throws Exception {
        if (this.ecKeyControl == null) {
            return;
        }
        Document document = this.loadXML("DEREncodedKeyValue-EC.xml");
        Element element = document.getDocumentElement();
        KeyInfo keyInfo = new KeyInfo(element, "");
        DEREncodedKeyValueResolverTest.assertEquals((Object)this.ecKeyControl, (Object)keyInfo.getPublicKey());
    }

    private String getControlFilePath(String string) {
        return BASEDIR + SEP + "src" + SEP + "test" + SEP + "resources" + SEP + "org" + SEP + "apache" + SEP + "xml" + SEP + "security" + SEP + "keys" + SEP + "content" + SEP + string;
    }

    private Document loadXML(String string) throws Exception {
        return this.documentBuilder.parse(new FileInputStream(this.getControlFilePath(string)));
    }

    private PublicKey loadPublicKey(String string, String string2) throws Exception {
        String string3 = new String(JavaUtils.getBytesFromFile((String)this.getControlFilePath(string)));
        byte[] byArray = Base64.decode((String)string3);
        KeyFactory keyFactory = KeyFactory.getInstance(string2);
        X509EncodedKeySpec x509EncodedKeySpec = new X509EncodedKeySpec(byArray);
        return keyFactory.generatePublic(x509EncodedKeySpec);
    }
}

