/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.test.dom.keys.keyresolver;

import java.io.FileInputStream;
import java.security.KeyFactory;
import java.security.PublicKey;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.X509EncodedKeySpec;
import javax.xml.parsers.DocumentBuilder;
import org.apache.xml.security.Init;
import org.apache.xml.security.keys.KeyInfo;
import org.apache.xml.security.utils.Base64;
import org.apache.xml.security.utils.JavaUtils;
import org.apache.xml.security.utils.XMLUtils;
import org.junit.Assert;
import org.junit.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class KeyInfoReferenceResolverTest
extends Assert {
    private static final String BASEDIR = System.getProperty("basedir") == null ? "./" : System.getProperty("basedir");
    private static final String SEP = System.getProperty("file.separator");
    private DocumentBuilder documentBuilder = XMLUtils.createDocumentBuilder((boolean)false);

    public KeyInfoReferenceResolverTest() throws Exception {
        if (!Init.isInitialized()) {
            Init.init();
        }
    }

    @Test
    public void testRSAPublicKey() throws Exception {
        PublicKey publicKey = this.loadPublicKey("rsa-KeyInfoReference.key", "RSA");
        Document document = this.loadXML("KeyInfoReference-RSA.xml");
        this.markKeyInfoIdAttrs(document);
        Element element = document.getElementById("theReference");
        KeyInfoReferenceResolverTest.assertNotNull((Object)element);
        KeyInfo keyInfo = new KeyInfo(element, "");
        KeyInfoReferenceResolverTest.assertEquals((Object)publicKey, (Object)keyInfo.getPublicKey());
    }

    @Test
    public void testX509Certificate() throws Exception {
        X509Certificate x509Certificate = this.loadCertificate("cert-KeyInfoReference.crt");
        Document document = this.loadXML("KeyInfoReference-X509Certificate.xml");
        this.markKeyInfoIdAttrs(document);
        Element element = document.getElementById("theReference");
        KeyInfoReferenceResolverTest.assertNotNull((Object)element);
        KeyInfo keyInfo = new KeyInfo(element, "");
        KeyInfoReferenceResolverTest.assertEquals((Object)x509Certificate, (Object)keyInfo.getX509Certificate());
        KeyInfoReferenceResolverTest.assertEquals((Object)x509Certificate.getPublicKey(), (Object)keyInfo.getPublicKey());
    }

    @Test
    public void testWrongReferentType() throws Exception {
        Element element;
        Document document = this.loadXML("KeyInfoReference-WrongReferentType.xml");
        this.markKeyInfoIdAttrs(document);
        NodeList nodeList = document.getElementsByTagNameNS("http://www.example.org/test", "KeyInfo");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            element = (Element)nodeList.item(i);
            element.setIdAttributeNS(null, "Id", true);
        }
        Element element2 = document.getElementById("theReference");
        KeyInfoReferenceResolverTest.assertNotNull((Object)element2);
        element = new KeyInfo(element2, "");
        KeyInfoReferenceResolverTest.assertNull((Object)element.getPublicKey());
    }

    @Test
    public void testSameDocumentReferenceChain() throws Exception {
        Document document = this.loadXML("KeyInfoReference-ReferenceChain.xml");
        this.markKeyInfoIdAttrs(document);
        Element element = document.getElementById("theReference");
        KeyInfoReferenceResolverTest.assertNotNull((Object)element);
        KeyInfo keyInfo = new KeyInfo(element, "");
        KeyInfoReferenceResolverTest.assertNull((Object)keyInfo.getPublicKey());
    }

    @Test
    public void testSameDocumentReferenceChainWithSecureValidation() throws Exception {
        Document document = this.loadXML("KeyInfoReference-ReferenceChain.xml");
        this.markKeyInfoIdAttrs(document);
        Element element = document.getElementById("theReference");
        KeyInfoReferenceResolverTest.assertNotNull((Object)element);
        KeyInfo keyInfo = new KeyInfo(element, "");
        keyInfo.setSecureValidation(true);
        KeyInfoReferenceResolverTest.assertNull((Object)keyInfo.getPublicKey());
    }

    private String getControlFilePath(String string) {
        return BASEDIR + SEP + "src" + SEP + "test" + SEP + "resources" + SEP + "org" + SEP + "apache" + SEP + "xml" + SEP + "security" + SEP + "keyresolver" + SEP + string;
    }

    private Document loadXML(String string) throws Exception {
        return this.documentBuilder.parse(new FileInputStream(this.getControlFilePath(string)));
    }

    private PublicKey loadPublicKey(String string, String string2) throws Exception {
        String string3 = new String(JavaUtils.getBytesFromFile((String)this.getControlFilePath(string)));
        byte[] byArray = Base64.decode((String)string3);
        KeyFactory keyFactory = KeyFactory.getInstance(string2);
        X509EncodedKeySpec x509EncodedKeySpec = new X509EncodedKeySpec(byArray);
        return keyFactory.generatePublic(x509EncodedKeySpec);
    }

    private X509Certificate loadCertificate(String string) throws Exception {
        FileInputStream fileInputStream = new FileInputStream(this.getControlFilePath(string));
        CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
        return (X509Certificate)certificateFactory.generateCertificate(fileInputStream);
    }

    private void markKeyInfoIdAttrs(Document document) {
        NodeList nodeList = document.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "KeyInfo");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element element = (Element)nodeList.item(i);
            element.setIdAttributeNS(null, "Id", true);
        }
    }
}

