/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.test.dom.keys.keyresolver;

import java.io.FileInputStream;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import javax.xml.parsers.DocumentBuilder;
import org.apache.xml.security.Init;
import org.apache.xml.security.keys.KeyInfo;
import org.apache.xml.security.keys.storage.StorageResolver;
import org.apache.xml.security.keys.storage.StorageResolverSpi;
import org.apache.xml.security.keys.storage.implementations.SingleCertificateResolver;
import org.apache.xml.security.utils.XMLUtils;
import org.junit.Assert;
import org.junit.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class X509DigestResolverTest
extends Assert {
    private static final String BASEDIR = System.getProperty("basedir") == null ? "./" : System.getProperty("basedir");
    private static final String SEP = System.getProperty("file.separator");
    private DocumentBuilder documentBuilder = XMLUtils.createDocumentBuilder((boolean)false);
    private X509Certificate certControl = this.loadCertificate("cert-X509Digest.crt");
    private StorageResolver storageResolver = new StorageResolver((StorageResolverSpi)new SingleCertificateResolver(this.certControl));

    public X509DigestResolverTest() throws Exception {
        if (!Init.isInitialized()) {
            Init.init();
        }
    }

    @Test
    public void testDigest() throws Exception {
        Document document = this.loadXML("X509Digest.xml");
        Element element = document.getDocumentElement();
        KeyInfo keyInfo = new KeyInfo(element, "");
        X509DigestResolverTest.assertNull((Object)keyInfo.getX509Certificate());
        X509DigestResolverTest.assertNull((Object)keyInfo.getPublicKey());
        keyInfo.addStorageResolver(this.storageResolver);
        X509DigestResolverTest.assertEquals((Object)this.certControl, (Object)keyInfo.getX509Certificate());
        X509DigestResolverTest.assertEquals((Object)this.certControl.getPublicKey(), (Object)keyInfo.getPublicKey());
    }

    private String getControlFilePath(String string) {
        return BASEDIR + SEP + "src" + SEP + "test" + SEP + "resources" + SEP + "org" + SEP + "apache" + SEP + "xml" + SEP + "security" + SEP + "keys" + SEP + "content" + SEP + "x509" + SEP + string;
    }

    private Document loadXML(String string) throws Exception {
        return this.documentBuilder.parse(new FileInputStream(this.getControlFilePath(string)));
    }

    private X509Certificate loadCertificate(String string) throws Exception {
        FileInputStream fileInputStream = new FileInputStream(this.getControlFilePath(string));
        CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
        return (X509Certificate)certificateFactory.generateCertificate(fileInputStream);
    }
}

