/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.test.encryption;

import java.security.PublicKey;
import java.security.cert.X509Certificate;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESedeKeySpec;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xml.security.keys.content.KeyName;
import org.apache.xml.security.keys.keyresolver.KeyResolverException;
import org.apache.xml.security.keys.keyresolver.KeyResolverSpi;
import org.apache.xml.security.keys.storage.StorageResolver;
import org.apache.xml.security.utils.XMLUtils;
import org.w3c.dom.Element;

public class BobKeyResolver
extends KeyResolverSpi {
    private static Log log = LogFactory.getLog((String)BobKeyResolver.class.getName());
    private KeyName _kn = null;

    public boolean engineCanResolve(Element element, String string, StorageResolver storageResolver) {
        if (element == null) {
            return false;
        }
        log.debug((Object)("Can I resolve " + element.getTagName()));
        boolean bl = XMLUtils.elementIsInSignatureSpace((Element)element, (String)"KeyName");
        try {
            if (bl) {
                this._kn = new KeyName(element, "");
                if (this._kn.getKeyName().equals("bob")) {
                    return true;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public PublicKey engineLookupAndResolvePublicKey(Element element, String string, StorageResolver storageResolver) throws KeyResolverException {
        return null;
    }

    public X509Certificate engineLookupResolveX509Certificate(Element element, String string, StorageResolver storageResolver) throws KeyResolverException {
        return null;
    }

    public SecretKey engineLookupAndResolveSecretKey(Element element, String string, StorageResolver storageResolver) throws KeyResolverException {
        if (this.engineCanResolve(element, string, storageResolver)) {
            try {
                DESedeKeySpec dESedeKeySpec = new DESedeKeySpec("abcdefghijklmnopqrstuvwx".getBytes("ASCII"));
                SecretKeyFactory secretKeyFactory = SecretKeyFactory.getInstance("DESede");
                SecretKey secretKey = secretKeyFactory.generateSecret(dESedeKeySpec);
                return secretKey;
            }
            catch (Exception exception) {
                throw new KeyResolverException("Something badly wrong in creation of bob's key");
            }
        }
        return null;
    }
}

