/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.test.encryption;

import java.util.Iterator;
import javax.xml.parsers.DocumentBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xml.security.Init;
import org.apache.xml.security.encryption.Reference;
import org.apache.xml.security.encryption.ReferenceList;
import org.apache.xml.security.encryption.XMLCipher;
import org.apache.xml.security.utils.XMLUtils;
import org.junit.Assert;
import org.junit.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ReferenceListTest
extends Assert {
    static Log log = LogFactory.getLog((String)ReferenceListTest.class.getName());
    private DocumentBuilder db;

    public ReferenceListTest() throws Exception {
        Init.init();
        this.db = XMLUtils.createDocumentBuilder((boolean)false);
    }

    @Test
    public void testReferenceList() throws Exception {
        Document document = this.db.newDocument();
        XMLCipher xMLCipher = XMLCipher.getInstance();
        xMLCipher.init(2, null);
        ReferenceList referenceList = xMLCipher.createReferenceList(1);
        Reference reference = referenceList.newDataReference("#id1");
        referenceList.add(reference);
        Reference reference2 = referenceList.newDataReference("#id2");
        referenceList.add(reference2);
        ReferenceListTest.assertEquals((Object)"#id1", (Object)reference.getURI());
        ReferenceList referenceList2 = xMLCipher.createReferenceList(2);
        Reference reference3 = referenceList2.newKeyReference("#id10");
        referenceList2.add(reference3);
        Reference reference4 = referenceList2.newKeyReference("#id20");
        referenceList2.add(reference4);
        ReferenceListTest.assertEquals((Object)"#id10", (Object)reference3.getURI());
        Element element = xMLCipher.martial(document, referenceList);
        ReferenceListTest.assertEquals((Object)"http://www.w3.org/2001/04/xmlenc#", (Object)element.getNamespaceURI());
        ReferenceListTest.assertEquals((Object)"ReferenceList", (Object)element.getLocalName());
        Element element2 = (Element)element.getFirstChild();
        ReferenceListTest.assertEquals((Object)"http://www.w3.org/2001/04/xmlenc#", (Object)element2.getNamespaceURI());
        ReferenceListTest.assertEquals((Object)"DataReference", (Object)element2.getLocalName());
        ReferenceListTest.assertEquals((Object)"#id1", (Object)element2.getAttribute("URI"));
        Element element3 = (Element)element2.getNextSibling();
        ReferenceListTest.assertEquals((Object)"http://www.w3.org/2001/04/xmlenc#", (Object)element3.getNamespaceURI());
        ReferenceListTest.assertEquals((Object)"DataReference", (Object)element3.getLocalName());
        ReferenceListTest.assertEquals((Object)"#id2", (Object)element3.getAttribute("URI"));
        ReferenceListTest.assertNull((Object)element3.getNextSibling());
        Element element4 = xMLCipher.martial(document, referenceList2);
        ReferenceListTest.assertEquals((Object)"http://www.w3.org/2001/04/xmlenc#", (Object)element4.getNamespaceURI());
        ReferenceListTest.assertEquals((Object)"ReferenceList", (Object)element4.getLocalName());
        Element element5 = (Element)element4.getFirstChild();
        ReferenceListTest.assertEquals((Object)"http://www.w3.org/2001/04/xmlenc#", (Object)element5.getNamespaceURI());
        ReferenceListTest.assertEquals((Object)"KeyReference", (Object)element5.getLocalName());
        ReferenceListTest.assertEquals((Object)"#id10", (Object)element5.getAttribute("URI"));
        Element element6 = (Element)element5.getNextSibling();
        ReferenceListTest.assertEquals((Object)"http://www.w3.org/2001/04/xmlenc#", (Object)element6.getNamespaceURI());
        ReferenceListTest.assertEquals((Object)"KeyReference", (Object)element6.getLocalName());
        ReferenceListTest.assertEquals((Object)"#id20", (Object)element6.getAttribute("URI"));
        ReferenceListTest.assertNull((Object)element6.getNextSibling());
        Iterator iterator = referenceList.getReferences();
        Reference reference5 = (Reference)iterator.next();
        ReferenceListTest.assertEquals((Object)"DataReference", (Object)reference5.getType());
        ReferenceListTest.assertEquals((Object)"#id1", (Object)reference5.getURI());
        reference5 = (Reference)iterator.next();
        ReferenceListTest.assertEquals((Object)"DataReference", (Object)reference5.getType());
        ReferenceListTest.assertEquals((Object)"#id2", (Object)reference5.getURI());
        ReferenceListTest.assertTrue((!iterator.hasNext() ? 1 : 0) != 0);
        iterator = referenceList2.getReferences();
        reference5 = (Reference)iterator.next();
        ReferenceListTest.assertEquals((Object)"KeyReference", (Object)reference5.getType());
        ReferenceListTest.assertEquals((Object)"#id10", (Object)reference5.getURI());
        reference5 = (Reference)iterator.next();
        ReferenceListTest.assertEquals((Object)"KeyReference", (Object)reference5.getType());
        ReferenceListTest.assertEquals((Object)"#id20", (Object)reference5.getURI());
        ReferenceListTest.assertTrue((!iterator.hasNext() ? 1 : 0) != 0);
    }
}

