/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.test.encryption;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESedeKeySpec;
import javax.crypto.spec.SecretKeySpec;
import javax.xml.parsers.DocumentBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xml.security.Init;
import org.apache.xml.security.algorithms.JCEMapper;
import org.apache.xml.security.c14n.Canonicalizer;
import org.apache.xml.security.encryption.EncryptedData;
import org.apache.xml.security.encryption.EncryptedKey;
import org.apache.xml.security.encryption.EncryptionMethod;
import org.apache.xml.security.encryption.Transforms;
import org.apache.xml.security.encryption.XMLCipher;
import org.apache.xml.security.keys.KeyInfo;
import org.apache.xml.security.transforms.params.XPathContainer;
import org.apache.xml.security.utils.XMLUtils;
import org.junit.Assert;
import org.junit.Test;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XMLCipherTest
extends Assert {
    private static Log log = LogFactory.getLog((String)XMLCipherTest.class.getName());
    private String documentName;
    private String elementName;
    private String elementIndex;
    private XMLCipher cipher;
    private String basedir = System.getProperty("basedir", ".");
    private boolean haveISOPadding = false;
    private boolean haveKeyWraps;
    private String tstBase64EncodedString;

    public XMLCipherTest() {
        this.documentName = System.getProperty("org.apache.xml.enc.test.doc", this.basedir + "/build.xml");
        this.elementName = System.getProperty("org.apache.xml.enc.test.elem", "path");
        this.elementIndex = System.getProperty("org.apache.xml.enc.test.idx", "0");
        this.tstBase64EncodedString = new String("YmNkZWZnaGlqa2xtbm9wcRrPXjQ1hvhDFT+EdesMAPE4F6vlT+y0HPXe0+nAGLQ8");
        String string = JCEMapper.translateURItoJCEID((String)"http://www.w3.org/2001/04/xmlenc#aes128-cbc");
        if (string != null) {
            try {
                if (Cipher.getInstance(string) != null) {
                    this.haveISOPadding = true;
                }
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            }
            catch (NoSuchPaddingException noSuchPaddingException) {
                // empty catch block
            }
        }
        this.haveKeyWraps = JCEMapper.translateURItoJCEID((String)"http://www.w3.org/2001/04/xmlenc#kw-aes128") != null;
    }

    @Test
    public void testAES128ElementAES192KWCipherUsingKEK() throws Exception {
        Document document = this.document();
        Document document2 = null;
        Document document3 = null;
        Element element = (Element)document.getElementsByTagName(this.element()).item(this.index());
        Element element2 = null;
        String string = null;
        String string2 = null;
        if (this.haveISOPadding && this.haveKeyWraps) {
            string = this.toString(document);
            byte[] byArray = "abcdefghijklmnopqrstuvwx".getBytes();
            SecretKeySpec secretKeySpec = new SecretKeySpec(byArray, "AES");
            KeyGenerator keyGenerator = KeyGenerator.getInstance("AES");
            keyGenerator.init(128);
            SecretKey secretKey = keyGenerator.generateKey();
            this.cipher = XMLCipher.getInstance((String)"http://www.w3.org/2001/04/xmlenc#kw-aes192");
            this.cipher.init(3, (Key)secretKeySpec);
            EncryptedKey encryptedKey = this.cipher.encryptKey(document, (Key)secretKey);
            this.cipher = XMLCipher.getInstance((String)"http://www.w3.org/2001/04/xmlenc#aes128-cbc");
            this.cipher.init(1, (Key)secretKey);
            EncryptedData encryptedData = this.cipher.getEncryptedData();
            KeyInfo keyInfo = encryptedData.getKeyInfo();
            if (keyInfo == null) {
                keyInfo = new KeyInfo(document);
                encryptedData.setKeyInfo(keyInfo);
            }
            keyInfo.add(encryptedKey);
            document2 = this.cipher.doFinal(document, element);
            secretKey = null;
            element2 = (Element)document2.getElementsByTagName("xenc:EncryptedData").item(0);
            this.cipher = XMLCipher.getInstance((String)"http://www.w3.org/2001/04/xmlenc#aes128-cbc");
            this.cipher.init(2, null);
            this.cipher.setKEK((Key)secretKeySpec);
            document3 = this.cipher.doFinal(document2, element2);
            string2 = this.toString(document3);
            XMLCipherTest.assertEquals((Object)string, (Object)string2);
        } else {
            log.warn((Object)"Test testAES128ElementAES192KWCipherUsingKEK skipped as necessary algorithms not available");
        }
    }

    @Test
    public void testAES128ElementRSAKWCipherUsingKEK() throws Exception {
        Document document = this.document();
        Document document2 = null;
        Document document3 = null;
        Element element = (Element)document.getElementsByTagName(this.element()).item(this.index());
        Element element2 = null;
        String string = null;
        String string2 = null;
        if (this.haveISOPadding) {
            string = this.toString(document);
            KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("RSA");
            KeyPair keyPair = keyPairGenerator.generateKeyPair();
            PrivateKey privateKey = keyPair.getPrivate();
            PublicKey publicKey = keyPair.getPublic();
            KeyGenerator keyGenerator = KeyGenerator.getInstance("AES");
            keyGenerator.init(256);
            SecretKey secretKey = keyGenerator.generateKey();
            this.cipher = XMLCipher.getInstance((String)"http://www.w3.org/2001/04/xmlenc#rsa-1_5");
            this.cipher.init(3, (Key)publicKey);
            EncryptedKey encryptedKey = this.cipher.encryptKey(document, (Key)secretKey);
            this.cipher = XMLCipher.getInstance((String)"http://www.w3.org/2001/04/xmlenc#aes256-cbc");
            this.cipher.init(1, (Key)secretKey);
            EncryptedData encryptedData = this.cipher.getEncryptedData();
            KeyInfo keyInfo = encryptedData.getKeyInfo();
            if (keyInfo == null) {
                keyInfo = new KeyInfo(document);
                encryptedData.setKeyInfo(keyInfo);
            }
            keyInfo.add(encryptedKey);
            document2 = this.cipher.doFinal(document, element);
            log.debug((Object)"Encrypted document");
            log.debug((Object)this.toString(document2));
            secretKey = null;
            element2 = (Element)document2.getElementsByTagName("xenc:EncryptedData").item(0);
            this.cipher = XMLCipher.getInstance((String)"http://www.w3.org/2001/04/xmlenc#aes128-cbc");
            this.cipher.init(2, null);
            this.cipher.setKEK((Key)privateKey);
            document3 = this.cipher.doFinal(document2, element2);
            string2 = this.toString(document3);
            XMLCipherTest.assertEquals((Object)string, (Object)string2);
        } else {
            log.warn((Object)"Test testAES128ElementRSAKWCipherUsingKEK skipped as necessary algorithms not available");
        }
    }

    @Test
    public void testAES192ElementAES256KWCipher() throws Exception {
        Document document = this.document();
        Document document2 = null;
        Document document3 = null;
        Element element = (Element)document.getElementsByTagName(this.element()).item(this.index());
        Element element2 = null;
        String string = null;
        String string2 = null;
        if (this.haveISOPadding && this.haveKeyWraps) {
            XMLCipher xMLCipher;
            string = this.toString(document);
            byte[] byArray = "abcdefghijklmnopqrstuvwx".getBytes();
            DESedeKeySpec dESedeKeySpec = new DESedeKeySpec(byArray);
            SecretKeyFactory secretKeyFactory = SecretKeyFactory.getInstance("DESede");
            SecretKey secretKey = secretKeyFactory.generateSecret(dESedeKeySpec);
            KeyGenerator keyGenerator = KeyGenerator.getInstance("AES");
            keyGenerator.init(192);
            Key key = keyGenerator.generateKey();
            this.cipher = XMLCipher.getInstance((String)"http://www.w3.org/2001/04/xmlenc#kw-tripledes");
            this.cipher.init(3, (Key)secretKey);
            EncryptedKey encryptedKey = this.cipher.encryptKey(document, key);
            this.cipher = XMLCipher.getInstance((String)"http://www.w3.org/2001/04/xmlenc#aes192-cbc");
            this.cipher.init(1, key);
            EncryptedData encryptedData = this.cipher.getEncryptedData();
            KeyInfo keyInfo = encryptedData.getKeyInfo();
            if (keyInfo == null) {
                keyInfo = new KeyInfo(document);
                encryptedData.setKeyInfo(keyInfo);
            }
            keyInfo.add(encryptedKey);
            document2 = this.cipher.doFinal(document, element);
            key = null;
            element2 = (Element)document2.getElementsByTagName("xenc:EncryptedData").item(0);
            this.cipher = XMLCipher.getInstance();
            this.cipher.init(2, null);
            EncryptedData encryptedData2 = this.cipher.loadEncryptedData(document2, element2);
            if (encryptedData2 == null) {
                System.out.println("ed is null");
            } else if (encryptedData2.getKeyInfo() == null) {
                System.out.println("ki is null");
            }
            EncryptedKey encryptedKey2 = encryptedData2.getKeyInfo().itemEncryptedKey(0);
            if (encryptedKey2 != null) {
                xMLCipher = XMLCipher.getInstance();
                xMLCipher.init(4, (Key)secretKey);
                key = xMLCipher.decryptKey(encryptedKey2, encryptedData2.getEncryptionMethod().getAlgorithm());
            }
            xMLCipher = XMLCipher.getInstance();
            xMLCipher.init(2, key);
            document3 = xMLCipher.doFinal(document2, element2);
            string2 = this.toString(document3);
            XMLCipherTest.assertEquals((Object)string, (Object)string2);
        } else {
            log.warn((Object)"Test testAES192ElementAES256KWCipher skipped as necessary algorithms not available");
        }
    }

    @Test
    public void testTripleDesElementCipher() throws Exception {
        Document document = this.document();
        Document document2 = null;
        Document document3 = null;
        Element element = (Element)document.getElementsByTagName(this.element()).item(this.index());
        Element element2 = null;
        String string = null;
        String string2 = null;
        if (this.haveISOPadding) {
            string = this.toString(document);
            byte[] byArray = "24 Bytes per DESede key!".getBytes();
            DESedeKeySpec dESedeKeySpec = new DESedeKeySpec(byArray);
            SecretKeyFactory secretKeyFactory = SecretKeyFactory.getInstance("DESede");
            SecretKey secretKey = secretKeyFactory.generateSecret(dESedeKeySpec);
            this.cipher = XMLCipher.getInstance((String)"http://www.w3.org/2001/04/xmlenc#tripledes-cbc");
            this.cipher.init(1, (Key)secretKey);
            document2 = this.cipher.doFinal(document, element);
            this.cipher = XMLCipher.getInstance((String)"http://www.w3.org/2001/04/xmlenc#tripledes-cbc");
            this.cipher.init(2, (Key)secretKey);
            element2 = (Element)document2.getElementsByTagName("xenc:EncryptedData").item(0);
            EncryptedData encryptedData = this.cipher.loadEncryptedData(document2, element2);
            String string3 = encryptedData.getEncryptionMethod().getAlgorithm();
            XMLCipherTest.assertEquals((Object)"http://www.w3.org/2001/04/xmlenc#tripledes-cbc", (Object)string3);
            document3 = this.cipher.doFinal(document2, element2);
            string2 = this.toString(document3);
            XMLCipherTest.assertEquals((Object)string, (Object)string2);
        } else {
            log.warn((Object)"Test testTripleDesElementCipher skipped as necessary algorithms not available");
        }
    }

    @Test
    public void testAes128ElementCipher() throws Exception {
        byte[] byArray = new byte[]{16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31};
        SecretKeySpec secretKeySpec = new SecretKeySpec(byArray, "AES");
        Document document = this.document();
        Document document2 = null;
        Document document3 = null;
        Element element = (Element)document.getElementsByTagName(this.element()).item(this.index());
        Element element2 = null;
        String string = null;
        String string2 = null;
        if (this.haveISOPadding) {
            string = this.toString(document);
            this.cipher = XMLCipher.getInstance((String)"http://www.w3.org/2001/04/xmlenc#aes128-cbc");
            this.cipher.init(1, (Key)secretKeySpec);
            document2 = this.cipher.doFinal(document, element);
            this.cipher = XMLCipher.getInstance((String)"http://www.w3.org/2001/04/xmlenc#aes128-cbc");
            this.cipher.init(2, (Key)secretKeySpec);
            element2 = (Element)document2.getElementsByTagName("xenc:EncryptedData").item(0);
            EncryptedData encryptedData = this.cipher.loadEncryptedData(document2, element2);
            String string3 = encryptedData.getEncryptionMethod().getAlgorithm();
            XMLCipherTest.assertEquals((Object)"http://www.w3.org/2001/04/xmlenc#aes128-cbc", (Object)string3);
            document3 = this.cipher.doFinal(document2, element2);
            string2 = this.toString(document3);
            XMLCipherTest.assertEquals((Object)string, (Object)string2);
        } else {
            log.warn((Object)"Test testAes128ElementCipher skipped as necessary algorithms not available");
        }
    }

    @Test
    public void testAes192ElementCipher() throws Exception {
        byte[] byArray = new byte[]{8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31};
        SecretKeySpec secretKeySpec = new SecretKeySpec(byArray, "AES");
        Document document = this.document();
        Document document2 = null;
        Document document3 = null;
        Element element = (Element)document.getElementsByTagName(this.element()).item(this.index());
        Element element2 = null;
        String string = null;
        String string2 = null;
        if (this.haveISOPadding) {
            string = this.toString(document);
            this.cipher = XMLCipher.getInstance((String)"http://www.w3.org/2001/04/xmlenc#aes192-cbc");
            this.cipher.init(1, (Key)secretKeySpec);
            document2 = this.cipher.doFinal(document, element);
            this.cipher = XMLCipher.getInstance((String)"http://www.w3.org/2001/04/xmlenc#aes192-cbc");
            this.cipher.init(2, (Key)secretKeySpec);
            element2 = (Element)document2.getElementsByTagName("xenc:EncryptedData").item(0);
            EncryptedData encryptedData = this.cipher.loadEncryptedData(document2, element2);
            String string3 = encryptedData.getEncryptionMethod().getAlgorithm();
            XMLCipherTest.assertEquals((Object)"http://www.w3.org/2001/04/xmlenc#aes192-cbc", (Object)string3);
            document3 = this.cipher.doFinal(document2, element2);
            string2 = this.toString(document3);
            XMLCipherTest.assertEquals((Object)string, (Object)string2);
        } else {
            log.warn((Object)"Test testAes192ElementCipher skipped as necessary algorithms not available");
        }
    }

    @Test
    public void testAes265ElementCipher() throws Exception {
        byte[] byArray = new byte[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31};
        SecretKeySpec secretKeySpec = new SecretKeySpec(byArray, "AES");
        Document document = this.document();
        Document document2 = null;
        Document document3 = null;
        Element element = (Element)document.getElementsByTagName(this.element()).item(this.index());
        Element element2 = null;
        String string = null;
        String string2 = null;
        if (this.haveISOPadding) {
            string = this.toString(document);
            this.cipher = XMLCipher.getInstance((String)"http://www.w3.org/2001/04/xmlenc#aes256-cbc");
            this.cipher.init(1, (Key)secretKeySpec);
            document2 = this.cipher.doFinal(document, element);
            this.cipher = XMLCipher.getInstance((String)"http://www.w3.org/2001/04/xmlenc#aes256-cbc");
            this.cipher.init(2, (Key)secretKeySpec);
            element2 = (Element)document2.getElementsByTagName("xenc:EncryptedData").item(0);
            EncryptedData encryptedData = this.cipher.loadEncryptedData(document2, element2);
            String string3 = encryptedData.getEncryptionMethod().getAlgorithm();
            XMLCipherTest.assertEquals((Object)"http://www.w3.org/2001/04/xmlenc#aes256-cbc", (Object)string3);
            document3 = this.cipher.doFinal(document2, element2);
            string2 = this.toString(document3);
            XMLCipherTest.assertEquals((Object)string, (Object)string2);
        } else {
            log.warn((Object)"Test testAes265ElementCipher skipped as necessary algorithms not available");
        }
    }

    @Test
    public void testTripleDesDocumentCipher() throws Exception {
        Document document = this.document();
        Document document2 = null;
        Document document3 = null;
        Element element = document.getDocumentElement();
        Element element2 = null;
        String string = null;
        String string2 = null;
        if (this.haveISOPadding) {
            string = this.toString(document);
            byte[] byArray = "24 Bytes per DESede key!".getBytes();
            DESedeKeySpec dESedeKeySpec = new DESedeKeySpec(byArray);
            SecretKeyFactory secretKeyFactory = SecretKeyFactory.getInstance("DESede");
            SecretKey secretKey = secretKeyFactory.generateSecret(dESedeKeySpec);
            this.cipher = XMLCipher.getInstance((String)"http://www.w3.org/2001/04/xmlenc#tripledes-cbc");
            this.cipher.init(1, (Key)secretKey);
            document2 = this.cipher.doFinal(document, element);
            this.cipher = XMLCipher.getInstance((String)"http://www.w3.org/2001/04/xmlenc#tripledes-cbc");
            this.cipher.init(2, (Key)secretKey);
            element2 = (Element)document2.getElementsByTagName("xenc:EncryptedData").item(0);
            document3 = this.cipher.doFinal(document2, element2);
            string2 = this.toString(document3);
            XMLCipherTest.assertEquals((Object)string, (Object)string2);
        } else {
            log.warn((Object)"Test testTripleDesDocumentCipher skipped as necessary algorithms not available");
        }
    }

    @Test
    public void testSameDocumentCipherReference() throws Exception {
        if (this.haveISOPadding) {
            DocumentBuilder documentBuilder = XMLUtils.createDocumentBuilder((boolean)false);
            Document document = documentBuilder.newDocument();
            Element element = document.createElement("EncryptedDoc");
            document.appendChild(element);
            this.cipher = XMLCipher.getInstance();
            EncryptedData encryptedData = this.cipher.createEncryptedData(2, "#CipherTextId");
            EncryptionMethod encryptionMethod = this.cipher.createEncryptionMethod("http://www.w3.org/2001/04/xmlenc#aes128-cbc");
            encryptedData.setEncryptionMethod(encryptionMethod);
            Transforms transforms = this.cipher.createTransforms(document);
            encryptedData.getCipherData().getCipherReference().setTransforms(transforms);
            org.apache.xml.security.transforms.Transforms transforms2 = transforms.getDSTransforms();
            XPathContainer xPathContainer = new XPathContainer(document);
            xPathContainer.setXPath("self::text()[parent::CipherText[@Id=\"CipherTextId\"]]");
            transforms2.addTransform("http://www.w3.org/TR/1999/REC-xpath-19991116", xPathContainer.getElementPlusReturns());
            transforms2.addTransform("http://www.w3.org/2000/09/xmldsig#base64");
            Element element2 = this.cipher.martial(document, encryptedData);
            element.appendChild(element2);
            Element element3 = document.createElement("CipherText");
            element3.setAttributeNS(null, "Id", "CipherTextId");
            element3.setIdAttributeNS(null, "Id", true);
            element3.appendChild(document.createTextNode(this.tstBase64EncodedString));
            element.appendChild(element3);
            XMLCipher xMLCipher = XMLCipher.getInstance();
            SecretKeySpec secretKeySpec = new SecretKeySpec("abcdefghijklmnop".getBytes("ASCII"), "AES");
            xMLCipher.init(2, (Key)secretKeySpec);
            byte[] byArray = xMLCipher.decryptToByteArray(element2);
            XMLCipherTest.assertEquals((Object)"A test encrypted secret", (Object)new String(byArray, "ASCII"));
        } else {
            log.warn((Object)"Test testSameDocumentCipherReference skipped as necessary algorithms not available");
        }
    }

    @Test
    public void testPhysicalRepresentation() throws Exception {
        if (this.haveISOPadding) {
            DocumentBuilder documentBuilder = XMLUtils.createDocumentBuilder((boolean)false);
            byte[] byArray = "abcdefghijklmnopqrstuvwx".getBytes();
            DESedeKeySpec dESedeKeySpec = new DESedeKeySpec(byArray);
            SecretKeyFactory secretKeyFactory = SecretKeyFactory.getInstance("DESede");
            SecretKey secretKey = secretKeyFactory.generateSecret(dESedeKeySpec);
            Document document = documentBuilder.parse(new ByteArrayInputStream("<ns:root xmlns:ns=\"ns.com\"><ns:elem xmlns:ns2=\"ns2.com\">11</ns:elem></ns:root>".getBytes("UTF8")));
            Element element = (Element)document.getDocumentElement().getFirstChild();
            XMLCipher xMLCipher = XMLCipher.getInstance((String)"http://www.w3.org/2001/04/xmlenc#tripledes-cbc");
            xMLCipher.init(1, (Key)secretKey);
            xMLCipher.doFinal(document, element);
            Element element2 = (Element)document.getDocumentElement().getFirstChild();
            XMLCipherTest.assertEquals((Object)"EncryptedData", (Object)element2.getLocalName());
            XMLCipher xMLCipher2 = XMLCipher.getInstance((String)"http://www.w3.org/2001/04/xmlenc#tripledes-cbc");
            xMLCipher2.init(2, (Key)secretKey);
            xMLCipher2.doFinal(document, element2);
            Element element3 = (Element)document.getDocumentElement().getFirstChild();
            XMLCipherTest.assertEquals((Object)"ns:elem", (Object)element3.getNodeName());
            XMLCipherTest.assertEquals((Object)"ns.com", (Object)element3.getNamespaceURI());
            XMLCipherTest.assertEquals((long)1L, (long)element3.getAttributes().getLength());
            Attr attr = (Attr)element3.getAttributes().item(0);
            XMLCipherTest.assertEquals((Object)"xmlns:ns2", (Object)attr.getName());
            XMLCipherTest.assertEquals((Object)"ns2.com", (Object)attr.getValue());
            document = documentBuilder.parse(new ByteArrayInputStream("<ns:root xmlns=\"defns.com\" xmlns:ns=\"ns.com\"><elem xmlns=\"\">11</elem></ns:root>".getBytes("UTF8")));
            element = (Element)document.getDocumentElement().getFirstChild();
            xMLCipher = XMLCipher.getInstance((String)"http://www.w3.org/2001/04/xmlenc#tripledes-cbc");
            xMLCipher.init(1, (Key)secretKey);
            xMLCipher.doFinal(document, element);
            element2 = (Element)document.getDocumentElement().getFirstChild();
            XMLCipherTest.assertEquals((Object)"EncryptedData", (Object)element2.getLocalName());
            xMLCipher2 = XMLCipher.getInstance((String)"http://www.w3.org/2001/04/xmlenc#tripledes-cbc");
            xMLCipher2.init(2, (Key)secretKey);
            xMLCipher2.doFinal(document, element2);
            element3 = (Element)document.getDocumentElement().getFirstChild();
            XMLCipherTest.assertEquals((Object)"elem", (Object)element3.getNodeName());
            XMLCipherTest.assertNull((Object)element3.getNamespaceURI());
            XMLCipherTest.assertEquals((long)1L, (long)element3.getAttributes().getLength());
            attr = (Attr)element3.getAttributes().item(0);
            XMLCipherTest.assertEquals((Object)"xmlns", (Object)attr.getName());
            XMLCipherTest.assertEquals((Object)"", (Object)attr.getValue());
            document = documentBuilder.parse(new ByteArrayInputStream("<root><!--comment1--><?pi1 target1?><elem/><!--comment2--><?pi2 target2?></root>".getBytes("UTF8")));
            element = document.getDocumentElement();
            xMLCipher = XMLCipher.getInstance((String)"http://www.w3.org/2001/04/xmlenc#tripledes-cbc");
            xMLCipher.init(1, (Key)secretKey);
            xMLCipher.doFinal(document, element, true);
            element2 = (Element)element.getFirstChild();
            XMLCipherTest.assertEquals((Object)"EncryptedData", (Object)element2.getLocalName());
            XMLCipherTest.assertNull((Object)element2.getNextSibling());
            xMLCipher2 = XMLCipher.getInstance((String)"http://www.w3.org/2001/04/xmlenc#tripledes-cbc");
            xMLCipher2.init(2, (Key)secretKey);
            xMLCipher2.doFinal(document, element2);
            Node node = element.getFirstChild();
            XMLCipherTest.assertEquals((long)8L, (long)node.getNodeType());
            node = node.getNextSibling();
            XMLCipherTest.assertEquals((long)7L, (long)node.getNodeType());
            node = node.getNextSibling();
            XMLCipherTest.assertEquals((long)1L, (long)node.getNodeType());
            node = node.getNextSibling();
            XMLCipherTest.assertEquals((long)8L, (long)node.getNodeType());
            node = node.getNextSibling();
            XMLCipherTest.assertEquals((long)7L, (long)node.getNodeType());
            node = node.getNextSibling();
            XMLCipherTest.assertNull((Object)node);
        } else {
            log.warn((Object)"Test testPhysicalRepresentation skipped as necessary algorithms not available");
        }
    }

    @Test
    public void testSerializedData() throws Exception {
        if (!this.haveISOPadding) {
            log.warn((Object)"Test testSerializedData skipped as necessary algorithms not available");
            return;
        }
        byte[] byArray = new byte[]{16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31};
        SecretKeySpec secretKeySpec = new SecretKeySpec(byArray, "AES");
        Document document = this.document();
        Element element = (Element)document.getElementsByTagName(this.element()).item(this.index());
        this.cipher = XMLCipher.getInstance((String)"http://www.w3.org/2001/04/xmlenc#aes128-cbc");
        this.cipher.init(1, (Key)secretKeySpec);
        Canonicalizer canonicalizer = Canonicalizer.getInstance((String)"http://www.w3.org/TR/2001/REC-xml-c14n-20010315#WithComments");
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        canonicalizer.setWriter((OutputStream)byteArrayOutputStream);
        canonicalizer.notReset();
        canonicalizer.canonicalizeSubtree((Node)element);
        byteArrayOutputStream.close();
        String string = byteArrayOutputStream.toString("UTF-8");
        byte[] byArray2 = byteArrayOutputStream.toByteArray();
        EncryptedData encryptedData = this.cipher.encryptData(document, "http://www.w3.org/2001/04/xmlenc#Element", (InputStream)new ByteArrayInputStream(byArray2));
        XMLCipher xMLCipher = XMLCipher.getInstance((String)"http://www.w3.org/2001/04/xmlenc#aes128-cbc");
        xMLCipher.init(2, (Key)secretKeySpec);
        String string2 = encryptedData.getEncryptionMethod().getAlgorithm();
        XMLCipherTest.assertEquals((Object)"http://www.w3.org/2001/04/xmlenc#aes128-cbc", (Object)string2);
        byte[] byArray3 = xMLCipher.decryptToByteArray(xMLCipher.martial(encryptedData));
        String string3 = new String(byArray3, "UTF-8");
        XMLCipherTest.assertEquals((Object)string, (Object)string3);
        encryptedData = this.cipher.encryptData(document, null, (InputStream)new ByteArrayInputStream(byArray2));
    }

    @Test
    public void testEncryptedKeyWithRecipient() throws Exception {
        String string = "src/test/resources/org/apache/xml/security/encryption/encryptedKey.xml";
        if (this.basedir != null && !"".equals(this.basedir)) {
            string = this.basedir + "/" + string;
        }
        File file = new File(string);
        DocumentBuilder documentBuilder = XMLUtils.createDocumentBuilder((boolean)false);
        Document document = documentBuilder.parse(file);
        XMLCipher xMLCipher = XMLCipher.getInstance();
        xMLCipher.init(4, null);
        NodeList nodeList = document.getElementsByTagNameNS("http://www.w3.org/2001/04/xmlenc#", "EncryptedKey");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            EncryptedKey encryptedKey = xMLCipher.loadEncryptedKey(document, (Element)nodeList.item(i));
            XMLCipherTest.assertNotNull((Object)encryptedKey.getRecipient());
        }
    }

    private String toString(Node node) throws Exception {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        Canonicalizer canonicalizer = Canonicalizer.getInstance((String)"http://www.w3.org/TR/2001/REC-xml-c14n-20010315");
        byte[] byArray = canonicalizer.canonicalizeSubtree(node);
        byteArrayOutputStream.write(byArray);
        byteArrayOutputStream.close();
        return byteArrayOutputStream.toString("UTF-8");
    }

    private Document document() {
        Document document = null;
        try {
            DocumentBuilder documentBuilder = XMLUtils.createDocumentBuilder((boolean)false);
            File file = new File(this.documentName);
            document = documentBuilder.parse(file);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(-1);
        }
        return document;
    }

    private String element() {
        return this.elementName;
    }

    private int index() {
        int n = -1;
        try {
            n = Integer.parseInt(this.elementIndex);
        }
        catch (NumberFormatException numberFormatException) {
            numberFormatException.printStackTrace();
            System.exit(-1);
        }
        return n;
    }

    static {
        Init.init();
    }
}

