/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.test.encryption;

import java.io.File;
import java.io.FileInputStream;
import java.lang.reflect.Constructor;
import java.security.Key;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.NoSuchPaddingException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.transform.TransformerException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xml.security.Init;
import org.apache.xml.security.algorithms.JCEMapper;
import org.apache.xml.security.encryption.EncryptedData;
import org.apache.xml.security.encryption.EncryptedKey;
import org.apache.xml.security.encryption.XMLCipher;
import org.apache.xml.security.keys.KeyInfo;
import org.apache.xml.security.keys.content.X509Data;
import org.apache.xml.security.keys.content.x509.XMLX509Certificate;
import org.apache.xml.security.test.DSNamespaceContext;
import org.apache.xml.security.utils.Base64;
import org.apache.xml.security.utils.XMLUtils;
import org.junit.Assert;
import org.junit.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class XMLEncryption11Test
extends Assert {
    private static String cardNumber;
    private static int nodeCount;
    private boolean haveISOPadding;
    static Log log;

    public XMLEncryption11Test() throws Exception {
        Object object;
        Object object2;
        if (Security.getProvider("BC") == null) {
            object2 = null;
            try {
                object = Class.forName("org.bouncycastle.jce.provider.BouncyCastleProvider");
                object2 = ((Class)object).getConstructor(new Class[0]);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (object2 == null) {
                return;
            }
            object = (Provider)((Constructor)object2).newInstance(new Object[0]);
            Security.insertProviderAt((Provider)object, 2);
        }
        object2 = "src/test/resources/org/w3c/www/interop/xmlenc-core-11/plaintext.xml";
        object = System.getProperty("basedir");
        if (object != null && !"".equals(object)) {
            object2 = (String)object + "/" + (String)object2;
        }
        File file = new File((String)object2);
        DocumentBuilder documentBuilder = XMLUtils.createDocumentBuilder((boolean)false);
        Document document = documentBuilder.parse(new FileInputStream(file));
        cardNumber = XMLEncryption11Test.retrieveCCNumber(document);
        nodeCount = XMLEncryption11Test.countNodes(document);
        Init.init();
        this.haveISOPadding = false;
        String string = JCEMapper.translateURItoJCEID((String)"http://www.w3.org/2001/04/xmlenc#aes128-cbc");
        if (string != null) {
            try {
                if (Cipher.getInstance(string) != null) {
                    this.haveISOPadding = true;
                }
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            }
            catch (NoSuchPaddingException noSuchPaddingException) {
                // empty catch block
            }
        }
    }

    @Test
    public void testKeyWrappingRSA2048() throws Exception {
        if (this.haveISOPadding) {
            String string = "src/test/resources/org/w3c/www/interop/xmlenc-core-11/RSA-2048_SHA256WithRSA.jks";
            String string2 = System.getProperty("basedir");
            if (string2 != null && !"".equals(string2)) {
                string = string2 + "/" + string;
            }
            KeyStore keyStore = KeyStore.getInstance("jks");
            keyStore.load(new FileInputStream(string), "passwd".toCharArray());
            Certificate certificate = keyStore.getCertificate("importkey");
            KeyStore.PrivateKeyEntry privateKeyEntry = (KeyStore.PrivateKeyEntry)keyStore.getEntry("importkey", new KeyStore.PasswordProtection("passwd".toCharArray()));
            PrivateKey privateKey = privateKeyEntry.getPrivateKey();
            String string3 = "src/test/resources/org/w3c/www/interop/xmlenc-core-11/cipherText__RSA-2048__aes128-gcm__rsa-oaep-mgf1p.xml";
            Document document = this.decryptElement(string3, (Key)privateKey, (X509Certificate)certificate);
            this.checkDecryptedDoc(document, true);
        } else {
            log.warn((Object)"Skipping testRSA2048 as necessary crypto algorithms are not available");
        }
    }

    @Test
    public void testKeyWrappingRSA2048EncryptDecrypt() throws Exception {
        if (this.haveISOPadding) {
            String string = "src/test/resources/org/w3c/www/interop/xmlenc-core-11/RSA-2048_SHA256WithRSA.jks";
            String string2 = System.getProperty("basedir");
            if (string2 != null && !"".equals(string2)) {
                string = string2 + "/" + string;
            }
            KeyStore keyStore = KeyStore.getInstance("jks");
            keyStore.load(new FileInputStream(string), "passwd".toCharArray());
            Certificate certificate = keyStore.getCertificate("importkey");
            KeyStore.PrivateKeyEntry privateKeyEntry = (KeyStore.PrivateKeyEntry)keyStore.getEntry("importkey", new KeyStore.PasswordProtection("passwd".toCharArray()));
            PrivateKey privateKey = privateKeyEntry.getPrivateKey();
            String string3 = "src/test/resources/org/w3c/www/interop/xmlenc-core-11/plaintext.xml";
            if (string2 != null && !"".equals(string2)) {
                string3 = string2 + "/" + string3;
            }
            File file = new File(string3);
            DocumentBuilder documentBuilder = XMLUtils.createDocumentBuilder((boolean)false);
            Document document = documentBuilder.parse(new FileInputStream(file));
            Key key = this.getSessionKey("http://www.w3.org/2009/xmlenc11#aes128-gcm");
            EncryptedKey encryptedKey = this.createEncryptedKey(document, (X509Certificate)certificate, key, "http://www.w3.org/2001/04/xmlenc#rsa-oaep-mgf1p", "http://www.w3.org/2000/09/xmldsig#sha1", null, null);
            document = this.encryptDocument(document, encryptedKey, key, "http://www.w3.org/2009/xmlenc11#aes128-gcm");
            Document document2 = this.decryptElement(document, (Key)privateKey, (X509Certificate)certificate);
            this.checkDecryptedDoc(document2, true);
        } else {
            log.warn((Object)"Skipping testRSA2048 as necessary crypto algorithms are not available");
        }
    }

    @Test
    public void testKeyWrappingRSA3072() throws Exception {
        if (this.haveISOPadding) {
            String string = "src/test/resources/org/w3c/www/interop/xmlenc-core-11/RSA-3072_SHA256WithRSA.jks";
            String string2 = System.getProperty("basedir");
            if (string2 != null && !"".equals(string2)) {
                string = string2 + "/" + string;
            }
            KeyStore keyStore = KeyStore.getInstance("jks");
            keyStore.load(new FileInputStream(string), "passwd".toCharArray());
            Certificate certificate = keyStore.getCertificate("importkey");
            KeyStore.PrivateKeyEntry privateKeyEntry = (KeyStore.PrivateKeyEntry)keyStore.getEntry("importkey", new KeyStore.PasswordProtection("passwd".toCharArray()));
            PrivateKey privateKey = privateKeyEntry.getPrivateKey();
            String string3 = "src/test/resources/org/w3c/www/interop/xmlenc-core-11/cipherText__RSA-3072__aes192-gcm__rsa-oaep-mgf1p__Sha256.xml";
            Document document = this.decryptElement(string3, (Key)privateKey, (X509Certificate)certificate);
            this.checkDecryptedDoc(document, true);
        } else {
            log.warn((Object)"Skipping testRSA3072 as necessary crypto algorithms are not available");
        }
    }

    @Test
    public void testKeyWrappingRSA3072EncryptDecrypt() throws Exception {
        if (this.haveISOPadding) {
            String string = "src/test/resources/org/w3c/www/interop/xmlenc-core-11/RSA-3072_SHA256WithRSA.jks";
            String string2 = System.getProperty("basedir");
            if (string2 != null && !"".equals(string2)) {
                string = string2 + "/" + string;
            }
            KeyStore keyStore = KeyStore.getInstance("jks");
            keyStore.load(new FileInputStream(string), "passwd".toCharArray());
            Certificate certificate = keyStore.getCertificate("importkey");
            KeyStore.PrivateKeyEntry privateKeyEntry = (KeyStore.PrivateKeyEntry)keyStore.getEntry("importkey", new KeyStore.PasswordProtection("passwd".toCharArray()));
            PrivateKey privateKey = privateKeyEntry.getPrivateKey();
            String string3 = "src/test/resources/org/w3c/www/interop/xmlenc-core-11/plaintext.xml";
            if (string2 != null && !"".equals(string2)) {
                string3 = string2 + "/" + string3;
            }
            File file = new File(string3);
            DocumentBuilder documentBuilder = XMLUtils.createDocumentBuilder((boolean)false);
            Document document = documentBuilder.parse(new FileInputStream(file));
            Key key = this.getSessionKey("http://www.w3.org/2009/xmlenc11#aes192-gcm");
            EncryptedKey encryptedKey = this.createEncryptedKey(document, (X509Certificate)certificate, key, "http://www.w3.org/2001/04/xmlenc#rsa-oaep-mgf1p", "http://www.w3.org/2001/04/xmlenc#sha256", null, null);
            document = this.encryptDocument(document, encryptedKey, key, "http://www.w3.org/2009/xmlenc11#aes192-gcm");
            Document document2 = this.decryptElement(document, (Key)privateKey, (X509Certificate)certificate);
            this.checkDecryptedDoc(document2, true);
        } else {
            log.warn((Object)"Skipping testRSA3072 as necessary crypto algorithms are not available");
        }
    }

    @Test
    public void testKeyWrappingRSA3072OAEP() throws Exception {
        if (this.haveISOPadding) {
            String string = "src/test/resources/org/w3c/www/interop/xmlenc-core-11/RSA-3072_SHA256WithRSA.jks";
            String string2 = System.getProperty("basedir");
            if (string2 != null && !"".equals(string2)) {
                string = string2 + "/" + string;
            }
            KeyStore keyStore = KeyStore.getInstance("jks");
            keyStore.load(new FileInputStream(string), "passwd".toCharArray());
            Certificate certificate = keyStore.getCertificate("importkey");
            KeyStore.PrivateKeyEntry privateKeyEntry = (KeyStore.PrivateKeyEntry)keyStore.getEntry("importkey", new KeyStore.PasswordProtection("passwd".toCharArray()));
            PrivateKey privateKey = privateKeyEntry.getPrivateKey();
            String string3 = "src/test/resources/org/w3c/www/interop/xmlenc-core-11/cipherText__RSA-3072__aes256-gcm__rsa-oaep__Sha384-MGF_Sha1.xml";
            Document document = this.decryptElement(string3, (Key)privateKey, (X509Certificate)certificate);
            this.checkDecryptedDoc(document, true);
        } else {
            log.warn((Object)"Skipping testRSA307OAEP as necessary crypto algorithms are not available");
        }
    }

    @Test
    public void testKeyWrappingRSA3072OAEPEncryptDecrypt() throws Exception {
        if (this.haveISOPadding) {
            String string = "src/test/resources/org/w3c/www/interop/xmlenc-core-11/RSA-3072_SHA256WithRSA.jks";
            String string2 = System.getProperty("basedir");
            if (string2 != null && !"".equals(string2)) {
                string = string2 + "/" + string;
            }
            KeyStore keyStore = KeyStore.getInstance("jks");
            keyStore.load(new FileInputStream(string), "passwd".toCharArray());
            Certificate certificate = keyStore.getCertificate("importkey");
            KeyStore.PrivateKeyEntry privateKeyEntry = (KeyStore.PrivateKeyEntry)keyStore.getEntry("importkey", new KeyStore.PasswordProtection("passwd".toCharArray()));
            PrivateKey privateKey = privateKeyEntry.getPrivateKey();
            String string3 = "src/test/resources/org/w3c/www/interop/xmlenc-core-11/plaintext.xml";
            if (string2 != null && !"".equals(string2)) {
                string3 = string2 + "/" + string3;
            }
            File file = new File(string3);
            DocumentBuilder documentBuilder = XMLUtils.createDocumentBuilder((boolean)false);
            Document document = documentBuilder.parse(new FileInputStream(file));
            Key key = this.getSessionKey("http://www.w3.org/2009/xmlenc11#aes256-gcm");
            EncryptedKey encryptedKey = this.createEncryptedKey(document, (X509Certificate)certificate, key, "http://www.w3.org/2009/xmlenc11#rsa-oaep", "http://www.w3.org/2001/04/xmldsig-more#sha384", "http://www.w3.org/2009/xmlenc11#mgf1sha1", null);
            document = this.encryptDocument(document, encryptedKey, key, "http://www.w3.org/2009/xmlenc11#aes256-gcm");
            Document document2 = this.decryptElement(document, (Key)privateKey, (X509Certificate)certificate);
            this.checkDecryptedDoc(document2, true);
        } else {
            log.warn((Object)"Skipping testRSA2048 as necessary crypto algorithms are not available");
        }
    }

    @Test
    public void testKeyWrappingRSA4096() throws Exception {
        if (this.haveISOPadding) {
            String string = "src/test/resources/org/w3c/www/interop/xmlenc-core-11/RSA-4096_SHA256WithRSA.jks";
            String string2 = System.getProperty("basedir");
            if (string2 != null && !"".equals(string2)) {
                string = string2 + "/" + string;
            }
            KeyStore keyStore = KeyStore.getInstance("jks");
            keyStore.load(new FileInputStream(string), "passwd".toCharArray());
            Certificate certificate = keyStore.getCertificate("importkey");
            KeyStore.PrivateKeyEntry privateKeyEntry = (KeyStore.PrivateKeyEntry)keyStore.getEntry("importkey", new KeyStore.PasswordProtection("passwd".toCharArray()));
            PrivateKey privateKey = privateKeyEntry.getPrivateKey();
            String string3 = "src/test/resources/org/w3c/www/interop/xmlenc-core-11/cipherText__RSA-4096__aes256-gcm__rsa-oaep__Sha512-MGF_Sha1_PSource.xml";
            Document document = this.decryptElement(string3, (Key)privateKey, (X509Certificate)certificate);
            this.checkDecryptedDoc(document, true);
        } else {
            log.warn((Object)"Skipping testRSA4096 as necessary crypto algorithms are not available");
        }
    }

    @Test
    public void testKeyWrappingRSA4096EncryptDecrypt() throws Exception {
        if (this.haveISOPadding) {
            String string = "src/test/resources/org/w3c/www/interop/xmlenc-core-11/RSA-4096_SHA256WithRSA.jks";
            String string2 = System.getProperty("basedir");
            if (string2 != null && !"".equals(string2)) {
                string = string2 + "/" + string;
            }
            KeyStore keyStore = KeyStore.getInstance("jks");
            keyStore.load(new FileInputStream(string), "passwd".toCharArray());
            Certificate certificate = keyStore.getCertificate("importkey");
            KeyStore.PrivateKeyEntry privateKeyEntry = (KeyStore.PrivateKeyEntry)keyStore.getEntry("importkey", new KeyStore.PasswordProtection("passwd".toCharArray()));
            PrivateKey privateKey = privateKeyEntry.getPrivateKey();
            String string3 = "src/test/resources/org/w3c/www/interop/xmlenc-core-11/plaintext.xml";
            if (string2 != null && !"".equals(string2)) {
                string3 = string2 + "/" + string3;
            }
            File file = new File(string3);
            DocumentBuilder documentBuilder = XMLUtils.createDocumentBuilder((boolean)false);
            Document document = documentBuilder.parse(new FileInputStream(file));
            Key key = this.getSessionKey("http://www.w3.org/2009/xmlenc11#aes256-gcm");
            EncryptedKey encryptedKey = this.createEncryptedKey(document, (X509Certificate)certificate, key, "http://www.w3.org/2009/xmlenc11#rsa-oaep", "http://www.w3.org/2001/04/xmlenc#sha512", "http://www.w3.org/2009/xmlenc11#mgf1sha1", Base64.decode((byte[])"ZHVtbXkxMjM=".getBytes("UTF-8")));
            document = this.encryptDocument(document, encryptedKey, key, "http://www.w3.org/2009/xmlenc11#aes256-gcm");
            Document document2 = this.decryptElement(document, (Key)privateKey, (X509Certificate)certificate);
            this.checkDecryptedDoc(document2, true);
        } else {
            log.warn((Object)"Skipping testRSA2048 as necessary crypto algorithms are not available");
        }
    }

    private Document decryptElement(String string, Key key, X509Certificate x509Certificate) throws Exception {
        String string2 = System.getProperty("basedir");
        if (string2 != null && !"".equals(string2)) {
            string = string2 + "/" + string;
        }
        File file = new File(string);
        DocumentBuilder documentBuilder = XMLUtils.createDocumentBuilder((boolean)false);
        Document document = documentBuilder.parse(new FileInputStream(file));
        return this.decryptElement(document, key, x509Certificate);
    }

    private Document decryptElement(Document document, Key key, X509Certificate x509Certificate) throws Exception {
        XMLCipher xMLCipher = XMLCipher.getInstance();
        Element element = (Element)document.getElementsByTagNameNS("http://www.w3.org/2001/04/xmlenc#", "EncryptedData").item(0);
        xMLCipher.init(2, null);
        EncryptedData encryptedData = xMLCipher.loadEncryptedData(document, element);
        KeyInfo keyInfo = encryptedData.getKeyInfo();
        EncryptedKey encryptedKey = keyInfo.itemEncryptedKey(0);
        KeyInfo keyInfo2 = encryptedKey.getKeyInfo();
        X509Data x509Data = keyInfo2.itemX509Data(0);
        XMLX509Certificate xMLX509Certificate = x509Data.itemCertificate(0);
        X509Certificate x509Certificate2 = xMLX509Certificate.getX509Certificate();
        XMLEncryption11Test.assertTrue((boolean)x509Certificate.equals(x509Certificate2));
        XMLCipher xMLCipher2 = XMLCipher.getInstance();
        xMLCipher2.init(4, key);
        Key key2 = xMLCipher2.decryptKey(encryptedKey, encryptedData.getEncryptionMethod().getAlgorithm());
        xMLCipher.init(2, key2);
        Document document2 = xMLCipher.doFinal(document, element);
        return document2;
    }

    private EncryptedKey createEncryptedKey(Document document, X509Certificate x509Certificate, Key key, String string, String string2, String string3, byte[] byArray) throws Exception {
        XMLCipher xMLCipher = XMLCipher.getInstance((String)string, null, (String)string2);
        xMLCipher.init(3, (Key)x509Certificate.getPublicKey());
        EncryptedKey encryptedKey = xMLCipher.encryptKey(document, key, string3, byArray);
        KeyInfo keyInfo = encryptedKey.getKeyInfo();
        if (keyInfo == null) {
            keyInfo = new KeyInfo(document);
            encryptedKey.setKeyInfo(keyInfo);
        }
        X509Data x509Data = new X509Data(document);
        x509Data.addCertificate(x509Certificate);
        keyInfo.add(x509Data);
        return encryptedKey;
    }

    private Key getSessionKey(String string) throws Exception {
        KeyGenerator keyGenerator = KeyGenerator.getInstance("AES");
        if (string.contains("128")) {
            keyGenerator.init(128);
        } else if (string.contains("192")) {
            keyGenerator.init(192);
        } else if (string.contains("256")) {
            keyGenerator.init(256);
        }
        return keyGenerator.generateKey();
    }

    private Document encryptDocument(Document document, EncryptedKey encryptedKey, Key key, String string) throws Exception {
        XMLCipher xMLCipher = XMLCipher.getInstance((String)string);
        xMLCipher.init(1, key);
        EncryptedData encryptedData = xMLCipher.getEncryptedData();
        KeyInfo keyInfo = encryptedData.getKeyInfo();
        if (keyInfo == null) {
            keyInfo = new KeyInfo(document);
            encryptedData.setKeyInfo(keyInfo);
        }
        keyInfo.add(encryptedKey);
        return xMLCipher.doFinal(document, document.getDocumentElement());
    }

    private static int countNodes(Node node) {
        if (node == null) {
            return 0;
        }
        int n = 1;
        for (Node node2 = node.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
            n += XMLEncryption11Test.countNodes(node2);
        }
        return n;
    }

    private static String retrieveCCNumber(Document document) throws TransformerException, XPathExpressionException {
        XPathFactory xPathFactory = XPathFactory.newInstance();
        XPath xPath = xPathFactory.newXPath();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("x", "urn:example:po");
        DSNamespaceContext dSNamespaceContext = new DSNamespaceContext(hashMap);
        xPath.setNamespaceContext(dSNamespaceContext);
        String string = "//x:Number/text()";
        Node node = (Node)xPath.evaluate(string, document, XPathConstants.NODE);
        if (node != null) {
            return node.getNodeValue();
        }
        return null;
    }

    private void checkDecryptedDoc(Document document, boolean bl) throws Exception {
        String string = XMLEncryption11Test.retrieveCCNumber(document);
        log.debug((Object)("Retrieved Credit Card : " + string));
        XMLEncryption11Test.assertTrue((String)string, (string != null && string.equals(cardNumber) ? 1 : 0) != 0);
        if (bl) {
            int n = XMLEncryption11Test.countNodes(document);
            XMLEncryption11Test.assertTrue((String)"Node count mismatches", (n > 0 && n == nodeCount ? 1 : 0) != 0);
        }
    }

    static {
        nodeCount = 0;
        log = LogFactory.getLog((String)XMLEncryption11Test.class.getName());
    }
}

