/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.test.interop;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xml.security.Init;
import org.apache.xml.security.signature.XMLSignatureException;
import org.apache.xml.security.test.interop.InteropTestBase;
import org.apache.xml.security.test.utils.resolver.OfflineResolver;
import org.apache.xml.security.utils.resolver.ResourceResolverSpi;
import org.apache.xml.security.utils.resolver.implementations.ResolverAnonymous;
import org.junit.Test;

public class IAIKTest
extends InteropTestBase {
    static Log log = LogFactory.getLog((String)IAIKTest.class.getName());
    static String gregorsDir = "src/test/resources/at/iaik/ixsil/";

    @Test
    public void test_signatureAlgorithms_signatures_hMACShortSignature() throws Exception {
        block3: {
            String string = gregorsDir + "signatureAlgorithms/signatures/hMACShortSignature.xml";
            OfflineResolver offlineResolver = new OfflineResolver();
            boolean bl = false;
            byte[] byArray = "secret".getBytes("ASCII");
            try {
                this.verifyHMAC(string, offlineResolver, bl, byArray);
                IAIKTest.fail((String)"HMACOutputLength Exception not caught");
            }
            catch (RuntimeException runtimeException) {
                log.error((Object)("Verification crashed for " + string));
                throw runtimeException;
            }
            catch (XMLSignatureException xMLSignatureException) {
                if (xMLSignatureException.getMsgID().equals("algorithms.HMACOutputLengthMin")) break block3;
                IAIKTest.fail((String)xMLSignatureException.getMessage());
            }
        }
    }

    @Test
    public void test_signatureAlgorithms_signatures_hMACSignature() throws Exception {
        String string = gregorsDir + "signatureAlgorithms/signatures/hMACSignature.xml";
        OfflineResolver offlineResolver = new OfflineResolver();
        boolean bl = false;
        byte[] byArray = "secret".getBytes("ASCII");
        boolean bl2 = false;
        try {
            bl2 = this.verifyHMAC(string, offlineResolver, bl, byArray);
        }
        catch (RuntimeException runtimeException) {
            log.error((Object)("Verification crashed for " + string));
            throw runtimeException;
        }
        if (!bl2) {
            log.error((Object)("Verification failed for " + string));
        }
        IAIKTest.assertTrue((String)string, (boolean)bl2);
    }

    @Test
    public void test_coreFeatures_signatures_manifestSignature_core() throws Exception {
        String string = gregorsDir + "coreFeatures/signatures/manifestSignature.xml";
        ResourceResolverSpi resourceResolverSpi = null;
        boolean bl = false;
        boolean bl2 = false;
        try {
            bl2 = this.verify(string, resourceResolverSpi, bl);
        }
        catch (RuntimeException runtimeException) {
            log.error((Object)("Core validation crashed for " + string));
            throw runtimeException;
        }
        if (!bl2) {
            log.error((Object)("Core validation failed for " + string));
        }
        IAIKTest.assertTrue((String)("Core validation failed for " + string), (boolean)bl2);
    }

    @Test
    public void test_coreFeatures_signatures_manifestSignature_manifest() throws Exception {
        String string = gregorsDir + "coreFeatures/signatures/manifestSignature.xml";
        ResourceResolverSpi resourceResolverSpi = null;
        boolean bl = true;
        boolean bl2 = false;
        try {
            bl2 = this.verify(string, resourceResolverSpi, bl);
        }
        catch (RuntimeException runtimeException) {
            log.error((Object)("Verification crashed for " + string));
            throw runtimeException;
        }
        if (!bl2) {
            log.error((Object)("Following the ds:Manifest failed for " + string));
        }
        IAIKTest.assertTrue((String)("Following the ds:Manifest failed for " + string), (boolean)bl2);
    }

    @Test
    public void test_coreFeatures_signatures_signatureTypesSignature() throws Exception {
        String string = gregorsDir + "coreFeatures/signatures/signatureTypesSignature.xml";
        OfflineResolver offlineResolver = new OfflineResolver();
        boolean bl = false;
        boolean bl2 = false;
        try {
            bl2 = this.verify(string, offlineResolver, bl);
        }
        catch (RuntimeException runtimeException) {
            log.error((Object)("Verification crashed for " + string));
            throw runtimeException;
        }
        if (!bl2) {
            log.error((Object)("Verification failed for " + string));
        }
        IAIKTest.assertTrue((String)("Verification failed for " + string), (boolean)bl2);
    }

    @Test
    public void test_coreFeatures_signatures_anonymousReferenceSignature() throws Exception {
        String string = gregorsDir + "coreFeatures/signatures/anonymousReferenceSignature.xml";
        String string2 = gregorsDir + "coreFeatures/samples/anonymousReferenceContent.xml";
        ResolverAnonymous resolverAnonymous = new ResolverAnonymous(string2);
        boolean bl = false;
        boolean bl2 = false;
        try {
            bl2 = this.verify(string, (ResourceResolverSpi)resolverAnonymous, bl);
        }
        catch (RuntimeException runtimeException) {
            log.error((Object)("Verification crashed for " + string));
            throw runtimeException;
        }
        if (!bl2) {
            log.error((Object)("Verification failed for " + string));
        }
        IAIKTest.assertTrue((String)string, (boolean)bl2);
    }

    @Test
    public void test_signatureAlgorithms_signatures_dSASignature() throws Exception {
        String string = gregorsDir + "signatureAlgorithms/signatures/dSASignature.xml";
        ResourceResolverSpi resourceResolverSpi = null;
        boolean bl = false;
        boolean bl2 = false;
        try {
            bl2 = this.verify(string, resourceResolverSpi, bl);
        }
        catch (RuntimeException runtimeException) {
            log.error((Object)("Verification crashed for " + string));
            throw runtimeException;
        }
        if (!bl2) {
            log.error((Object)("Verification failed for " + string));
        }
        IAIKTest.assertTrue((String)string, (boolean)bl2);
    }

    @Test
    public void test_signatureAlgorithms_signatures_rSASignature() throws Exception {
        String string = gregorsDir + "signatureAlgorithms/signatures/rSASignature.xml";
        ResourceResolverSpi resourceResolverSpi = null;
        boolean bl = false;
        boolean bl2 = false;
        try {
            bl2 = this.verify(string, resourceResolverSpi, bl);
        }
        catch (RuntimeException runtimeException) {
            log.error((Object)("Verification crashed for " + string));
            throw runtimeException;
        }
        if (!bl2) {
            log.error((Object)("Verification failed for " + string));
        }
        IAIKTest.assertTrue((String)string, (boolean)bl2);
    }

    @Test
    public void test_transforms_signatures_base64DecodeSignature() throws Exception {
        String string = gregorsDir + "transforms/signatures/base64DecodeSignature.xml";
        ResourceResolverSpi resourceResolverSpi = null;
        boolean bl = false;
        boolean bl2 = false;
        try {
            bl2 = this.verify(string, resourceResolverSpi, bl);
        }
        catch (RuntimeException runtimeException) {
            log.error((Object)("Verification crashed for " + string));
            throw runtimeException;
        }
        if (!bl2) {
            log.error((Object)("Verification failed for " + string));
        }
        IAIKTest.assertTrue((String)string, (boolean)bl2);
    }

    @Test
    public void test_transforms_signatures_c14nSignature() throws Exception {
        String string = gregorsDir + "transforms/signatures/c14nSignature.xml";
        ResourceResolverSpi resourceResolverSpi = null;
        boolean bl = false;
        boolean bl2 = false;
        try {
            bl2 = this.verify(string, resourceResolverSpi, bl);
        }
        catch (RuntimeException runtimeException) {
            log.error((Object)("Verification crashed for " + string));
            throw runtimeException;
        }
        if (!bl2) {
            log.error((Object)("Verification failed for " + string));
        }
        IAIKTest.assertTrue((String)string, (boolean)bl2);
    }

    @Test
    public void test_transforms_signatures_envelopedSignatureSignature() throws Exception {
        String string = gregorsDir + "transforms/signatures/envelopedSignatureSignature.xml";
        ResourceResolverSpi resourceResolverSpi = null;
        boolean bl = false;
        boolean bl2 = false;
        try {
            bl2 = this.verify(string, resourceResolverSpi, bl);
        }
        catch (RuntimeException runtimeException) {
            log.error((Object)("Verification crashed for " + string));
            throw runtimeException;
        }
        if (!bl2) {
            log.error((Object)("Verification failed for " + string));
        }
        IAIKTest.assertTrue((String)string, (boolean)bl2);
    }

    @Test
    public void test_transforms_signatures_xPathSignature() throws Exception {
        String string = gregorsDir + "transforms/signatures/xPathSignature.xml";
        ResourceResolverSpi resourceResolverSpi = null;
        boolean bl = false;
        boolean bl2 = false;
        try {
            bl2 = this.verify(string, resourceResolverSpi, bl);
        }
        catch (RuntimeException runtimeException) {
            log.error((Object)("Verification crashed for " + string));
            throw runtimeException;
        }
        if (!bl2) {
            log.error((Object)("Verification failed for " + string));
        }
        IAIKTest.assertTrue((String)string, (boolean)bl2);
    }

    static {
        String string = System.getProperty("basedir");
        if (string != null && !"".equals(string)) {
            gregorsDir = string + "/" + gregorsDir;
        }
        Init.init();
    }
}

