/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.test.interop;

import java.io.File;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xml.security.Init;
import org.apache.xml.security.test.interop.InteropTestBase;
import org.apache.xml.security.test.utils.resolver.OfflineResolver;
import org.apache.xml.security.utils.JavaUtils;
import org.apache.xml.security.utils.resolver.ResourceResolverSpi;
import org.junit.Ignore;
import org.junit.Test;

public class IBMTest
extends InteropTestBase {
    static Log log = LogFactory.getLog((String)IBMTest.class.getName());
    static final String kentsDir = "data/com/ibm/xss4j-20030127/";
    private boolean runTests = false;

    public IBMTest() {
        String string = "src/test/resources/com/ibm/xss4j-20011029/enveloped-rsa.sig";
        File file = new File(string);
        if (file.exists()) {
            this.runTests = true;
        }
    }

    @Test
    public void test_enveloping_hmac() throws Exception {
        if (!this.runTests) {
            return;
        }
        String string = "data/com/ibm/xss4j-20030127/enveloping-hmac.sig";
        OfflineResolver offlineResolver = new OfflineResolver();
        boolean bl = false;
        byte[] byArray = JavaUtils.getBytesFromFile((String)"data/com/ibm/xss4j-20030127/enveloping-hmac.key");
        boolean bl2 = false;
        try {
            bl2 = this.verifyHMAC(string, offlineResolver, bl, byArray);
        }
        catch (RuntimeException runtimeException) {
            log.error((Object)("Verification crashed for " + string));
            throw runtimeException;
        }
        if (!bl2) {
            log.error((Object)("Verification failed for " + string));
        }
        IBMTest.assertTrue((String)string, (boolean)bl2);
    }

    @Test
    public void test_detached_dsa() throws Exception {
        if (!this.runTests) {
            return;
        }
        String string = "data/com/ibm/xss4j-20030127/detached-dsa.sig";
        OfflineResolver offlineResolver = new OfflineResolver();
        boolean bl = false;
        boolean bl2 = false;
        try {
            bl2 = this.verify(string, offlineResolver, bl);
        }
        catch (RuntimeException runtimeException) {
            log.error((Object)("Verification crashed for " + string));
            throw runtimeException;
        }
        if (!bl2) {
            log.error((Object)("Verification failed for " + string));
        }
        IBMTest.assertTrue((String)string, (boolean)bl2);
    }

    @Test
    public void test_detached_rsa() throws Exception {
        if (!this.runTests) {
            return;
        }
        String string = "data/com/ibm/xss4j-20030127/detached-rsa.sig";
        OfflineResolver offlineResolver = new OfflineResolver();
        boolean bl = false;
        boolean bl2 = false;
        try {
            bl2 = this.verify(string, offlineResolver, bl);
        }
        catch (RuntimeException runtimeException) {
            log.error((Object)("Verification crashed for " + string));
            throw runtimeException;
        }
        if (!bl2) {
            log.error((Object)("Verification failed for " + string));
        }
        IBMTest.assertTrue((String)string, (boolean)bl2);
    }

    @Test
    public void test_enveloped_dsa() throws Exception {
        if (!this.runTests) {
            return;
        }
        String string = "data/com/ibm/xss4j-20030127/enveloped-dsa.sig";
        ResourceResolverSpi resourceResolverSpi = null;
        boolean bl = false;
        boolean bl2 = false;
        try {
            bl2 = this.verify(string, resourceResolverSpi, bl);
        }
        catch (RuntimeException runtimeException) {
            log.error((Object)("Verification crashed for " + string));
            throw runtimeException;
        }
        if (!bl2) {
            log.error((Object)("Verification failed for " + string));
        }
        IBMTest.assertTrue((String)string, (boolean)bl2);
    }

    @Test
    public void test_enveloped_rsa() throws Exception {
        if (!this.runTests) {
            return;
        }
        String string = "data/com/ibm/xss4j-20030127/enveloped-rsa.sig";
        ResourceResolverSpi resourceResolverSpi = null;
        boolean bl = false;
        boolean bl2 = false;
        try {
            bl2 = this.verify(string, resourceResolverSpi, bl);
        }
        catch (RuntimeException runtimeException) {
            log.error((Object)("Verification crashed for " + string));
            throw runtimeException;
        }
        if (!bl2) {
            log.error((Object)("Verification failed for " + string));
        }
        IBMTest.assertTrue((String)string, (boolean)bl2);
    }

    @Test
    public void test_enveloping_dsa() throws Exception {
        if (!this.runTests) {
            return;
        }
        String string = "data/com/ibm/xss4j-20030127/enveloping-dsa.sig";
        ResourceResolverSpi resourceResolverSpi = null;
        boolean bl = false;
        boolean bl2 = false;
        try {
            bl2 = this.verify(string, resourceResolverSpi, bl);
        }
        catch (RuntimeException runtimeException) {
            log.error((Object)("Verification crashed for " + string));
            throw runtimeException;
        }
        if (!bl2) {
            log.error((Object)("Verification failed for " + string));
        }
        IBMTest.assertTrue((String)string, (boolean)bl2);
    }

    @Test
    public void test_enveloping_rsa() throws Exception {
        if (!this.runTests) {
            return;
        }
        String string = "data/com/ibm/xss4j-20030127/enveloping-rsa.sig";
        ResourceResolverSpi resourceResolverSpi = null;
        boolean bl = false;
        boolean bl2 = false;
        try {
            bl2 = this.verify(string, resourceResolverSpi, bl);
        }
        catch (RuntimeException runtimeException) {
            log.error((Object)("Verification crashed for " + string));
            throw runtimeException;
        }
        if (!bl2) {
            log.error((Object)("Verification failed for " + string));
        }
        IBMTest.assertTrue((String)string, (boolean)bl2);
    }

    @Test
    public void test_enveloping_dsa_soaped_broken() throws Exception {
        if (!this.runTests) {
            return;
        }
        String string = "data/com/ibm/xss4j-20030127/enveloping-dsa-soaped-broken.sig";
        if (!new File(string).exists()) {
            System.err.println("Couldn't find: " + string + " and couldn't do the test");
            return;
        }
        ResourceResolverSpi resourceResolverSpi = null;
        boolean bl = false;
        boolean bl2 = true;
        try {
            bl2 = this.verify(string, resourceResolverSpi, bl);
        }
        catch (RuntimeException runtimeException) {
            log.error((Object)("Verification crashed for " + string));
            throw runtimeException;
        }
        if (bl2) {
            log.error((Object)("Verification failed for " + string + ", had to be broken but was successful"));
        }
        IBMTest.assertTrue((String)string, (!bl2 ? 1 : 0) != 0);
    }

    @Ignore
    public void _not_active_test_enveloping_exclusive() throws Exception {
    }

    @Ignore
    public void _not_active_test_enveloping_exclusive_soaped() throws Exception {
    }

    static {
        Init.init();
    }
}

