/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.test.interop;

import java.io.File;
import java.io.FileInputStream;
import java.security.Key;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.Iterator;
import javax.crypto.SecretKey;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xml.security.keys.KeyInfo;
import org.apache.xml.security.signature.Reference;
import org.apache.xml.security.signature.SignedInfo;
import org.apache.xml.security.signature.XMLSignature;
import org.apache.xml.security.signature.reference.ReferenceData;
import org.apache.xml.security.signature.reference.ReferenceNodeSetData;
import org.apache.xml.security.signature.reference.ReferenceOctetStreamData;
import org.apache.xml.security.test.DSNamespaceContext;
import org.apache.xml.security.utils.XMLUtils;
import org.apache.xml.security.utils.resolver.ResourceResolverSpi;
import org.junit.Assert;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class InteropTestBase
extends Assert {
    static Log log = LogFactory.getLog((String)InteropTestBase.class.getName());

    public boolean verifyHMAC(String string, ResourceResolverSpi resourceResolverSpi, boolean bl, byte[] byArray) throws Exception {
        File file = new File(string);
        DocumentBuilder documentBuilder = XMLUtils.createDocumentBuilder((boolean)false, (boolean)false);
        Document document = documentBuilder.parse(new FileInputStream(file));
        XPathFactory xPathFactory = XPathFactory.newInstance();
        XPath xPath = xPathFactory.newXPath();
        xPath.setNamespaceContext(new DSNamespaceContext());
        String string2 = "//ds:Signature[1]";
        Element element = (Element)xPath.evaluate(string2, document, XPathConstants.NODE);
        XMLSignature xMLSignature = new XMLSignature(element, file.toURI().toURL().toString());
        if (resourceResolverSpi != null) {
            xMLSignature.addResourceResolver(resourceResolverSpi);
        }
        xMLSignature.setFollowNestedManifests(bl);
        byte[] byArray2 = byArray;
        SecretKey secretKey = xMLSignature.createSecretKey(byArray2);
        return xMLSignature.checkSignatureValue((Key)secretKey);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean verify(String string, ResourceResolverSpi resourceResolverSpi, boolean bl) throws Exception {
        File file = new File(string);
        DocumentBuilder documentBuilder = XMLUtils.createDocumentBuilder((boolean)false, (boolean)false);
        Document document = documentBuilder.parse(file);
        XPathFactory xPathFactory = XPathFactory.newInstance();
        XPath xPath = xPathFactory.newXPath();
        xPath.setNamespaceContext(new DSNamespaceContext());
        String string2 = "//ds:Signature[1]";
        Element element = (Element)xPath.evaluate(string2, document, XPathConstants.NODE);
        XMLSignature xMLSignature = new XMLSignature(element, file.toURI().toURL().toString());
        if (resourceResolverSpi != null) {
            xMLSignature.addResourceResolver(resourceResolverSpi);
        }
        xMLSignature.setFollowNestedManifests(bl);
        KeyInfo keyInfo = xMLSignature.getKeyInfo();
        boolean bl2 = false;
        if (keyInfo == null) throw new RuntimeException("Did not find a KeyInfo");
        X509Certificate x509Certificate = keyInfo.getX509Certificate();
        if (x509Certificate != null) {
            bl2 = xMLSignature.checkSignatureValue(x509Certificate);
        } else {
            PublicKey publicKey = keyInfo.getPublicKey();
            if (publicKey == null) throw new RuntimeException("Did not find a public key, so I can't check the signature");
            bl2 = xMLSignature.checkSignatureValue((Key)publicKey);
        }
        this.checkReferences(xMLSignature);
        if (bl2) return bl2;
        for (int i = 0; i < xMLSignature.getSignedInfo().getLength(); ++i) {
            boolean bl3 = xMLSignature.getSignedInfo().getVerificationResult(i);
            if (bl3) {
                log.debug((Object)("Reference " + i + " was OK"));
                continue;
            }
            log.debug((Object)("Reference " + i + " was not OK"));
        }
        this.checkReferences(xMLSignature);
        return bl2;
    }

    private void checkReferences(XMLSignature xMLSignature) throws Exception {
        SignedInfo signedInfo = xMLSignature.getSignedInfo();
        InteropTestBase.assertTrue((signedInfo.getLength() > 0 ? 1 : 0) != 0);
        for (int i = 0; i < signedInfo.getLength(); ++i) {
            Reference reference = signedInfo.item(i);
            InteropTestBase.assertNotNull((Object)reference);
            ReferenceData referenceData = reference.getReferenceData();
            InteropTestBase.assertNotNull((Object)referenceData);
            if (referenceData instanceof ReferenceNodeSetData) {
                Iterator iterator = ((ReferenceNodeSetData)referenceData).iterator();
                InteropTestBase.assertTrue((boolean)iterator.hasNext());
                boolean bl = false;
                while (iterator.hasNext()) {
                    Node node = (Node)iterator.next();
                    if (!(node instanceof Element)) continue;
                    bl = true;
                    break;
                }
                InteropTestBase.assertTrue((boolean)bl);
                continue;
            }
            if (!(referenceData instanceof ReferenceOctetStreamData)) continue;
            InteropTestBase.assertNotNull((Object)((ReferenceOctetStreamData)referenceData).getOctetStream());
        }
    }
}

