/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.test.keys.content.x509;

import java.io.File;
import java.io.FileInputStream;
import java.security.cert.CertStore;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.CollectionCertStoreParameters;
import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Collections;
import org.apache.xml.security.keys.content.x509.XMLX509SKI;
import org.junit.Assert;
import org.junit.Test;

public class XMLX509SKITest
extends Assert {
    private static final String BASEDIR = System.getProperty("basedir");
    private static final String SEP = System.getProperty("file.separator");
    private CertificateFactory cf = CertificateFactory.getInstance("X.509");

    @Test
    public void testGetSKIBytesFromCert() throws Exception {
        File file = null;
        file = BASEDIR != null && !"".equals(BASEDIR) ? new File(BASEDIR + SEP + "src/test/resources/ie/baltimore/merlin-examples/merlin-xmldsig-twenty-three/certs/lugh.crt") : new File("src/test/resources/ie/baltimore/merlin-examples/merlin-xmldsig-twenty-three/certs/lugh.crt");
        FileInputStream fileInputStream = new FileInputStream(file);
        X509Certificate x509Certificate = (X509Certificate)this.cf.generateCertificate(fileInputStream);
        byte[] byArray = XMLX509SKI.getSKIBytesFromCert((X509Certificate)x509Certificate);
        X509CertSelector x509CertSelector = new X509CertSelector();
        byte[] byArray2 = new byte[byArray.length + 2];
        byArray2[0] = 4;
        byArray2[1] = (byte)byArray.length;
        System.arraycopy(byArray, 0, byArray2, 2, byArray.length);
        x509CertSelector.setSubjectKeyIdentifier(byArray2);
        CertStore certStore = CertStore.getInstance("Collection", new CollectionCertStoreParameters(Collections.singleton(x509Certificate)));
        Collection<? extends Certificate> collection = certStore.getCertificates(x509CertSelector);
        XMLX509SKITest.assertTrue((!collection.isEmpty() ? 1 : 0) != 0);
    }
}

