/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.test.keys.keyresolver;

import java.io.FileInputStream;
import java.math.BigInteger;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.RSAPrivateKeySpec;
import java.security.spec.RSAPublicKeySpec;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import javax.xml.parsers.DocumentBuilder;
import org.apache.xml.security.Init;
import org.apache.xml.security.algorithms.JCEMapper;
import org.apache.xml.security.encryption.EncryptedData;
import org.apache.xml.security.encryption.EncryptedKey;
import org.apache.xml.security.encryption.XMLCipher;
import org.apache.xml.security.keys.KeyInfo;
import org.apache.xml.security.keys.content.X509Data;
import org.apache.xml.security.keys.content.x509.XMLX509Certificate;
import org.apache.xml.security.keys.content.x509.XMLX509IssuerSerial;
import org.apache.xml.security.keys.content.x509.XMLX509SKI;
import org.apache.xml.security.keys.content.x509.XMLX509SubjectName;
import org.apache.xml.security.keys.keyresolver.KeyResolver;
import org.apache.xml.security.keys.keyresolver.KeyResolverException;
import org.apache.xml.security.keys.keyresolver.KeyResolverSpi;
import org.apache.xml.security.keys.keyresolver.implementations.PrivateKeyResolver;
import org.apache.xml.security.keys.keyresolver.implementations.SecretKeyResolver;
import org.apache.xml.security.keys.keyresolver.implementations.SingleKeyResolver;
import org.apache.xml.security.keys.storage.StorageResolver;
import org.apache.xml.security.keys.storage.StorageResolverSpi;
import org.apache.xml.security.keys.storage.implementations.KeyStoreResolver;
import org.apache.xml.security.utils.XMLUtils;
import org.junit.Assert;
import org.junit.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class KeyResolverTest
extends Assert {
    private static final String BASEDIR = System.getProperty("basedir");
    private static final String SEP = System.getProperty("file.separator");

    public KeyResolverTest() {
        Init.init();
    }

    @Test
    public void testKeyResolvers() throws Exception {
        char[] cArray = "secret".toCharArray();
        KeyStore keyStore = KeyStore.getInstance("JCEKS");
        FileInputStream fileInputStream = null;
        fileInputStream = BASEDIR != null && !"".equals(BASEDIR) ? new FileInputStream(BASEDIR + SEP + "src/test/resources/test.jceks") : new FileInputStream("src/test/resources/test.jceks");
        keyStore.load(fileInputStream, cArray);
        X509Certificate x509Certificate = (X509Certificate)keyStore.getCertificate("rsakey");
        PublicKey publicKey = x509Certificate.getPublicKey();
        PrivateKey privateKey = (PrivateKey)keyStore.getKey("rsakey", cArray);
        SecretKey secretKey = (SecretKey)keyStore.getKey("des3key", cArray);
        StorageResolver storageResolver = new StorageResolver((StorageResolverSpi)new KeyStoreResolver(keyStore));
        PrivateKeyResolver privateKeyResolver = new PrivateKeyResolver(keyStore, cArray);
        SecretKeyResolver secretKeyResolver = new SecretKeyResolver(keyStore, cArray);
        DocumentBuilder documentBuilder = XMLUtils.createDocumentBuilder((boolean)false);
        Document document = documentBuilder.newDocument();
        KeyInfo keyInfo = new KeyInfo(document);
        keyInfo.addStorageResolver(storageResolver);
        X509Data x509Data = new X509Data(document);
        x509Data.add(new XMLX509Certificate(document, x509Certificate));
        keyInfo.add(x509Data);
        KeyResolverTest.assertEquals((Object)publicKey, (Object)keyInfo.getPublicKey());
        KeyResolverTest.assertNull((Object)keyInfo.getPrivateKey());
        keyInfo.registerInternalKeyResolver((KeyResolverSpi)privateKeyResolver);
        KeyResolverTest.assertEquals((Object)privateKey, (Object)keyInfo.getPrivateKey());
        keyInfo = new KeyInfo(document);
        keyInfo.addStorageResolver(storageResolver);
        x509Data = new X509Data(document);
        x509Data.add(new XMLX509IssuerSerial(document, x509Certificate.getIssuerX500Principal().getName(), x509Certificate.getSerialNumber()));
        keyInfo.add(x509Data);
        KeyResolverTest.assertEquals((Object)publicKey, (Object)keyInfo.getPublicKey());
        keyInfo.registerInternalKeyResolver((KeyResolverSpi)privateKeyResolver);
        KeyResolverTest.assertEquals((Object)privateKey, (Object)keyInfo.getPrivateKey());
        keyInfo = new KeyInfo(document);
        keyInfo.addStorageResolver(storageResolver);
        x509Data = new X509Data(document);
        x509Data.add(new XMLX509SubjectName(document, x509Certificate.getSubjectX500Principal().getName()));
        keyInfo.add(x509Data);
        KeyResolverTest.assertEquals((Object)publicKey, (Object)keyInfo.getPublicKey());
        keyInfo.registerInternalKeyResolver((KeyResolverSpi)privateKeyResolver);
        KeyResolverTest.assertEquals((Object)privateKey, (Object)keyInfo.getPrivateKey());
        keyInfo = new KeyInfo(document);
        keyInfo.addStorageResolver(storageResolver);
        x509Data = new X509Data(document);
        x509Data.add(new XMLX509SKI(document, x509Certificate));
        keyInfo.add(x509Data);
        KeyResolverTest.assertEquals((Object)publicKey, (Object)keyInfo.getPublicKey());
        keyInfo.registerInternalKeyResolver((KeyResolverSpi)privateKeyResolver);
        KeyResolverTest.assertEquals((Object)privateKey, (Object)keyInfo.getPrivateKey());
        String string = "rsakey";
        keyInfo = new KeyInfo(document);
        keyInfo.addKeyName(string);
        keyInfo.registerInternalKeyResolver((KeyResolverSpi)new SingleKeyResolver(string, publicKey));
        KeyResolverTest.assertEquals((Object)publicKey, (Object)keyInfo.getPublicKey());
        keyInfo = new KeyInfo(document);
        keyInfo.addKeyName(string);
        keyInfo.registerInternalKeyResolver((KeyResolverSpi)privateKeyResolver);
        KeyResolverTest.assertEquals((Object)privateKey, (Object)keyInfo.getPrivateKey());
        keyInfo = new KeyInfo(document);
        keyInfo.addKeyName(string);
        keyInfo.registerInternalKeyResolver((KeyResolverSpi)new SingleKeyResolver(string, privateKey));
        KeyResolverTest.assertEquals((Object)privateKey, (Object)keyInfo.getPrivateKey());
        String string2 = "des3key";
        keyInfo = new KeyInfo(document);
        keyInfo.addKeyName(string2);
        keyInfo.registerInternalKeyResolver((KeyResolverSpi)secretKeyResolver);
        KeyResolverTest.assertEquals((Object)secretKey, (Object)keyInfo.getSecretKey());
        keyInfo = new KeyInfo(document);
        keyInfo.addKeyName(string2);
        keyInfo.registerInternalKeyResolver((KeyResolverSpi)new SingleKeyResolver(string2, secretKey));
        KeyResolverTest.assertEquals((Object)secretKey, (Object)keyInfo.getSecretKey());
    }

    @Test
    public void testResolvePrivateKey() throws Exception {
        String string = JCEMapper.translateURItoJCEID((String)"http://www.w3.org/2001/04/xmlenc#aes128-cbc");
        boolean bl = false;
        if (string != null) {
            try {
                if (Cipher.getInstance(string) != null) {
                    bl = true;
                }
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            }
            catch (NoSuchPaddingException noSuchPaddingException) {
                // empty catch block
            }
        }
        if (!bl) {
            return;
        }
        Document document = XMLUtils.createDocumentBuilder((boolean)false).newDocument();
        Element element = document.createElement("root");
        document.appendChild(element);
        Element element2 = document.createElement("elem");
        Text text = document.createTextNode("text");
        element2.appendChild(text);
        element.appendChild(element2);
        byte[] byArray = new byte[]{0, 1, 2, 3, 4, 5, 6, 7, 0, 1, 2, 3, 4, 5, 6, 7};
        SecretKeySpec secretKeySpec = new SecretKeySpec(byArray, "AES");
        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
        RSAPublicKeySpec rSAPublicKeySpec = new RSAPublicKeySpec(new BigInteger("8710a2bcb2f3fdac177f0ae0461c2dd0ebf72e0d88a5400583a7d8bdabd6ae009d30cfdf6acb5b6a64cdc730bc630a39d946d08babffe62ea20a87e37c93b3b0e8a8e576045bbddfbde83ca9bfa180fe6a5f5eee60661936d728314e809201ef52cd71d9fa3c8ce83f9d30ab5e081539219e7e45dd6a60be65ac95d2049b8f21", 16), new BigInteger("10001", 16));
        RSAPrivateKeySpec rSAPrivateKeySpec = new RSAPrivateKeySpec(new BigInteger("8710a2bcb2f3fdac177f0ae0461c2dd0ebf72e0d88a5400583a7d8bdabd6ae009d30cfdf6acb5b6a64cdc730bc630a39d946d08babffe62ea20a87e37c93b3b0e8a8e576045bbddfbde83ca9bfa180fe6a5f5eee60661936d728314e809201ef52cd71d9fa3c8ce83f9d30ab5e081539219e7e45dd6a60be65ac95d2049b8f21", 16), new BigInteger("20c39e569c2aa80cc91e5e6b0d56e49e5bbf78827bf56a546c1d996c5975187cb9a50fa828e5efe51d52f5d112c20bc700b836facadca6e0051afcdfe866841e37d207c029536ff8674b301e2198b2c56abb0a0313f8ff84c1fcd6fa541aa6e5d9c018fab4784d2940def5dc709ddc714d73b6c23b5d178eaa5933577b8e8ae9", 16));
        RSAPublicKey rSAPublicKey = (RSAPublicKey)keyFactory.generatePublic(rSAPublicKeySpec);
        RSAPrivateKey rSAPrivateKey = (RSAPrivateKey)keyFactory.generatePrivate(rSAPrivateKeySpec);
        XMLCipher xMLCipher = XMLCipher.getInstance((String)"http://www.w3.org/2001/04/xmlenc#rsa-1_5");
        xMLCipher.init(3, (Key)rSAPublicKey);
        EncryptedKey encryptedKey = xMLCipher.encryptKey(document, (Key)secretKeySpec);
        String string2 = "testResolvePrivateKey";
        KeyInfo keyInfo = new KeyInfo(document);
        keyInfo.addKeyName(string2);
        encryptedKey.setKeyInfo(keyInfo);
        XMLCipher xMLCipher2 = XMLCipher.getInstance((String)"http://www.w3.org/2001/04/xmlenc#aes128-cbc");
        xMLCipher2.init(1, (Key)secretKeySpec);
        EncryptedData encryptedData = xMLCipher2.getEncryptedData();
        KeyInfo keyInfo2 = new KeyInfo(document);
        keyInfo2.add(encryptedKey);
        encryptedData.setKeyInfo(keyInfo2);
        xMLCipher2.doFinal(document, element, true);
        Element element3 = (Element)element.getFirstChild();
        KeyResolverTest.assertEquals((Object)"EncryptedData", (Object)element3.getLocalName());
        MyPrivateKeyResolver.pk = rSAPrivateKey;
        MyPrivateKeyResolver.pkName = string2;
        this.decryptDocument(document, new MyPrivateKeyResolver());
        KeyResolver.registerAtStart((String)MyPrivateKeyResolver.class.getName(), (boolean)false);
        KeyResolverSpi keyResolverSpi = (KeyResolverSpi)KeyResolver.iterator().next();
        KeyResolverTest.assertEquals((Object)MyPrivateKeyResolver.class.getName(), (Object)keyResolverSpi.getClass().getName());
        this.decryptDocument(document, null);
    }

    private void decryptDocument(Document document, KeyResolverSpi keyResolverSpi) throws Exception {
        Document document2 = (Document)document.cloneNode(true);
        Element element = document2.getDocumentElement();
        Element element2 = (Element)element.getFirstChild();
        XMLCipher xMLCipher = XMLCipher.getInstance();
        xMLCipher.init(2, null);
        if (keyResolverSpi != null) {
            xMLCipher.registerInternalKeyResolver(keyResolverSpi);
        }
        xMLCipher.doFinal(document2, element2);
        Element element3 = (Element)element.getFirstChild();
        KeyResolverTest.assertEquals((Object)"elem", (Object)element3.getLocalName());
    }

    public static class MyPrivateKeyResolver
    extends KeyResolverSpi {
        private static PrivateKey pk;
        private static String pkName;

        public boolean engineCanResolve(Element element, String string, StorageResolver storageResolver) {
            return false;
        }

        public PrivateKey engineLookupAndResolvePrivateKey(Element element, String string, StorageResolver storageResolver) throws KeyResolverException {
            String string2;
            if ("http://www.w3.org/2000/09/xmldsig#".equals(element.getNamespaceURI()) && "KeyName".equals(element.getLocalName()) && pkName.equals(string2 = element.getFirstChild().getNodeValue())) {
                return pk;
            }
            return null;
        }
    }
}

