/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.test.keys.keyresolver;

import java.io.FileInputStream;
import java.security.Provider;
import java.security.Security;
import javax.xml.parsers.DocumentBuilder;
import org.apache.jcp.xml.dsig.internal.dom.XMLDSigRI;
import org.apache.xml.security.Init;
import org.apache.xml.security.keys.KeyInfo;
import org.apache.xml.security.utils.XMLUtils;
import org.junit.Assert;
import org.junit.Test;
import org.w3c.dom.Document;

public class RetrievalMethodResolverTest
extends Assert {
    private static final String BASEDIR = System.getProperty("basedir");
    private static final String SEP = System.getProperty("file.separator");

    public RetrievalMethodResolverTest() {
        Init.init();
        Security.insertProviderAt((Provider)new XMLDSigRI(), 1);
    }

    @Test
    public void testReferenceToSameRetrievalMethod() throws Exception {
        FileInputStream fileInputStream = null;
        String string = "src/test/resources/org/apache/xml/security/keyresolver/retrievalmethod1.xml";
        fileInputStream = BASEDIR != null && !"".equals(BASEDIR) ? new FileInputStream(BASEDIR + SEP + string) : new FileInputStream(string);
        DocumentBuilder documentBuilder = XMLUtils.createDocumentBuilder((boolean)false);
        Document document = documentBuilder.parse(fileInputStream);
        KeyInfo keyInfo = new KeyInfo(document.getDocumentElement(), null);
        keyInfo.getPublicKey();
        keyInfo.getX509Certificate();
    }

    @Test
    public void testLoopBetweenRetrievalMethods() throws Exception {
        FileInputStream fileInputStream = null;
        String string = "src/test/resources/org/apache/xml/security/keyresolver/retrievalmethod2.xml";
        fileInputStream = BASEDIR != null && !"".equals(BASEDIR) ? new FileInputStream(BASEDIR + SEP + string) : new FileInputStream(string);
        DocumentBuilder documentBuilder = XMLUtils.createDocumentBuilder((boolean)false);
        Document document = documentBuilder.parse(fileInputStream);
        KeyInfo keyInfo = new KeyInfo(document.getDocumentElement(), null);
        keyInfo.getPublicKey();
        keyInfo.getX509Certificate();
    }
}

