/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.test.keys.storage;

import java.io.FileInputStream;
import java.security.KeyStore;
import java.security.cert.X509Certificate;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.xml.security.keys.storage.implementations.KeyStoreResolver;
import org.junit.Assert;
import org.junit.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KeyStoreResolverTest
extends Assert {
    private static final String BASEDIR = System.getProperty("basedir") == null ? "./" : System.getProperty("basedir");
    private static final String SEP = System.getProperty("file.separator");

    @Test
    public void testKeyStoreResolver() throws Exception {
        FileInputStream fileInputStream = new FileInputStream(BASEDIR + SEP + "src/test/resources" + SEP + "org" + SEP + "apache" + SEP + "xml" + SEP + "security" + SEP + "samples" + SEP + "input" + SEP + "keystore2.jks");
        KeyStore keyStore = KeyStore.getInstance("JCEKS");
        keyStore.load(fileInputStream, "xmlsecurity".toCharArray());
        KeyStoreResolver keyStoreResolver = new KeyStoreResolver(keyStore);
        Iterator iterator = keyStoreResolver.getIterator();
        this.checkIterator(iterator);
        Iterator iterator2 = keyStoreResolver.getIterator();
        this.checkIterator(iterator2);
        iterator = keyStoreResolver.getIterator();
        iterator2 = keyStoreResolver.getIterator();
        while (iterator.hasNext()) {
            X509Certificate x509Certificate;
            X509Certificate x509Certificate2 = (X509Certificate)iterator.next();
            if (x509Certificate2.equals(x509Certificate = (X509Certificate)iterator2.next())) continue;
            KeyStoreResolverTest.fail((String)"KeyStoreResolver iterators are not independent");
        }
        KeyStoreResolverTest.assertFalse((boolean)iterator2.hasNext());
    }

    private void checkIterator(Iterator<?> iterator) {
        int n = 0;
        iterator.hasNext();
        while (iterator.hasNext()) {
            X509Certificate x509Certificate = (X509Certificate)iterator.next();
            x509Certificate.getSubjectX500Principal().getName();
            ++n;
        }
        KeyStoreResolverTest.assertEquals((long)3L, (long)n);
        try {
            iterator.next();
            KeyStoreResolverTest.fail((String)"Expecting NoSuchElementException");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }
}

