/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.test.keys.storage;

import java.io.FileInputStream;
import java.security.KeyStore;
import java.security.cert.X509Certificate;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.xml.security.keys.storage.StorageResolver;
import org.junit.Assert;
import org.junit.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StorageResolverTest
extends Assert {
    private static final String BASEDIR = System.getProperty("basedir") == null ? "./" : System.getProperty("basedir");
    private static final String SEP = System.getProperty("file.separator");

    @Test
    public void testStorageResolver() throws Exception {
        String string = BASEDIR + SEP + "src/test/resources" + SEP + "org" + SEP + "apache" + SEP + "xml" + SEP + "security" + SEP + "samples" + SEP + "input";
        FileInputStream fileInputStream = new FileInputStream(string + SEP + "keystore.jks");
        KeyStore keyStore = KeyStore.getInstance("JKS");
        keyStore.load(fileInputStream, "xmlsecurity".toCharArray());
        FileInputStream fileInputStream2 = new FileInputStream(string + SEP + "keystore2.jks");
        KeyStore keyStore2 = KeyStore.getInstance("JCEKS");
        keyStore2.load(fileInputStream2, "xmlsecurity".toCharArray());
        StorageResolver storageResolver = new StorageResolver(keyStore);
        storageResolver.add(keyStore2);
        Iterator iterator = storageResolver.getIterator();
        this.checkIterator(iterator);
        Iterator iterator2 = storageResolver.getIterator();
        this.checkIterator(iterator2);
        iterator = storageResolver.getIterator();
        iterator2 = storageResolver.getIterator();
        while (iterator.hasNext()) {
            X509Certificate x509Certificate;
            X509Certificate x509Certificate2 = (X509Certificate)iterator.next();
            if (x509Certificate2.equals(x509Certificate = (X509Certificate)iterator2.next())) continue;
            StorageResolverTest.fail((String)"StorageResolver iterators are not independent");
        }
        StorageResolverTest.assertFalse((boolean)iterator2.hasNext());
    }

    private void checkIterator(Iterator<?> iterator) {
        int n = 0;
        iterator.hasNext();
        while (iterator.hasNext()) {
            X509Certificate x509Certificate = (X509Certificate)iterator.next();
            x509Certificate.getSubjectX500Principal().getName();
            ++n;
        }
        StorageResolverTest.assertEquals((long)4L, (long)n);
        try {
            iterator.next();
            StorageResolverTest.fail((String)"Expecting NoSuchElementException");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }
}

