/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.test.secure_val;

import java.io.File;
import javax.xml.parsers.DocumentBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xml.security.Init;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.signature.Manifest;
import org.apache.xml.security.test.interop.InteropTestBase;
import org.apache.xml.security.utils.XMLUtils;
import org.junit.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ForbiddenRefCountTest
extends InteropTestBase {
    static Log log = LogFactory.getLog((String)ForbiddenRefCountTest.class.getName());

    @Test
    public void testReferenceCount() throws Exception {
        boolean bl = this.readAndVerifyManifest("src/test/resources/interop/c14n/Y4", "signature-manifest.xml", false);
        ForbiddenRefCountTest.assertTrue((boolean)bl);
        try {
            this.readAndVerifyManifest("src/test/resources/interop/c14n/Y4", "signature-manifest.xml", true);
            ForbiddenRefCountTest.fail((String)"Failure expected when secure validation is enabled");
        }
        catch (XMLSecurityException xMLSecurityException) {
            ForbiddenRefCountTest.assertTrue((boolean)xMLSecurityException.getMessage().contains("references are contained in the Manifest"));
        }
    }

    private boolean readAndVerifyManifest(String string, String string2, boolean bl) throws Exception {
        String string3 = System.getProperty("basedir");
        if (string3 != null && !"".equals(string3)) {
            string = string3 + "/" + string;
        }
        File file = new File(string + "/" + string2);
        DocumentBuilder documentBuilder = XMLUtils.createDocumentBuilder((boolean)false);
        Document document = documentBuilder.parse(file);
        Element element = (Element)document.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "SignedInfo").item(0);
        Manifest manifest = new Manifest(element, file.toURI().toURL().toString(), bl);
        return manifest.verifyReferences();
    }

    static {
        Init.init();
    }
}

