/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.test.secure_val;

import java.io.File;
import java.security.Key;
import javax.xml.parsers.DocumentBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xml.security.Init;
import org.apache.xml.security.signature.XMLSignature;
import org.apache.xml.security.signature.XMLSignatureException;
import org.apache.xml.security.test.interop.InteropTestBase;
import org.apache.xml.security.utils.XMLUtils;
import org.junit.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class WrappingAttackTest
extends InteropTestBase {
    static Log log = LogFactory.getLog((String)WrappingAttackTest.class.getName());

    @Test
    public void testWrappingAttack() throws Exception {
        boolean bl = this.readAndVerifySignature("src/test/resources/at/iaik/ixsil/coreFeatures/signatures", "manifestSignatureWrapping.xml");
        WrappingAttackTest.assertTrue((boolean)bl);
        try {
            this.readAndVerifySignatureAndSetManifest("src/test/resources/at/iaik/ixsil/coreFeatures/signatures", "manifestSignatureWrapping.xml");
            WrappingAttackTest.fail((String)"Failure expected when secure validation is enabled");
        }
        catch (XMLSignatureException xMLSignatureException) {
            WrappingAttackTest.assertTrue((boolean)xMLSignatureException.getMessage().contains("no XMLSignatureInput"));
        }
    }

    private boolean readAndVerifySignature(String string, String string2) throws Exception {
        String string3 = System.getProperty("basedir");
        if (string3 != null && !"".equals(string3)) {
            string = string3 + "/" + string;
        }
        File file = new File(string + "/" + string2);
        DocumentBuilder documentBuilder = XMLUtils.createDocumentBuilder((boolean)false, (boolean)false);
        Document document = documentBuilder.parse(file);
        Element element = (Element)document.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "Signature").item(0);
        XMLSignature xMLSignature = new XMLSignature(element, file.toURI().toURL().toString());
        return xMLSignature.checkSignatureValue((Key)xMLSignature.getKeyInfo().getPublicKey());
    }

    private boolean readAndVerifySignatureAndSetManifest(String string, String string2) throws Exception {
        String string3 = System.getProperty("basedir");
        if (string3 != null && !"".equals(string3)) {
            string = string3 + "/" + string;
        }
        File file = new File(string + "/" + string2);
        DocumentBuilder documentBuilder = XMLUtils.createDocumentBuilder((boolean)false, (boolean)false);
        Document document = documentBuilder.parse(file);
        Element element = (Element)document.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "Signature").item(0);
        Element element2 = (Element)document.getElementsByTagName("Manifest").item(0);
        element2.setIdAttribute("Id", true);
        XMLSignature xMLSignature = new XMLSignature(element, file.toURI().toURL().toString(), true);
        return xMLSignature.checkSignatureValue((Key)xMLSignature.getKeyInfo().getPublicKey());
    }

    static {
        Init.init();
    }
}

